/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import java.util.zip.DataFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.compression.DeflateRFC1951;
import org.sourceid.common.compression.ZLibRFC1950;
import org.sourceid.websso.servlet.HttpStatusCodeException;

public class Encoder {
    Log log = LogFactory.getLog(this.getClass());

    public String encodeSAMLMessage(String msg) {
        byte[] msgCompressed = DeflateRFC1951.deflate(msg);
        return B64.encode((byte[])msgCompressed);
    }

    public String decodeSAMLMessage(String encodedMsg) throws HttpStatusCodeException {
        byte[] msgCompressed = B64.decodeToBytes((String)encodedMsg);
        try {
            return DeflateRFC1951.inflate(msgCompressed);
        }
        catch (DataFormatException dfe) {
            this.log.error((Object)("Unable to inflate message: " + LogGuard.encode(encodedMsg)), (Throwable)dfe);
            try {
                byte[] decompressedBytes = ZLibRFC1950.decompress(msgCompressed);
                return new String(decompressedBytes, "UTF-8");
            }
            catch (IOException ioe) {
                this.log.error((Object)("Unable to decompress message: " + LogGuard.encode(encodedMsg)));
                throw new HttpStatusCodeException("Unable to decode SAML message.", 400);
            }
        }
    }
}

