/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import java.io.Serializable;
import org.sourceid.saml20.domain.SamlNameID;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;

public class NameIdHashKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    String partnerEntityId;
    SamlNameID nameId;
    String sessionIndex;

    public NameIdHashKey(String partnerEntityId, SamlNameID nameId) {
        this(partnerEntityId, nameId, null);
    }

    public NameIdHashKey(String partnerEntityId, NameIDType nameId) {
        this(partnerEntityId, nameId == null ? null : new SamlNameID(nameId), null);
    }

    public NameIdHashKey(String partnerEntityId, SamlNameID nameId, String sessionIndex) {
        this.partnerEntityId = partnerEntityId;
        this.nameId = nameId;
        this.sessionIndex = sessionIndex;
    }

    public NameIdHashKey(String partnerEntityId, NameIDType nameId, String sessionIndex) {
        this(partnerEntityId, nameId == null ? null : new SamlNameID(nameId), sessionIndex);
    }

    public String getPartnerEntityId() {
        return this.partnerEntityId;
    }

    public SamlNameID getNameId() {
        return this.nameId;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NameIdHashKey)) {
            return false;
        }
        NameIdHashKey otherKey = (NameIdHashKey)o;
        boolean isEqual = this.partnerEntityId.equals(otherKey.partnerEntityId);
        isEqual &= this.nameId.equals(otherKey.nameId);
        return isEqual &= this.sessionIndex != null ? this.sessionIndex.equals(otherKey.sessionIndex) : otherKey.sessionIndex == null;
    }

    public int hashCode() {
        int hash = this.partnerEntityId.hashCode();
        hash = 3 * hash + this.nameId.hashCode();
        if (this.sessionIndex != null) {
            hash = 3 * hash + this.sessionIndex.hashCode();
        }
        return hash;
    }
}

