/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;

public class SystemUtil {
    private static Log log = LogFactory.getLog(SystemUtil.class);
    public static final PrintWriter PRINT_WRITER_INSTANCE = new PrintWriter(System.out);

    public static void hardShutdown(String message) {
        SystemUtil.hardShutdown(message, null);
    }

    public static void hardShutdown(String message, Throwable throwable) {
        Halter halter;
        message = "Halting PingFederate server: " + (String)message;
        if (throwable != null) {
            log.fatal(message, throwable);
        } else {
            log.fatal(message);
        }
        try {
            halter = GlobalRegistry.getService(Halter.class);
        }
        catch (Exception e) {
            halter = new RealHalter();
        }
        halter.halt();
    }

    public static PrintWriter getPrintWriterInstance() {
        return PRINT_WRITER_INSTANCE;
    }

    public static class NoOpHalter
    implements Halter {
        @Override
        public void halt() {
        }
    }

    public static class RealHalter
    implements Halter {
        @Override
        public void halt() {
            Runtime.getRuntime().halt(-1);
        }
    }

    public static interface Halter {
        public void halt();
    }
}

