/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.token.TokenUtil;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.GlobalAuthnSessionPolicy;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.state.AuthnSourceUserKeyValue;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;

public class UserKeyAttributeUtil {
    private static final Log log = LogFactory.getLog(UserKeyAttributeUtil.class);
    public static final String DEFAULT_UNIQUE_USER_KEY_SEPARATOR = ".";
    public static final String USER_KEYS_TO_ASSOCIATE_WITH_SESSIONS = "adapterAuthnSourceIdsForUser";
    public static final String FIELD_ENABLE_REVOKE_SESSIONS_AFTER_PASSWORD_CHANGE_RESET = "Revoke Sessions After Password Change Or Reset";

    public static String resolveUniqueUserKeyValue(AdapterAuthnSourceKey adapterAuthnSourceKey, String uniqueUserKeyAttribute, AttributeMap adapterAttrMapValues) {
        if (!uniqueUserKeyAttribute.equals("pf_none")) {
            String userKeyAttributeValue;
            if (adapterAttrMapValues != null && (userKeyAttributeValue = adapterAttrMapValues.getSingleValue(uniqueUserKeyAttribute)) != null) {
                return UserKeyAttributeUtil.normalizeAndHashIfNecessary(userKeyAttributeValue);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find unique user key value because the attribute '" + uniqueUserKeyAttribute + "' was not found in the attribute mappings of adapter with key '" + adapterAuthnSourceKey + "'"));
            }
        }
        return null;
    }

    public static String normalizeAndHashIfNecessary(String unHashedUserIdentifierValue) {
        GlobalAuthnSessionPolicy globalAuthnSessionPolicy = MgmtFactory.getAuthnSessionPolicyManager().getGlobalPolicy();
        if (unHashedUserIdentifierValue == null) {
            return null;
        }
        if (globalAuthnSessionPolicy.isHashUniqueUserKeyAttribute()) {
            return TokenUtil.digestToken(unHashedUserIdentifierValue.trim().toLowerCase(Locale.ROOT));
        }
        return unHashedUserIdentifierValue.trim().toLowerCase(Locale.ROOT);
    }

    public static List<AuthnSourceUserKeyValue> getStateParamUserKeysToAssociateWithSessions(Map<String, Object> stateParams) {
        return Optional.ofNullable(stateParams).map(map -> map.get(USER_KEYS_TO_ASSOCIATE_WITH_SESSIONS)).filter(o -> o instanceof List).map(o -> (List)o).orElse(new LinkedList());
    }

    public static Set<String> getUniqueUserKeysFromStateParams(Map<String, Object> stateParams) {
        HashSet<String> uniqueUserKeyResultSet = new HashSet<String>();
        List<AuthnSourceUserKeyValue> stateParamsAuthnSourcesWithUserKeyValues = UserKeyAttributeUtil.getStateParamUserKeysToAssociateWithSessions(stateParams);
        for (AuthnSourceUserKeyValue authnSourceUserKeyValue : stateParamsAuthnSourcesWithUserKeyValues) {
            uniqueUserKeyResultSet.add(authnSourceUserKeyValue.getUserKeyValue());
        }
        if (stateParams != null) {
            stateParams.remove(USER_KEYS_TO_ASSOCIATE_WITH_SESSIONS);
        }
        return uniqueUserKeyResultSet;
    }

    public static String getUniqueUserKeyValue(AdapterAuthnSourceKey adapterAuthnSourceKey, Map<String, Object> sourceAttrs, HttpServletRequest request) throws AuthorizationException, AuthnAdapterException {
        if (adapterAuthnSourceKey != null) {
            IdpAuthnAdapterInstance idpAuthnAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstanceWithConnectionOverride(adapterAuthnSourceKey.getId(), adapterAuthnSourceKey.getConnectionId());
            if (idpAuthnAdapter != null) {
                String uniqueUserKeyAttribute = idpAuthnAdapter.getUniqueUserKeyAttribute();
                AuthnSourceSupport authnSourceSupportBase = new AuthnSourceSupport();
                AttributeMap adapterAttributeMap = authnSourceSupportBase.executeAdditionalMapping(adapterAuthnSourceKey, sourceAttrs, request, null, null);
                return UserKeyAttributeUtil.resolveUniqueUserKeyValue(adapterAuthnSourceKey, uniqueUserKeyAttribute, adapterAttributeMap);
            }
            throw new ProcessRuntimeException("Unable to find adapter with authentication source key '" + adapterAuthnSourceKey + "' when determining unique user key value.");
        }
        return null;
    }

    public static void logSriToUserKeysAssociation(Collection<String> userKeySet, String extendedSriStr) {
        ExtendedSri extendedSri;
        if (extendedSriStr == null) {
            log.debug((Object)"Unable to log SRI to user keys associations because extended SRI is empty.");
            return;
        }
        try {
            extendedSri = new ExtendedSri(extendedSriStr);
        }
        catch (InvalidParameterException e) {
            log.debug((Object)("Unable to log SRI to user keys associations because an invalid extended SRI provided: " + extendedSriStr));
            return;
        }
        for (String userKey : userKeySet) {
            IdpAuditLogger.logSessionAssociatedToUniqueUserKey(extendedSri, userKey, "User key and SRI association created.");
        }
    }
}

