/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.validation.CommonValidator;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.metadata.partner.ProtocolUtil;
import org.sourceid.websso.wrapper.BaseMessageContext;

public class VirtualIdentityUtil {
    private static final Log log = LogFactory.getLog(VirtualIdentityUtil.class);
    private static final String ALLOW_ANY_VSID_IN_AUDIENCE = "AllowAnyVirtualServerIdInAudience";
    private static ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.util.VirtualIdentityUtil");

    private VirtualIdentityUtil() {
    }

    public static VirtualIdentity resolve(BaseMessageContext context) {
        ConnectionBase connection = null;
        if (context != null) {
            connection = MetadataSupport.getBaseConnectionMetadata(context);
        }
        return VirtualIdentityUtil.resolve(context, connection);
    }

    public static VirtualIdentity resolve(BaseMessageContext context, ConnectionBase connection) {
        String vsid = null;
        if (context != null) {
            vsid = context.getVirtualServerId();
        }
        return VirtualIdentityUtil.resolve(vsid, connection, false);
    }

    public static VirtualIdentity resolve(BaseMessageContext context, HttpServletRequest request) {
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(context);
        return VirtualIdentityUtil.resolve(connection, request);
    }

    public static VirtualIdentity resolve(ConnectionBase connection, HttpServletRequest request) {
        String vsid = VirtualIdentityUtil.extractVsid(request);
        return VirtualIdentityUtil.resolve(vsid, connection, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirtualIdentity resolve(String vsid, ConnectionBase connection, boolean fallbackToDefault) {
        VirtualIdentity virtualIdentity = null;
        if (connection == null) {
            return null;
        }
        VirtualIdentity defaultVirtualIdForRuntime = VirtualIdentityUtil.getDefaultVirtualIdForRuntime(connection);
        if (!StringUtils.isNotEmpty((String)vsid)) return defaultVirtualIdForRuntime;
        HashMap<String, VirtualIdentity> virtualIdentityMap = new HashMap<String, VirtualIdentity>();
        for (VirtualIdentity vid : connection.getVirtualIdentities()) {
            if (vid.getVirtualEntityId(DomainMode.RUNTIME) == null) continue;
            virtualIdentityMap.put(vid.getVirtualEntityId(DomainMode.RUNTIME), vid);
        }
        if (virtualIdentityMap.containsKey(vsid)) {
            return (VirtualIdentity)virtualIdentityMap.get(vsid);
        }
        if (fallbackToDefault) return defaultVirtualIdForRuntime;
        if (defaultVirtualIdForRuntime == null) throw new IllegalArgumentException("Invalid Virtual server ID: " + vsid);
        if (!vsid.equals(defaultVirtualIdForRuntime.getVirtualEntityId(DomainMode.RUNTIME))) throw new IllegalArgumentException("Invalid Virtual server ID: " + vsid);
        return defaultVirtualIdForRuntime;
    }

    public static List<String> getVsidsForRuntime(ConnectionBase conn) {
        String defaultVsid;
        ArrayList<String> entityIds = new ArrayList<String>();
        for (VirtualIdentity virtualIdentity : conn.getVirtualIdentities()) {
            String entityId = virtualIdentity.getVirtualEntityId(DomainMode.RUNTIME);
            if (!StringUtils.isNotEmpty((String)entityId)) continue;
            entityIds.add(entityId);
        }
        if (entityIds.isEmpty() && StringUtils.isNotEmpty((String)(defaultVsid = ProtocolUtil.getGlobalDefaultVirtualId(conn).getVirtualEntityId(DomainMode.RUNTIME)))) {
            entityIds.add(defaultVsid);
        }
        return entityIds;
    }

    public static VirtualIdentity getDefaultVirtualIdForRuntime(ConnectionBase connection) {
        VirtualIdentity connDefault = connection.getDefaultVirtualIdentity();
        if (connDefault.getVirtualEntityId(DomainMode.RUNTIME) != null) {
            return connDefault;
        }
        return ProtocolUtil.getGlobalDefaultVirtualId(connection);
    }

    public static String extractVsid(HttpServletRequest request) {
        PathUtil pathUtil;
        Map<String, Object> paramMap;
        String path;
        String vsid = null;
        if (request != null && StringUtils.isEmpty((String)(vsid = request.getParameter("vsid"))) && StringUtils.isNotBlank((String)(path = request.getServletPath())) && (paramMap = (pathUtil = MetaDataFactory.getLocalMetaData().getPathUtil()).getDecodedParamMap(path)).containsKey("vsid")) {
            vsid = (String)paramMap.get("vsid");
        }
        if (StringUtils.isNotEmpty(vsid) && !CommonValidator.isValidEntityId(vsid)) {
            throw new RuntimeException("The requested virtual server ID is invalid: " + vsid);
        }
        return vsid;
    }

    public static String extractParam(HttpServletRequest request, String param) {
        PathUtil pathUtil;
        Map<String, Object> paramMap;
        String path;
        String vsid = null;
        if (request != null && StringUtils.isEmpty((String)(vsid = request.getParameter(param))) && StringUtils.isNotBlank((String)(path = request.getServletPath())) && (paramMap = (pathUtil = MetaDataFactory.getLocalMetaData().getPathUtil()).getDecodedParamMap(path)).containsKey(param)) {
            vsid = (String)paramMap.get(param);
        }
        if (StringUtils.isNotEmpty(vsid) && !CommonValidator.isValidEntityId(vsid)) {
            throw new RuntimeException("The requested " + param + " is invalid: " + vsid);
        }
        return vsid;
    }

    public static List<String> getAllowedAudiences(BaseMessageContext context, ConnectionBase connection) {
        ArrayList<String> allowedAudiences = new ArrayList<String>();
        if (configStore.getMapValue(ALLOW_ANY_VSID_IN_AUDIENCE, Collections.emptyMap()).containsKey(connection.getEntityId())) {
            for (VirtualIdentity virtualIdentity : connection.getVirtualIdentities()) {
                String entityId = virtualIdentity.getVirtualEntityId(DomainMode.RUNTIME);
                if (!StringUtils.isNotEmpty((String)entityId)) continue;
                allowedAudiences.add(entityId);
            }
            log.debug((Object)("Allowing all virtual server ID's in audience for assertions received from " + connection.getEntityId() + ". Allowed audiences: " + allowedAudiences));
        } else {
            String entityId = VirtualIdentityUtil.resolve(context, connection).getVirtualEntityId(DomainMode.RUNTIME);
            if (entityId != null) {
                allowedAudiences.add(entityId);
            }
        }
        return allowedAudiences;
    }
}

