/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import com.pingidentity.common.util.LogGuard;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected Log log = LogFactory.getLog(this.getClass());

    public void init(FilterConfig fc) throws ServletException {
        this.filterConfig = fc;
    }

    public abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            this.log.error((Object)("Non Http Request(" + LogGuard.encode(String.valueOf(servletRequest)) + ") Response(" + LogGuard.encode(String.valueOf(servletResponse)) + ")"));
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }
}

