/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.servlet.filter.AbstractHttpFilter;
import org.sourceid.util.log.internal.HttpRequestLoggingUtil;

public class HttpRequestParameterFilter
extends AbstractHttpFilter {
    private static final Log LOG = LogFactory.getLog(HttpRequestParameterFilter.class);
    private static final List<String> ALLOWED_METHODS = Arrays.asList("HEAD", "GET", "OPTIONS", "TRACE");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpRequestLoggingUtil.init(request);
            if (LOG.isTraceEnabled()) {
                String requestTo = request.getMethod() + " " + request.getRequestURI() + " " + request.getProtocol() + System.lineSeparator();
                String paramsMsg = this.constructLogMsg(request);
                if (paramsMsg.length() > 0) {
                    LOG.trace((Object)(System.lineSeparator() + requestTo + paramsMsg));
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            HttpRequestLoggingUtil.cleanup();
        }
    }

    private String constructLogMsg(HttpServletRequest request) {
        if (!ALLOWED_METHODS.contains(request.getMethod()) || request.getParameterMap().size() < 1) {
            return "";
        }
        StringBuilder logMsg = new StringBuilder();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            logMsg.append(param).append(": ").append(HttpRequestLoggingUtil.getHttpParameterValue(param)).append(System.lineSeparator());
        }
        return logMsg.toString();
    }
}

