/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import com.pingidentity.monitoring.metrics.MeterManager;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public class HttpRequestStatisticsFilter
extends AbstractHttpFilter {
    private static ConcurrentMap<MeterManager.NodeContext, AtomicInteger> activeReqCountMap = new ConcurrentHashMap<MeterManager.NodeContext, AtomicInteger>();
    private MeterManager.NodeContext filterContext = MeterManager.NodeContext.ENGINE;

    @Override
    public void init(FilterConfig fc) throws ServletException {
        super.init(fc);
        String context = fc.getInitParameter("context");
        if (MeterManager.NodeContext.ADMIN.nameMatches(context)) {
            this.filterContext = MeterManager.NodeContext.ADMIN;
        }
        activeReqCountMap.putIfAbsent(this.filterContext, new AtomicInteger(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Instant startInstant = Instant.now();
        MeterManager meterManager = MeterManager.getInstance();
        AtomicInteger concurrentReqCount = (AtomicInteger)activeReqCountMap.get((Object)this.filterContext);
        meterManager.getConcurrentRequestSummary(this.filterContext).record((double)concurrentReqCount.incrementAndGet());
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Instant finishedInstant = Instant.now();
            Duration elapsedDuration = Duration.between(startInstant, finishedInstant);
            meterManager.getConcurrentRequestSummary(this.filterContext).record((double)concurrentReqCount.decrementAndGet());
            meterManager.getHttpResponseTimer(this.filterContext).record(elapsedDuration);
            meterManager.recordResponseCode(this.filterContext, response);
        }
    }
}

