/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.mina.util.ConcurrentHashSet;
import org.sourceid.servlet.filter.ServletRequestCleanupCallback;

public class ServletRequestCleanupService {
    private static final Logger logger = LogManager.getLogger(ServletRequestCleanupService.class);
    private static final ServletRequestCleanupService runtimeInstance = new ServletRequestCleanupService();
    private static final ServletRequestCleanupService adminInstance = new ServletRequestCleanupService();
    private Set<ServletRequestCleanupCallback> callbacks = new ConcurrentHashSet();

    public static ServletRequestCleanupService getRuntimeInstance() {
        return runtimeInstance;
    }

    public static ServletRequestCleanupService getAdminInstance() {
        return adminInstance;
    }

    public void addCleanupCallback(ServletRequestCleanupCallback callback) {
        this.callbacks.add(callback);
    }

    public void doFilter(ServletContext context, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Throwable filterException = null;
        try {
            if (filterChain != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Throwable tf) {
            filterException = tf;
        }
        for (ServletRequestCleanupCallback callback : this.callbacks) {
            try {
                callback.cleanup(context, request, response);
            }
            catch (Throwable tc) {
                try {
                    logger.error("Cleanup callback execution failed", tc);
                }
                catch (Throwable throwable) {}
            }
        }
        if (filterException != null) {
            if (filterException instanceof ServletException) {
                throw (ServletException)filterException;
            }
            if (filterException instanceof IOException) {
                throw (IOException)filterException;
            }
            if (filterException instanceof RuntimeException) {
                throw (RuntimeException)filterException;
            }
            throw new RuntimeException(filterException);
        }
    }
}

