/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.filter;

import com.pingidentity.common.util.CookieMonster;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.impl.Mode;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.service.impl.grouprpc.AssertionReplayPreventionServiceGroupRpcImpl;
import org.sourceid.saml20.service.impl.localmemory.AssertionReplayPreventionSvcInMemoryImpl;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public class SimultaneousAuthnRequestCheckingFilter
extends AbstractHttpFilter {
    private static Log log = LogFactory.getLog(SimultaneousAuthnRequestCheckingFilter.class);
    private static ConfigStore configStore = ConfigStoreFarm.getConfig(SimultaneousAuthnRequestCheckingFilter.class);
    private static String DEFAULT_COOKIE_NAME = "pfbid";
    private static int DEFAULT_RETENTION_DURATION_SECONDS = 60;
    private static int DEFAULT_RESUBMIT_INTERVAL_MS = 2500;
    private static String ATTR_BROWSER_ID = "SARCF.BrowserId";
    private static AssertionReplayPreventionService txTracker = new AssertionReplayPreventionSvcInMemoryImpl(2000L);
    private static String browserIdCookieName = DEFAULT_COOKIE_NAME;
    private static boolean enableClustering = false;
    private static boolean enableFiltering = false;
    public static final String FILTER_NAME = "org.sourceid.servlet.filter.SimultaneousAuthnRequestCheckingFilter";

    private static void reInit() {
        if (configStore.getBooleanValue("enable", false)) {
            log.info((Object)"SimultaneousAuthnRequestCheckingFilter is enabled");
            boolean bl = enableClustering = configStore.getBooleanValue("enable-clustering", false) && ModeSupport.getMode() != Mode.STANDALONE;
            if (enableClustering) {
                try {
                    log.info((Object)"instantiate AssertionReplayPreventionServiceGroupRpcImpl() for SimultaneousAuthnRequestCheckingFilter");
                    txTracker = new AssertionReplayPreventionServiceGroupRpcImpl();
                }
                catch (Exception e) {
                    log.error((Object)"Problem setting up cluster checking for simultaneous AuthnRequests", (Throwable)e);
                }
            } else {
                log.info((Object)"instantiate AssertionReplayPreventionSvcInMemoryImpl() for SimultaneousAuthnRequestCheckingFilter");
                txTracker = new AssertionReplayPreventionSvcInMemoryImpl(2000L);
            }
        }
    }

    public static void clearTx(HttpServletRequest req) {
        if (configStore.getBooleanValue("enable", false)) {
            String browserIdentifier = SimultaneousAuthnRequestCheckingFilter.getBrowserId(req);
            SimultaneousAuthnRequestCheckingFilter.leave(browserIdentifier);
        }
    }

    private static String getBrowserId(HttpServletRequest req) {
        String browserIdentifier = (String)req.getAttribute(ATTR_BROWSER_ID);
        if (browserIdentifier == null) {
            browserIdentifier = CookieMonster.getCookieValue(browserIdCookieName, req);
        }
        return browserIdentifier;
    }

    private static synchronized void leave(String browserId) {
        txTracker.clear(browserId);
    }

    private static synchronized boolean enter(String browserId, Calendar exp) throws BearerAssertionReplayPreventionServiceException {
        return txTracker.isReplay(browserId, exp);
    }

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        int numOfRetryAttempts;
        boolean newEnableFiltering = configStore.getBooleanValue("enable", false);
        if (newEnableFiltering != enableFiltering) {
            enableFiltering = newEnableFiltering;
            SimultaneousAuthnRequestCheckingFilter.reInit();
        }
        String wsAction = req.getParameter("wa");
        if (!enableFiltering || wsAction != null && ("wsignout1.0".equals(wsAction) || "wsignoutcleanup1.0".equals(wsAction))) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        browserIdCookieName = configStore.getStringValue("browser-id-cookie-name", DEFAULT_COOKIE_NAME);
        boolean browserIdCookieSecure = configStore.getBooleanValue("browser-id-cookie-secure-flag", true);
        boolean browserIdCookieHttpOnly = configStore.getBooleanValue("browser-id-cookie-httponly-flag", true);
        int retentionDuration = configStore.getIntValue("retention-duration-seconds", DEFAULT_RETENTION_DURATION_SECONDS);
        int resubmitIntervalFromConf = configStore.getIntValue("speed-bump-resubmit-interval-milliseconds", DEFAULT_RESUBMIT_INTERVAL_MS);
        int maxNumberOfRetryAttempts = retentionDuration * 1000 / resubmitIntervalFromConf;
        int randomRange = resubmitIntervalFromConf * 6 / 10;
        Random randomGenerator = new Random();
        int randomPart = randomGenerator.nextInt(randomRange);
        int resubmitInterval = resubmitIntervalFromConf * 7 / 10 + randomPart;
        String browserIdentifier = CookieMonster.getCookieValue(browserIdCookieName, req);
        boolean newDevice = false;
        if (StringUtils.isBlank((String)browserIdentifier)) {
            browserIdentifier = IDGenerator.rndStr(20, IDGenerator.ALPHA_NUMERICS);
            Cookie cookie = new Cookie(browserIdCookieName, browserIdentifier);
            cookie.setMaxAge(31557600);
            cookie.setPath("/");
            cookie.setHttpOnly(browserIdCookieHttpOnly);
            cookie.setSecure(browserIdCookieSecure);
            resp.addCookie(cookie);
            req.setAttribute(ATTR_BROWSER_ID, (Object)browserIdentifier);
            newDevice = true;
        }
        Calendar exp = Util.getUtcCalendar();
        exp.add(13, retentionDuration);
        boolean needToWait = false;
        if (newDevice && this.isShowSpeedBumpForNewDevices()) {
            needToWait = true;
        } else {
            try {
                needToWait = SimultaneousAuthnRequestCheckingFilter.enter(browserIdentifier, exp);
            }
            catch (BearerAssertionReplayPreventionServiceException e) {
                log.warn((Object)"Problem checking for simultaneous AuthnRequests.", (Throwable)e);
            }
        }
        String attempts = req.getParameter("attempts");
        try {
            numOfRetryAttempts = Integer.parseInt(attempts);
        }
        catch (Exception e) {
            numOfRetryAttempts = 0;
        }
        if (req.getParameter("skip.simultaneous.authn.req.check") == null && needToWait && numOfRetryAttempts < maxNumberOfRetryAttempts) {
            HashMap<String, String> controls = new HashMap<String, String>();
            Enumeration parameterNames = req.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String value = req.getParameter(name);
                controls.put(name, value);
            }
            attempts = String.valueOf(++numOfRetryAttempts);
            controls.put("attempts", attempts);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("formControls", controls);
            params.put("action", req.getRequestURI());
            params.put("method", req.getMethod());
            params.put("resubmitinterval", resubmitInterval);
            ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
            renderer.render(req, resp, "speed.bump.template.html", params, "text/html", false);
        } else {
            req.setAttribute(FILTER_NAME, (Object)true);
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private boolean isShowSpeedBumpForNewDevices() {
        return configStore.getBooleanValue("show-speed-bump-for-new-devices", true);
    }

    static {
        enableFiltering = configStore.getBooleanValue("enable", false);
        SimultaneousAuthnRequestCheckingFilter.reInit();
    }
}

