/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.servlet.streams;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LengthLimitServletInputStream
extends ServletInputStream {
    private static final String PF_RUNTIME_HTTP_MAX_REQUEST_SIZE_PROPERTY = "pf.runtime.http.maxRequestBodySize";
    private static final String PF_RUNTIME_HTTP_MAX_REQUEST_SIZE = System.getProperty("pf.runtime.http.maxRequestBodySize");
    private static final int PF_RUNTIME_HTTP_MAX_REQUEST_DEFAULT_SIZE = 200000;
    private static final Log log = LogFactory.getLog(LengthLimitServletInputStream.class);
    private final ServletInputStream inputStream;
    private final long limit;
    private long counter = 0L;

    public LengthLimitServletInputStream(ServletInputStream inputStream, long limit) {
        this.inputStream = inputStream;
        this.limit = limit;
    }

    public LengthLimitServletInputStream(ServletInputStream inputStream) {
        this(inputStream, NumberUtils.toLong((String)PF_RUNTIME_HTTP_MAX_REQUEST_SIZE, (long)200000L));
    }

    public boolean isFinished() {
        return this.inputStream.isFinished();
    }

    public boolean isReady() {
        return this.inputStream.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        this.inputStream.setReadListener(readListener);
    }

    public int read() throws IOException {
        if (this.counter > this.limit) {
            String msg = String.format("InputStream reached its size limit of [%d] bytes", this.limit);
            log.error((Object)msg);
            throw new IOException(msg);
        }
        int ch = this.inputStream.read();
        if (ch != -1) {
            ++this.counter;
        }
        return ch;
    }
}

