/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.lang.IntegrityException;
import org.jose4j.lang.JoseException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PFInternalTokenSettingsManager;
import org.sourceid.token.PFInternalTokenSetting;
import org.sourceid.token.jwt.JWTKeyDerivationUtil;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.SystemKeyState;

final class InternalTokenJwtHelper {
    private final PFInternalTokenSettingsManager pfInternalTokenSettingsManager;

    InternalTokenJwtHelper(PFInternalTokenSettingsManager pfInternalTokenSettingsManager) {
        this.pfInternalTokenSettingsManager = pfInternalTokenSettingsManager;
    }

    InternalTokenJwtHelper() {
        this(MgmtFactory.getPFInternalTokenSettingsManager());
    }

    public String encryptParams(String eventIdentifier, JwtClaims claims) throws PFInternalTokenException {
        try {
            PFInternalTokenSetting tokenSettings = this.pfInternalTokenSettingsManager.getPFInternalTokenSettings();
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(claims.toJson());
            jwe.setAlgorithmHeaderValue("dir");
            jwe.setEncryptionMethodHeaderParameter(tokenSettings.getAlgorithmType());
            if (tokenSettings.getCurrentKey() == null) {
                throw new PFInternalTokenException("No System Keys available to derive a Key.");
            }
            byte[] configuredKey = tokenSettings.getCurrentSecret();
            SecretKey derivedKey = JWTKeyDerivationUtil.derive(eventIdentifier, configuredKey, tokenSettings.getAlgorithmType());
            jwe.setKey((Key)derivedKey);
            return jwe.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new PFInternalTokenException((Exception)((Object)e));
        }
    }

    public JwtClaims getJwtClaims(String token, String eventType, String algName, MutableObject<SystemKeyState> keyUsedState) throws InvalidJwtException, PFInternalTokenException {
        for (SystemKeyState keyState : Arrays.asList(SystemKeyState.CURRENT, SystemKeyState.PENDING, SystemKeyState.PREVIOUS)) {
            byte[] key = this.getConfiguredSystemKey(keyState);
            SecretKey derivedKey = JWTKeyDerivationUtil.derive(eventType, key, algName);
            JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setDisableRequireSignature().setDecryptionKey((Key)derivedKey);
            JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
            try {
                JwtContext jwtContext = jwtConsumer.process(token);
                JwtClaims claims = jwtContext.getJwtClaims();
                keyUsedState.setValue((Object)keyState);
                return claims;
            }
            catch (InvalidJwtException e) {
                if (e.getCause() != null && e.getCause() instanceof IntegrityException) continue;
                throw e;
            }
        }
        throw new PFInternalTokenException(0, "Unable to translate token using the configured System Keys.");
    }

    private byte[] getConfiguredSystemKey(SystemKeyState keyState) throws PFInternalTokenException {
        String key = null;
        PFInternalTokenSetting tokenSettings = this.pfInternalTokenSettingsManager.getPFInternalTokenSettings();
        if (keyState == SystemKeyState.CURRENT) {
            return tokenSettings.getCurrentSecret();
        }
        if (keyState == SystemKeyState.PENDING) {
            key = tokenSettings.getPendingKey().getKey();
        } else if (keyState == SystemKeyState.PREVIOUS) {
            if (tokenSettings.getPreviousKey() == null) {
                throw new PFInternalTokenException("Unable to decrypt the input token with current and pending key.");
            }
            key = tokenSettings.getPreviousKey().getKey();
        }
        if (key != null) {
            return tokenSettings.getReversedKey(key);
        }
        throw new PFInternalTokenException("Unable to decrypt the input token with current, pending and previous key.");
    }
}

