/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.token.PFInternalTokenGenerator;
import org.sourceid.token.PFInternalTokenTranslator;
import org.sourceid.token.jwt.InternalTokenJwtHelper;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.SystemKeyState;
import org.sourceid.token.jwt.TokenInfo;

public class JwtTokenGeneratorImpl
implements PFInternalTokenGenerator<String, AttributeValue> {
    private final PFInternalTokenTranslator<String, AttributeValue> translator;
    private final InternalTokenJwtHelper internalTokenJwtHelper;

    public JwtTokenGeneratorImpl(PFInternalTokenTranslator<String, AttributeValue> translator) {
        this(translator, new InternalTokenJwtHelper());
    }

    JwtTokenGeneratorImpl(PFInternalTokenTranslator<String, AttributeValue> translator, InternalTokenJwtHelper internalTokenJwtHelper) {
        this.translator = translator;
        this.internalTokenJwtHelper = internalTokenJwtHelper;
    }

    @Override
    public String encrypt(Map<String, AttributeValue> attributes) throws PFInternalTokenException {
        JwtClaims claims = this.translator.translate(attributes);
        return this.internalTokenJwtHelper.encryptParams(this.translator.getEventType(), claims);
    }

    @Override
    public Map<String, AttributeValue> decrypt(String token) throws PFInternalTokenException {
        return this.decryptWithInfo(token).getAttributes();
    }

    @Override
    public TokenInfo<String, AttributeValue> decryptWithInfo(String token) throws PFInternalTokenException {
        try {
            JsonWebStructure jsonToken = JsonWebStructure.fromCompactSerialization((String)token);
            String algName = jsonToken.getHeader("enc");
            MutableObject keyUsedState = new MutableObject();
            JwtClaims claims = this.internalTokenJwtHelper.getJwtClaims(token, this.translator.getEventType(), algName, (MutableObject<SystemKeyState>)keyUsedState);
            return new TokenInfo<String, AttributeValue>(this.translator.translate(claims), (SystemKeyState)((Object)keyUsedState.getValue()));
        }
        catch (InvalidJwtException e) {
            if (e.hasErrorCode(1)) {
                PFInternalTokenException exception = new PFInternalTokenException((Exception)((Object)e));
                exception.setError(1);
                throw exception;
            }
            throw new PFInternalTokenException((Exception)((Object)e));
        }
        catch (JoseException e) {
            throw new PFInternalTokenException((Exception)((Object)e));
        }
    }

    @Override
    public Map<String, AttributeValue> getClaimsFromExpiredJwt(PFInternalTokenException e) throws PFInternalTokenException {
        InvalidJwtException jwtException = (InvalidJwtException)e.getCause();
        if (jwtException.hasErrorCode(1) && jwtException.getErrorDetails().size() == 1) {
            JwtClaims jwtClaims = Optional.ofNullable(jwtException.getJwtContext()).map(JwtContext::getJwtClaims).orElse(new JwtClaims());
            return this.translator.translate(jwtClaims);
        }
        throw new PFInternalTokenException("Unable to get claims. Reasons other than expired token exists.", (Exception)((Object)jwtException));
    }
}

