/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import com.unboundid.util.StaticUtils;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.token.PFInternalTokenTranslator;
import org.sourceid.token.jwt.LocalIdentityJwtClaimName;
import org.sourceid.token.jwt.PFInternalTokenException;

public class PFLocalIdentityToJwtTranslator
implements PFInternalTokenTranslator<String, AttributeValue> {
    private static final String LOCAL_IDENTITY_EVENT_TYPE = "liEvent";
    public static final int MIN_JWT_ID_LENGTH = 22;

    @Override
    public JwtClaims translate(Map<String, AttributeValue> claims) throws PFInternalTokenException {
        JwtClaims jwtClaims = new JwtClaims();
        for (LocalIdentityJwtClaimName emailVerificationJwtClaimName : LocalIdentityJwtClaimName.values()) {
            String attributeName = emailVerificationJwtClaimName.getLocalIdentityAttributeName();
            String jwtClaimName = emailVerificationJwtClaimName.getJwtClaimName();
            if (LocalIdentityJwtClaimName.CREATION_TIME == emailVerificationJwtClaimName) {
                jwtClaims.setIssuedAtToNow();
                continue;
            }
            if (LocalIdentityJwtClaimName.CODE == emailVerificationJwtClaimName) {
                if (claims.get(attributeName) == null) {
                    throw new PFInternalTokenException("'" + attributeName + "' is a required attribute to generate Verify Email Link.");
                }
                if (claims.get(attributeName).getValue().length() < 22) {
                    throw new PFInternalTokenException("The size of attribute '" + attributeName + "' does not meet the minimum length for a JWT ID of 22");
                }
                jwtClaims.setClaim(jwtClaimName, (Object)claims.get(attributeName).getValue());
                continue;
            }
            String value = claims.get(attributeName).getValue();
            jwtClaims.setClaim(jwtClaimName, (Object)value);
        }
        return jwtClaims;
    }

    @Override
    public Map<String, AttributeValue> translate(JwtClaims claims) throws PFInternalTokenException {
        HashMap<String, AttributeValue> emailVerificationValue = new HashMap<String, AttributeValue>();
        for (LocalIdentityJwtClaimName emailVerificationJwtClaimName : LocalIdentityJwtClaimName.values()) {
            if (LocalIdentityJwtClaimName.CREATION_TIME == emailVerificationJwtClaimName) {
                try {
                    NumericDate issuedAt = claims.getIssuedAt();
                    emailVerificationValue.put(emailVerificationJwtClaimName.getLocalIdentityAttributeName(), new AttributeValue(StaticUtils.encodeGeneralizedTime((long)issuedAt.getValueInMillis())));
                    continue;
                }
                catch (MalformedClaimException e) {
                    throw new PFInternalTokenException("Unable to parse the token issued time." + e.getMessage());
                }
            }
            String value = (String)claims.getClaimValue(emailVerificationJwtClaimName.getJwtClaimName());
            emailVerificationValue.put(emailVerificationJwtClaimName.getLocalIdentityAttributeName(), new AttributeValue(value));
        }
        return emailVerificationValue;
    }

    @Override
    public String getEventType() {
        return LOCAL_IDENTITY_EVENT_TYPE;
    }
}

