/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.token.jwt;

import java.util.HashMap;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.token.PFInternalTokenTranslator;
import org.sourceid.token.jwt.PFInternalTokenException;

public class PFResetPasswordtoJwtTranslator
implements PFInternalTokenTranslator<String, AttributeValue> {
    private static final String PASSWORD_RESET_EVENT_TYPE = "prEvent";
    public static final String ATTR_KEY_API_APP_ID = "prAuthnApiAppID";
    public static final String ATTR_KEY_CODE = "prCodeMapCode";
    public static final String ATTR_KEY_TIME = "prCodeMapTime";
    public static final String ATTR_KEY_EXP_TIME = "prExpTime";
    public static final String ATTR_KEY_USERNAME = "prUsername";
    public static final String ATTR_KEY_PCV_ID = "pcvId";
    public static final String ATTR_KEY_REMEMBER_USERNAME = "prEnableRememberUsername";
    public static final String ATTR_KEY_ADAPTER_ID = "adapterId";
    public static final int MIN_JWT_ID_LENGTH = 22;

    @Override
    public JwtClaims translate(Map<String, AttributeValue> resetAttributes) throws PFInternalTokenException {
        JwtClaims jwtClaims = new JwtClaims();
        boolean isFromAuthnApi = resetAttributes.containsKey(ATTR_KEY_API_APP_ID);
        Map<String, String> attributeMap = this.getAttributeToClaimNameMap(isFromAuthnApi);
        if (attributeMap != null) {
            for (Map.Entry<String, String> attribute : attributeMap.entrySet()) {
                if ("exp".equals(attribute.getValue())) {
                    if (resetAttributes.get(attribute.getKey()) == null || resetAttributes.get(attribute.getKey()).getValue() == null) {
                        throw new PFInternalTokenException("Unable to find the required value for '" + attribute.getValue() + "' in Password Reset user attributes.");
                    }
                    String validityTime = resetAttributes.get(attribute.getKey()).getValue();
                    jwtClaims.setExpirationTime(NumericDate.fromMilliseconds((long)Long.parseLong(validityTime)));
                    continue;
                }
                if ("jti".equals(attribute.getValue())) {
                    if (resetAttributes.get(attribute.getKey()) == null) {
                        throw new PFInternalTokenException("Unable to find the required value for '" + attribute.getKey() + "' in Password Reset user attributes..");
                    }
                    if (resetAttributes.get(attribute.getKey()).getValue().length() < 22) {
                        throw new PFInternalTokenException("The size of attribute '" + attribute.getKey() + "' does not meet the minimum length for a JWT ID of 22");
                    }
                    jwtClaims.setClaim(attribute.getValue(), (Object)resetAttributes.get(attribute.getKey()).getValue());
                    continue;
                }
                if (resetAttributes.get(attribute.getKey()) == null) continue;
                String value = resetAttributes.get(attribute.getKey()).getValue();
                jwtClaims.setClaim(attribute.getValue(), (Object)value);
            }
        }
        return jwtClaims;
    }

    @Override
    public Map<String, AttributeValue> translate(JwtClaims claims) {
        HashMap<String, AttributeValue> passwordResetValue = new HashMap<String, AttributeValue>();
        Map<String, String> attributeMap = this.getAllAttributeToClaimNameMap();
        if (attributeMap != null) {
            for (Map.Entry<String, String> attributeName : attributeMap.entrySet()) {
                if ("exp".equals(attributeName.getValue())) {
                    try {
                        NumericDate expTime = claims.getExpirationTime();
                        passwordResetValue.put(attributeName.getKey(), new AttributeValue(String.valueOf(expTime.getValueInMillis())));
                    }
                    catch (MalformedClaimException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String value = (String)claims.getClaimValue(attributeName.getValue());
                passwordResetValue.put(attributeName.getKey(), new AttributeValue(value));
            }
        }
        return passwordResetValue;
    }

    @Override
    public String getEventType() {
        return PASSWORD_RESET_EVENT_TYPE;
    }

    protected Map<String, String> getAllAttributeToClaimNameMap() {
        return this.getAttributeToClaimNameMap(true);
    }

    protected Map<String, String> getAttributeToClaimNameMap(boolean isFromAuthnApi) {
        HashMap<String, String> passwordResetToJwtClaim = new HashMap<String, String>();
        passwordResetToJwtClaim.put(AdapterDefaultTemplateParams.ADAPTER_ID.getParamName(), "a");
        passwordResetToJwtClaim.put(ATTR_KEY_PCV_ID, "p");
        passwordResetToJwtClaim.put(ATTR_KEY_USERNAME, "sub");
        passwordResetToJwtClaim.put(ATTR_KEY_REMEMBER_USERNAME, "r");
        passwordResetToJwtClaim.put(ATTR_KEY_CODE, "jti");
        passwordResetToJwtClaim.put(ATTR_KEY_EXP_TIME, "exp");
        passwordResetToJwtClaim.put(AdapterDefaultTemplateParams.ENTITY_ID.getParamName(), "e");
        passwordResetToJwtClaim.put(AdapterDefaultTemplateParams.CLIENT_ID.getParamName(), "c");
        if (isFromAuthnApi) {
            passwordResetToJwtClaim.put(ATTR_KEY_API_APP_ID, "app");
        }
        return passwordResetToJwtClaim;
    }
}

