/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class AttributeWriter {
    public static final String CONTENT_TYPE = "text/html";

    public static void writeResponse(HttpServletResponse resp, String name, AttributeValue attribute) throws IOException {
        AttributeWriter.setContentType(resp);
        AttributeWriter.writeAttribute(name, attribute, resp.getWriter());
    }

    public static void writeResponse(HttpServletResponse resp, Map<String, AttributeValue> attributes) throws IOException {
        AttributeWriter.setContentType(resp);
        AttributeWriter.writeAttributes(attributes, resp.getWriter());
    }

    private static void setContentType(HttpServletResponse resp) {
        resp.setContentType(CONTENT_TYPE);
        resp.setCharacterEncoding("UTF-8");
    }

    static void writeAttributes(Map<String, AttributeValue> attributes, PrintWriter writer) {
        if (attributes != null) {
            for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
                AttributeWriter.writeAttribute(entry.getKey(), entry.getValue(), writer);
            }
        }
    }

    private static void writeAttribute(String key, AttributeValue value, PrintWriter writer) {
        if (value != null) {
            for (String val : value.getValues()) {
                AttributeWriter.writeNV(writer, key, val);
            }
        }
    }

    public static void writeNV(PrintWriter writer, String key, Object value) {
        writer.print(key);
        writer.print("=");
        writer.print(value);
        writer.print("\n");
    }
}

