/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.sdk.oauth20.ClientData;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.oauth.client.xmlbinding.ClientDocument;
import org.sourceid.oauth.client.xmlbinding.ClientType;
import org.sourceid.oauth.client.xmlbinding.GrantTypeType;
import org.sourceid.oauth.client.xmlbinding.SupplementalInfoType;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientManagerTranslator {
    private static final Log log = LogFactory.getLog(ClientManagerTranslator.class);
    private final XmlLoader xmlLoader;
    private final ClientSettingManager clientSettingManager;

    public ClientManagerTranslator() {
        this(MgmtFactory.getXmlLoader(), MgmtFactory.getClientSettingManager());
    }

    ClientManagerTranslator(XmlLoader xmlLoader, ClientSettingManager clientSettingManager) {
        this.xmlLoader = xmlLoader;
        this.clientSettingManager = clientSettingManager;
    }

    public ClientDocument clientDataToClientDocument(ClientData clientData) {
        String clientDataData = clientData.getData();
        String[] dataParts = clientDataData.split("\\.");
        String encodedXmlClientDocumentString = dataParts[1];
        String xmlString = Base64URL.decodeToString((String)encodedXmlClientDocumentString, (String)StandardCharsets.UTF_8.name());
        ByteArrayInputStream inStream = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));
        XmlObject xmlObj = this.xmlLoader.load(inStream);
        ClientDocument clientDoc = null;
        if (xmlObj instanceof ClientDocument) {
            clientDoc = (ClientDocument)xmlObj;
        }
        return clientDoc;
    }

    public ClientData clientDocumentToClientData(String clientId, String name, Date lastModified, Date creationTime, ClientDocument clientDocument) {
        String formatId = "1";
        XmlOptions opts = XmlBeansUtil.getXmlOptions();
        opts.setUseDefaultNamespace();
        String xml = clientDocument.xmlText(opts);
        String encodedClientDocument = Base64URL.encodeToString((byte[])xml.getBytes(StandardCharsets.UTF_8));
        String clientDataDataString = formatId + "." + encodedClientDocument;
        ClientData clientData = new ClientData();
        clientData.setId(clientId);
        clientData.setName(name);
        clientData.setLastModified(lastModified);
        clientData.setCreationTime(creationTime);
        clientData.setData(clientDataDataString);
        return clientData;
    }

    public void fillXmClientFromClient(ClientType xmlClient, Client client) {
        xmlClient.setClientId(client.getClientId());
        if (client.getName() != null) {
            xmlClient.setName(client.getName());
        }
        if (client.getRefreshRolling() != null) {
            xmlClient.setRefreshRolling(Boolean.parseBoolean(client.getRefreshRolling()));
        }
        if (client.getLogoUrl() != null) {
            xmlClient.setLogo(client.getLogoUrl());
        }
        if (client.getEncodedSecret() != null) {
            xmlClient.setSecret(client.getEncodedSecret());
        }
        if (client.getDescription() != null) {
            xmlClient.setDescription(client.getDescription());
        }
        xmlClient.setPersistentGrantExpirationTime(this.getPersistentGrantExpirationTimeValueToStore(client));
        xmlClient.setEnabled(client.isEnabled());
        if (client.getPersistentGrantExpirationTimeUnit() != null) {
            xmlClient.setPersistentGrantExpirationTimeUnit(client.getPersistentGrantExpirationTimeUnit());
        }
        if (client.getLastModified() != null) {
            xmlClient.setLastModified(client.getLastModified());
        }
        if (client.getCreationTime() != null) {
            xmlClient.setCreationTime(client.getCreationTime());
        }
        xmlClient.setBypassApprovalPage(client.isBypassApprovalPage());
        this.copyGrants(client, xmlClient);
        this.copyRedirects(client, xmlClient);
        this.copyRestrictedScopes(client, xmlClient);
        this.copyLogoutUris(client, xmlClient);
        if (client.getClientCertIssuerDn() != null) {
            xmlClient.setClientCertIssuerDN(client.getClientCertIssuerDn());
        }
        if (client.getClientCertSubjectDn() != null) {
            xmlClient.setClientCertSubjectDN(client.getClientCertSubjectDn());
        }
        if (client.getJwksUrl() != null) {
            xmlClient.setJwksUri(client.getJwksUrl());
        }
        if (client.getJwks() != null) {
            xmlClient.setJwks(client.getJwks());
        }
        if (client.getClientAuthnType() != null) {
            xmlClient.setClientAuthnType(client.getClientAuthnType().name());
        }
        xmlClient.setEnforceOneTimeJWT(Boolean.TRUE.equals(client.isEnforceReplayPrevention()));
        xmlClient.setIsRequireSignedRequest(client.isRequireSignedRequests());
        this.copySupplementalInfo(client, xmlClient);
    }

    private void copyGrants(Client client, ClientType xmlClient) {
        for (String grant : client.getGrantTypes()) {
            GrantTypeType gtt = xmlClient.addNewGrant();
            gtt.setType(grant);
        }
    }

    private void copyRedirects(Client client, ClientType xmlClient) {
        for (String redirect : client.getRedirectUris()) {
            xmlClient.addRedirectUri(redirect);
        }
    }

    private void copyLogoutUris(Client client, ClientType xmlClient) {
        for (String logoutUri : client.getLogoutUris()) {
            xmlClient.addLogoutUri(logoutUri);
        }
    }

    private void copyRestrictedScopes(Client client, ClientType xmlClient) {
        xmlClient.setRestrictScopes(client.isRestrictScopes());
        if (client.isRestrictScopes()) {
            for (String scope : client.getRestrictedScopes()) {
                xmlClient.addRestrictedScope(scope);
            }
        }
    }

    private void copySupplementalInfo(Client client, ClientType xmlClient) {
        this.copyExtendedParamsToSupplementalInfo(client);
        for (Map.Entry<String, String> entry : client.getSupplementalInfo().entrySet()) {
            if (entry.getValue() == null) continue;
            SupplementalInfoType info = xmlClient.addNewSupplementalInfo();
            info.setKey(entry.getKey());
            info.setValue(entry.getValue());
        }
    }

    public Client clientFromXmlClient(ClientType xmlClient) {
        long expTime = xmlClient.getPersistentGrantExpirationTime();
        String expType = this.getPersistentGrantExpirationTimeType(expTime);
        String expTimeUnit = "d";
        if (expType.equals("OVERRIDE_SERVER_DEFAULT")) {
            expTimeUnit = xmlClient.getPersistentGrantExpirationTimeUnit();
        }
        String refreshRolling = null;
        if (xmlClient.isSetRefreshRolling()) {
            refreshRolling = Boolean.toString(xmlClient.getRefreshRolling());
        }
        ClientAuthenticationType authnType = null;
        if (StringUtils.isNotEmpty((String)xmlClient.getClientAuthnType())) {
            authnType = ClientAuthenticationType.valueOf((String)xmlClient.getClientAuthnType());
        }
        Client client = new Client(xmlClient.getClientId(), xmlClient.getName(), refreshRolling, xmlClient.getLogo(), xmlClient.getSecret(), xmlClient.getDescription(), expType, expTime, expTimeUnit, xmlClient.getBypassApprovalPage(), authnType);
        client.setEnabled(xmlClient.getEnabled());
        this.copyGrants(xmlClient, client);
        this.copyRedirects(xmlClient, client);
        this.copyRestrictedScopes(xmlClient, client);
        this.copyLogoutUris(xmlClient, client);
        client.setLastModified(xmlClient.getLastModified());
        client.setCreationTime(xmlClient.getCreationTime());
        client.setClientCertIssuerDn(xmlClient.getClientCertIssuerDN());
        client.setClientCertSubjectDn(xmlClient.getClientCertSubjectDN());
        client.setJwksUrl(xmlClient.getJwksUri());
        client.setEnforceReplayPrevention(xmlClient.getEnforceOneTimeJWT());
        if (StringUtils.isNotEmpty((String)xmlClient.getJwks())) {
            client.setJwks(xmlClient.getJwks());
            try {
                JsonWebKeySet jsonKeySet = new JsonWebKeySet(xmlClient.getJwks());
                client.setJsonWebKeys(jsonKeySet.getJsonWebKeys());
            }
            catch (JoseException e) {
                log.error((Object)e.getMessage());
                log.debug((Object)e.getStackTrace());
            }
        }
        client.setRequireSignedRequests(xmlClient.getIsRequireSignedRequest());
        this.copySupplementalInfo(xmlClient, client);
        return client;
    }

    private void copyGrants(ClientType xmlClient, Client client) {
        HashSet<String> grantTypes = new HashSet<String>();
        for (GrantTypeType grantType : xmlClient.getGrantArray()) {
            grantTypes.add(grantType.getType());
        }
        client.setGrantTypes(grantTypes);
    }

    private void copyRedirects(ClientType xmlClient, Client client) {
        client.setRedirectUris(new ArrayList<String>(Arrays.asList(xmlClient.getRedirectUriArray())));
    }

    private void copyLogoutUris(ClientType xmlClient, Client client) {
        client.setLogoutUris(new ArrayList<String>(Arrays.asList(xmlClient.getLogoutUriArray())));
    }

    private void copyRestrictedScopes(ClientType xmlClient, Client client) {
        client.setRestrictScopes(xmlClient.getRestrictScopes());
        client.setRestrictedScopes(new ArrayList<String>(Arrays.asList(xmlClient.getRestrictedScopeArray())));
    }

    private void copySupplementalInfo(ClientType xmlClient, Client client) {
        for (SupplementalInfoType info : xmlClient.getSupplementalInfoArray()) {
            client.setSupplementalInfo(info.getKey(), info.getValue());
        }
        this.copyExtendedParamsFromSupplementalInfo(client);
    }

    public String getPersistentGrantExpirationTimeType(long storedValue) {
        String expirationType = "SERVER_DEFAULT";
        if (storedValue > 0L) {
            expirationType = "OVERRIDE_SERVER_DEFAULT";
        } else if (storedValue < 0L) {
            expirationType = "NONE";
        }
        return expirationType;
    }

    public String getPersistentGrantIdleTimeoutType(long storedValue) {
        String timeoutSettingType = "SERVER_DEFAULT";
        if (storedValue >= 0L) {
            timeoutSettingType = "OVERRIDE_SERVER_DEFAULT";
        }
        return timeoutSettingType;
    }

    public long getPersistentGrantExpirationTimeValueToStore(Client client) {
        long valueToStore = 0L;
        switch (client.getPersistentGrantExpirationType()) {
            case "OVERRIDE_SERVER_DEFAULT": {
                if (client.getPersistentGrantExpirationTime() == null) break;
                valueToStore = client.getPersistentGrantExpirationTime();
                break;
            }
            case "NONE": {
                valueToStore = -1L;
                break;
            }
        }
        client.setPersistentGrantExpirationTime(valueToStore);
        return valueToStore;
    }

    public void copyExtendedParamsFromSupplementalInfo(Client client) {
        Map<String, ClientParam> metadataParams = this.clientSettingManager.getClientSetting().getExtendedMetadataParams();
        LinkedHashMap<String, ParamValues> orderedParams = new LinkedHashMap<String, ParamValues>();
        for (String name : metadataParams.keySet()) {
            String value;
            int valueIndex = 0;
            StringBuffer supplementalInfoName = this.getExtendedParamName(name, valueIndex);
            while ((value = client.getSupplementalInfo(supplementalInfoName.toString())) != null) {
                if (orderedParams.containsKey(name)) {
                    ParamValues paramValues = (ParamValues)orderedParams.get(name);
                    if (paramValues != null) {
                        ArrayList<String> values = new ArrayList<String>(paramValues.getElements());
                        values.add(value);
                        ParamValues newParamValues = new ParamValues();
                        newParamValues.setElements(values);
                        orderedParams.put(name, newParamValues);
                    }
                } else {
                    ParamValues newParamValues = new ParamValues();
                    newParamValues.setElements(new ArrayList<String>(List.of(value)));
                    orderedParams.put(name, newParamValues);
                }
                supplementalInfoName = new StringBuffer(this.getExtendedParamName(name, ++valueIndex));
            }
        }
        client.setExtendedParams(orderedParams);
    }

    public void copyExtendedParamsToSupplementalInfo(Client client) {
        if (client.getExtendedParams() == null) {
            return;
        }
        for (Map.Entry<String, ParamValues> entry : client.getExtendedParams().entrySet()) {
            int i = 0;
            if (entry.getValue() == null || entry.getValue().getElements() == null) continue;
            for (String value : entry.getValue().getElements()) {
                StringBuffer savedName = this.getExtendedParamName(entry.getKey(), i);
                client.setSupplementalInfo(savedName.toString(), value);
                ++i;
            }
        }
    }

    private StringBuffer getExtendedParamName(String name, int index) {
        return new StringBuffer().append("pf_ecm_").append(name).append("_").append(String.format("%02d", index));
    }
}

