/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.VirtualHostNamesManager;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class ResourceEvaluator {
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();
    private final VirtualHostNamesManager virtualHostNamesMgr = GlobalRegistry.getService(VirtualHostNamesManager.class);

    public Result isResourceMatch(String target, String requested) {
        return this.isMatch(target, requested, this.virtualHostNamesMgr.getHostNameSet(), this.metadataLocal.getBaseURL());
    }

    public Result isResourceMatch(String target, String requested, Set<String> oauthVirtualIssuerHostnames) {
        Set<String> combined = Stream.of(this.virtualHostNamesMgr.getHostNameSet(), oauthVirtualIssuerHostnames).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.isMatch(target, requested, combined, this.metadataLocal.getBaseURL());
    }

    Result isMatch(String target, String requested, Set<String> virtualHostNames, URL baseURL) {
        URI requestedUri;
        URI targetUri;
        URL requestedUrl;
        URL targetUrl;
        Result result = new Result();
        try {
            targetUrl = new URL(target);
        }
        catch (MalformedURLException e) {
            result.message = "Unable to evaluate resource '" + target + "' due to a malformed URL in message from partner.";
            return this.returnNoMatchResult(result, target, requested, baseURL, e);
        }
        try {
            requestedUrl = new URL(requested);
        }
        catch (MalformedURLException e) {
            result.message = "Unable to evaluate resource because URL could not be parsed from requested resource " + requested + ".";
            return this.returnNoMatchResult(result, target, requested, baseURL, e);
        }
        result.isMatch = true;
        try {
            targetUri = targetUrl.toURI().normalize();
            requestedUri = requestedUrl.toURI().normalize();
        }
        catch (URISyntaxException e) {
            result.message = "Unable to convert from URL to URI.";
            return this.returnNoMatchResult(result, target, requested, baseURL, e);
        }
        if (!targetUri.equals(requestedUri)) {
            boolean hostMatch;
            String requestedPath;
            String targetHost = targetUrl.getHost().toLowerCase();
            String targetPath = StringUtils.substringBefore((String)targetUri.getPath(), (String)";");
            if (!targetPath.endsWith(requestedPath = requestedUri.getPath())) {
                result.message = "Resource evaluation failed due to path mismatch - '" + targetPath;
                result.message = result.message + "' does not end with '" + requestedPath + "'";
                return this.returnNoMatchResult(result, target, requested, baseURL, null);
            }
            String baseHost = baseURL.getHost();
            String requestedHost = requestedUrl.getHost();
            boolean bl = hostMatch = targetHost.equalsIgnoreCase(requestedHost) || virtualHostNames.contains(targetHost) || targetHost.equalsIgnoreCase(baseHost);
            if (!hostMatch) {
                result.message = "Resource evaluation failed.  Target host name '";
                result.message = result.message + targetHost + "' does not match the requested host '" + requestedHost;
                result.message = result.message + "' or the base url host '" + baseHost + "' and is not in the virtual host name set " + virtualHostNames;
                return this.returnNoMatchResult(result, target, requested, baseURL, null);
            }
        }
        return result;
    }

    private Result returnNoMatchResult(Result result, String target, String requested, URL baseURL, Exception e) {
        result.isMatch = false;
        result.message = result.message + " Target in message ='" + target + "' requested resource='" + requested + "' configured base URL='" + baseURL + "'. ";
        if (e != null) {
            result.message = result.message + e;
        }
        return result;
    }

    public static class Result {
        private boolean isMatch;
        private String message;

        public boolean isMatch() {
            return this.isMatch;
        }

        public String getMessage() {
            return this.message == null ? "" : this.message;
        }

        public String toString() {
            return "Match=" + this.isMatch + ". " + this.getMessage();
        }
    }
}

