/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.collectsupportdata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsdArguments
implements Serializable {
    private final Map<String, String> ARG_NAME_TO_VALUE_MAP = new HashMap<String, String>();
    private final List<String> booleanFlags = new ArrayList<String>();
    public static final String NO_TRUNCATE = "noTruncate";
    public static final String INTERVAL_BETWEEN_SAMPLES = "intervalBetweenSamples";
    public static final String FILE_HEAD_COLLECTION_SIZE = "fileHeadCollectionKBSize";
    public static final String FILE_TAIL_COLLECTION_SIZE = "fileTailCollectionKBSize";
    public static final String ROLLED_LOG_COUNT = "rolledLogCount";
    public static final String ENCRYPT = "encrypt";
    public static final String OUTPUT_PATH = "outputPath";
    public static final String NUM_HEARTBEAT_SAMPLES = "numHeartbeatSamples";
    public static final String INCLUDE_BINARY_FILES = "includeBinaryFiles";
    public static final String REPORT_INTERVAL = "reportInterval";
    public static final String COLLECT_EXPENSIVE_DATA = "collectExpensiveData";
    public static final String ENCRYPTION_PASSPHRASE = "encryptionPassphrase";
    public static final String REPORT_COUNT = "reportCount";
    public static final String COMMENT = "comment";
    public static final String PRODUCT_TYPE = "productType";
    public static final String SERVER_ROOT = "serverRoot";

    public void addArgument(String name, String value) {
        this.ARG_NAME_TO_VALUE_MAP.put(name, value);
    }

    public void addBooleanFlag(String name) {
        this.booleanFlags.add(name);
    }

    public String getArgumentString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String> entry : this.ARG_NAME_TO_VALUE_MAP.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\",");
        }
        for (String flag : this.booleanFlags) {
            sb.append("\"").append(flag).append("\":\"true\",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.ARG_NAME_TO_VALUE_MAP.entrySet()) {
            args.add("--" + entry.getKey());
            args.add(entry.getValue());
        }
        for (String flag : this.booleanFlags) {
            args.add("--" + flag);
        }
        return args;
    }

    public String getArgument(String name) {
        return this.ARG_NAME_TO_VALUE_MAP.get(name);
    }

    public boolean getFlag(String name) {
        return this.booleanFlags.contains(name);
    }
}

