/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.domain;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SearchCriteria {
    private int startIndex;
    private int itemsRequested;
    private String query;
    private List<FilterItem> filterBy = new LinkedList<FilterItem>();
    private String orderBy;
    private Order order = Order.ASC;

    private SearchCriteria(int startIndex, int itemsRequested) {
        this.startIndex = startIndex;
        this.itemsRequested = itemsRequested;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getItemsRequested() {
        return this.itemsRequested;
    }

    public void setItemsRequested(int itemsRequested) {
        this.itemsRequested = itemsRequested;
    }

    public int getTargetEndIndex() {
        return this.getItemsRequested() == Integer.MAX_VALUE || this.getItemsRequested() == -1 ? Integer.MAX_VALUE : this.getStartIndex() + this.getItemsRequested();
    }

    public List<FilterItem> getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(List<FilterItem> filterBy) {
        this.filterBy = filterBy;
    }

    public void addFilterBy(FilterItem filterItem) {
        this.filterBy.add(filterItem);
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public static final class Builder {
        private static final String ASTERISK = "*";
        private SearchCriteria searchCriteria;

        public Builder(int startIndex, int itemsRequested) {
            this.searchCriteria = new SearchCriteria(startIndex, itemsRequested);
        }

        public Builder() {
            this.searchCriteria = new SearchCriteria(-1, -1);
        }

        public Builder(SearchCriteria searchCriteria) {
            this.searchCriteria = new SearchCriteria(searchCriteria.getStartIndex(), searchCriteria.getItemsRequested());
            this.searchCriteria.setQuery(searchCriteria.getQuery());
            this.searchCriteria.setOrder(searchCriteria.getOrder());
            this.searchCriteria.setFilterBy(searchCriteria.getFilterBy());
            this.searchCriteria.setOrderBy(searchCriteria.getOrderBy());
        }

        public Builder setPage(Integer page, Integer numberPerPage) {
            int itemRequested = numberPerPage == null ? Integer.MAX_VALUE : Math.max(1, numberPerPage);
            int pageIndex = page == null ? 0 : Math.max(0, page - 1);
            this.searchCriteria.setStartIndex(pageIndex * itemRequested);
            this.searchCriteria.setItemsRequested(itemRequested);
            return this;
        }

        public Builder setStartIndex(Integer startIndex) {
            this.searchCriteria.setStartIndex(startIndex);
            return this;
        }

        public Builder setItemsRequested(Integer itemsRequested) {
            this.searchCriteria.setItemsRequested(itemsRequested);
            return this;
        }

        public Builder query(String query) {
            return this.query(query, true);
        }

        public Builder query(String query, boolean shouldNormalize) {
            if (shouldNormalize) {
                String normalizedQuery = StringUtils.stripStart((String)query, (String)ASTERISK);
                normalizedQuery = StringUtils.stripEnd((String)normalizedQuery, (String)ASTERISK);
                this.searchCriteria.setQuery(normalizedQuery);
            } else {
                this.searchCriteria.setQuery(query);
            }
            return this;
        }

        public Builder addFilter(FilterItem filterItem) {
            this.searchCriteria.addFilterBy(filterItem);
            return this;
        }

        public Builder setFilterItems(List<FilterItem> filterItemList) {
            this.searchCriteria.setFilterBy(filterItemList);
            return this;
        }

        public Builder orderByAsc(String orderBy) {
            return this.addOrder(Order.ASC, orderBy);
        }

        public Builder orderByDesc(String orderBy) {
            return this.addOrder(Order.DESC, orderBy);
        }

        public Builder addOrder(Order order, String orderBy) {
            this.searchCriteria.setOrder(order);
            this.setOrderBy(orderBy);
            return this;
        }

        private void setOrderBy(String orderBy) {
            this.searchCriteria.setOrderBy(orderBy);
        }

        public SearchCriteria build() {
            return this.searchCriteria;
        }
    }

    public static final class FilterItem {
        private String fieldName;
        private Object value;

        public FilterItem(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

