/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class SearchResult<T>
implements Serializable {
    private final int startIndex;
    private final List<T> results;
    private final int totalItems;

    public SearchResult(int startIndex, List<T> results) {
        this.startIndex = startIndex;
        this.results = results;
        this.totalItems = -1;
    }

    public SearchResult(int startIndex, List<T> results, int totalItems) {
        this.startIndex = startIndex;
        this.results = results;
        this.totalItems = totalItems;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getResultCount() {
        return this.results.size();
    }

    public List<T> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public int getTotalItems() {
        return this.totalItems;
    }
}

