/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.domain.filter;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sourceid.util.domain.filter.Filter;
import org.sourceid.util.domain.filter.ItemMultiValue;

public final class ContainsCriteriaFilter<T>
implements Filter<T> {
    private final Function<T, ItemMultiValue<T, String>> itemMultiKeyFunction;

    public ContainsCriteriaFilter(Function<T, ItemMultiValue<T, String>> itemMultiKeyFunction) {
        this.itemMultiKeyFunction = itemMultiKeyFunction;
    }

    @Override
    public Collection<T> doFilter(String criteria, Collection<T> source) {
        if (StringUtils.isBlank((String)criteria)) {
            return source;
        }
        List itemMultiValues = source.parallelStream().map(this.itemMultiKeyFunction).collect(Collectors.toList());
        Predicate<ItemMultiValue> keyContainsCriteria = i -> Stream.of((String[])i.getKeys()).anyMatch(s -> s.toLowerCase().contains(criteria.toLowerCase()));
        return itemMultiValues.parallelStream().filter(keyContainsCriteria).map(ItemMultiValue::getItem).collect(Collectors.toList());
    }
}

