/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.initial.setup;

import com.pingidentity.util.InitialSetupConfigStore;
import java.util.Collection;
import java.util.Objects;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AdminAPIAuthManager;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class InitialSetupUtil {
    public static final String LICENSE_API_PATH = "license";
    public static final String LICENSE_AGREEMENT_API_PATH = "agreement";
    public static final String ADMIN_ACCOUNT_API_PATH = "administrativeAccounts";
    public static final String ADMINISTRATIVE_ACCOUNTS_CHANGE_PASSWORD = "/changePassword";
    public static final String INITIAL_SET_UP_API_PROPERTY_NAME = "com.pingidentity.pf.admin.rest.initial_setup";
    public static final String BULK_IMPORT = "bulk/import";
    private static final String ISW_PATH_PREFIX = "internal/isw/";
    private final AdminUserManager adminNativeUserManager = MgmtFactory.getNativeAdminUserManager();
    private InitialSetupConfigStore initialSetUpConfigStore = new InitialSetupConfigStore();

    public boolean hasAcceptedLicenseAgreement() {
        return this.initialSetUpConfigStore.hasAcceptedLicenseAgreement();
    }

    public void acceptLicenseAgreement() {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.initialSetUpConfigStore.acceptLicense();
            auditLoggerScope.log(AdminAuditLogger.Component.LICENSE, AdminAuditLogger.Event.MODIFY, "License agreement");
        }
    }

    public boolean isBypassAuth() {
        if (AdminAPIAuthManager.getInstance().isNative()) {
            return this.hasNoNativeUsers() && !this.initialSetUpConfigStore.isInitialSetupDone();
        }
        return false;
    }

    public boolean hasNoNativeUsers() {
        if (AdminAPIAuthManager.getInstance().isNative()) {
            Collection<AdministrativeUser> adminUser = this.adminNativeUserManager.getUsers();
            return adminUser == null || adminUser.isEmpty();
        }
        return false;
    }

    public static String getLicenseAgreementApiPath() {
        return "license/agreement";
    }

    public boolean isAuthRequired(String requestPath) {
        boolean initialSetupPending = this.isBypassAuth();
        if (InitialSetupUtil.getLicenseAgreementApiPath().equals(requestPath) || LICENSE_API_PATH.equals(requestPath) || BULK_IMPORT.equals(requestPath)) {
            return !initialSetupPending;
        }
        return true;
    }

    public boolean isLicenseRequired(String requestPath) {
        boolean initialSetupPending = this.isBypassAuth();
        if (InitialSetupUtil.getLicenseAgreementApiPath().equals(requestPath) || LICENSE_API_PATH.equals(requestPath) || this.isInitialSetupApiCall(requestPath)) {
            return !initialSetupPending;
        }
        return true;
    }

    public boolean isAuthRequired(String requestPath, String requestMethod) {
        if (this.isBypassAuth()) {
            if (this.isInitialSetupApiCall(requestPath)) {
                return false;
            }
            if (ADMIN_ACCOUNT_API_PATH.equals(requestPath) && "POST".equalsIgnoreCase(requestMethod)) {
                return false;
            }
            return this.isAuthRequired(requestPath);
        }
        return true;
    }

    public boolean isInitialSetupApiCall(String requestPath) {
        Objects.requireNonNull(requestPath, "requestPath");
        return requestPath.startsWith(ISW_PATH_PREFIX);
    }
}

