/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.configservice.SysDirInfo;
import com.smardec.license4j.LicenseNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.a2a.domain.mgmt.Adapter2AdapterManager;
import org.sourceid.a2a.domain.mgmt.Token2TokenManager;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.util.license.DisplayableLicense;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseConnectionGroupManager;
import org.sourceid.util.license.LicenseFileWatcher;
import org.sourceid.util.license.LicenseMgrInfo;
import org.sourceid.util.license.LicenseObject;
import org.sourceid.util.license.PingLicense;
import org.sourceid.util.license.Status;
import org.sourceid.util.license.Watcher;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class LicenseManager {
    private static Log log;
    private static SysDirInfo sysDirInfo;
    private static LicenseMgrInfo licenseMgrInfo;
    private static String licenseFileName;
    public static final String FALLBACK_KEY_FILE_NAME;
    private static volatile PingLicense license;
    private static final String CONFIG_DIRECTORY;
    private static Timer timer;
    private static ConfigStore config;
    private static Watcher statusWatcher;
    private static LicenseConnectionGroupManager licConnGroupManager;
    public static final String MODULE_SAAS_PROVISIONING = "SaasProvisioning";
    public static final String OAUTH = "OAuth";
    public static final String LICENSE_CANNOT_BE_IMPORTED_ERROR = "The new license is not valid and cannot be imported. Please contact Ping Identity Support or try an alternative license file.";

    public static synchronized PingLicense getLicense() {
        return license;
    }

    public static String getLicenseKeyFile() {
        return sysDirInfo.getConfigDirectory() + File.separator + licenseFileName;
    }

    public static DisplayableLicense getDisplayableLicense() {
        return new DisplayableLicense(LicenseManager.getLicense());
    }

    public static Status getStatus() {
        return statusWatcher.getStatus();
    }

    public static boolean canAddConnection() {
        int licenseObjectCount;
        PingLicense license = LicenseManager.getLicense();
        return !license.exceedsConnectionLimit((licenseObjectCount = LicenseManager.getUsedConnectionCount()) + 1);
    }

    public static boolean canAddConnection(int numConnectionToAdd) {
        int licenseObjectCount;
        PingLicense license = LicenseManager.getLicense();
        return !license.exceedsConnectionLimit((licenseObjectCount = LicenseManager.getUsedConnectionCount()) + numConnectionToAdd);
    }

    public static boolean canAddConnectionToGroup(ConnectionBase connection, int numConnectionsToAdd, List<String> errors) {
        String group = connection.getLicenseConnectionGroupAssignment();
        if (!LicenseManager.isConnectionGroupDefinedInLicense(group)) {
            errors.add("The group '" + group + "' is not valid as it is not defined in the license.");
        } else if (!LicenseManager.getAvailableLicenseGroupNames(connection, numConnectionsToAdd).contains(group)) {
            errors.add("The group '" + group + "' does not have any unused connections left.");
        }
        return errors.isEmpty();
    }

    public static int getUsedConnectionCount() {
        MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
        Adapter2AdapterManager adapter2AdapterManager = MgmtFactory.getAdapter2AdapterManager();
        Token2TokenManager token2TokenManager = MgmtFactory.getToken2TokenManager();
        int licenseObjectCount = metadataDirectory.getConnectionCount() + adapter2AdapterManager.getMappingCount() + token2TokenManager.getMappingCount();
        return licenseObjectCount;
    }

    public static boolean isValidForGui() {
        boolean isValidForGui;
        StringBuilder sb = new StringBuilder();
        PingLicense license = LicenseManager.getLicense();
        if (license.licenseFileExists()) {
            if (!license.isValid()) {
                sb.append("License file is invalid.  Has it been modified?");
                isValidForGui = false;
            } else {
                String productName = licenseMgrInfo.getProductName();
                int major = licenseMgrInfo.getMajorVersion();
                int minor = licenseMgrInfo.getMinorVersion();
                boolean validProduct = license.isValidProduct(productName);
                boolean validVersion = license.isValidVersion(major, minor);
                boolean bl = isValidForGui = validProduct && validVersion;
                if (!validVersion || !validProduct) {
                    String msg = "License file is issued for " + license.getProduct() + " " + license.getVersion();
                    msg = msg + " but must be for " + productName + " " + major + "." + minor + ".";
                    sb.append(msg);
                }
            }
        } else {
            isValidForGui = false;
            sb.append("No license file was found.");
        }
        if (!isValidForGui) {
            license.logWarn(sb.toString());
        }
        return isValidForGui;
    }

    public static boolean isValidForRuntime() {
        return LicenseManager.isValidForGui();
    }

    public static boolean isValidForApi() {
        return LicenseManager.isValidForGui();
    }

    public static void testLicenseForImport(String stream, List<String> errors, List<String> warnings) {
        PingLicense importLicense;
        if (stream == null) {
            errors.add(LICENSE_CANNOT_BE_IMPORTED_ERROR);
            return;
        }
        try {
            importLicense = new PingLicense(stream, true);
            if (!importLicense.isValid()) {
                errors.add(LICENSE_CANNOT_BE_IMPORTED_ERROR);
                return;
            }
        }
        catch (LicenseNotFoundException | UnsupportedEncodingException uee) {
            errors.add(LICENSE_CANNOT_BE_IMPORTED_ERROR);
            return;
        }
        if (importLicense.isExpiredPastGracePeriod()) {
            errors.add("The new license has expired and cannot be imported. Please contact Ping Identity Support or try an alternative license file.");
        }
        if (!importLicense.isValidMajorVersion(licenseMgrInfo.getMajorVersion()) || !importLicense.isValidMinorVersion(licenseMgrInfo.getMinorVersion())) {
            String msg = "The new license is for a different version of PingFederate and cannot be imported. Please contact Ping Identity Support or try an alternative license file.";
            errors.add(msg);
        }
        if (!errors.isEmpty()) {
            return;
        }
        if (warnings != null) {
            PingLicense currentLicense = LicenseManager.getLicense();
            Integer importNodeLimit = importLicense.getNodeLimit();
            Integer currentNodeLimit = currentLicense.getNodeLimit();
            if (importNodeLimit != null && (currentNodeLimit == null || importNodeLimit < currentNodeLimit)) {
                warnings.add("The node limits have been reduced in the new license compared to the previous license.  If you import the new license, one or more nodes in an existing cluster may fail.");
            }
            Integer importConnectionLimit = importLicense.getConnectionLimit();
            Integer currentConnectionLimit = currentLicense.getConnectionLimit();
            if (importConnectionLimit != null && (currentConnectionLimit == null || importConnectionLimit < currentConnectionLimit)) {
                warnings.add("The connection limits have been reduced in the new license compared to the previous license.  If you import the new license, one or more existing connections may fail.");
            }
            if (!importLicense.isFeatureEnabled("WSTrustSTS") && currentLicense.isFeatureEnabled("WSTrustSTS")) {
                warnings.add("WSTrust STS is not enabled in the new license.  Any STS options configured will no longer be maintainable, and STS runtime requests will fail.");
            }
            if (!importLicense.isOAuthEnabled() && currentLicense.isOAuthEnabled()) {
                warnings.add("OAuth is not enabled in the new license.  Any OAuth options configured will no longer be maintainable, and OAuth runtime requests may fail.");
            }
            if (!importLicense.isFeatureEnabled(MODULE_SAAS_PROVISIONING) && currentLicense.isFeatureEnabled(MODULE_SAAS_PROVISIONING)) {
                warnings.add("SaaS Provisioning is not enabled in the new license.  Any existing connections configured to support SaaS Provisioning will no longer be maintainable, and provisioning routines in production will fail.");
            }
            if (importLicense.hasConnectionLimitDetailsAttribute() && !currentLicense.hasConnectionLimitDetailsAttribute() && !currentLicense.isConnectionLimitDefined()) {
                warnings.add("The connection licensing model has changed.  If you import the new license key, you will need to update each of your connections to specify the license group to be used for that connection.");
            }
            if (importLicense.hasExpirationDate() && (!currentLicense.hasExpirationDate() || importLicense.isExpiredWithRespectTo(currentLicense.getExpirationDate()))) {
                warnings.add("The new license has an earlier expiration date than the existing license.");
            }
        }
    }

    public static synchronized void importLicense(String importedBytes, List<String> errors) {
        String origLicenseFile = null;
        File orig = new File(CONFIG_DIRECTORY, licenseFileName);
        if (orig.canRead() && orig.exists()) {
            try {
                origLicenseFile = SimpleFileUtil.readFileToString(orig);
            }
            catch (IOException ioe) {
                errors.add("The license file could not be imported.");
                return;
            }
        }
        if (origLicenseFile != null) {
            File backup = new File(CONFIG_DIRECTORY, licenseFileName);
            SimpleFileUtil.writeFileSilent(backup, origLicenseFile.getBytes(StandardCharsets.UTF_8));
            SimpleFileUtil.copyWithDateExt(backup);
        }
        File newLicenseFile = new File(CONFIG_DIRECTORY, licenseFileName);
        try (AuditLoggerScope scope = new AuditLoggerScope();){
            SimpleFileUtil.writeFileSilent(newLicenseFile, importedBytes.getBytes(StandardCharsets.UTF_8));
            scope.log(AdminAuditLogger.Component.LICENSE, AdminAuditLogger.Event.IMPORT);
        }
        LicenseManager.reload();
    }

    static synchronized void reload() {
        LicenseManager.loadLicense();
        statusWatcher.doIt(LicenseManager.getLicense());
        MetaDataFactory.getLocalMetaData().reload();
    }

    public static boolean isFeatureEnabled(String featureName) {
        PingLicense license = LicenseManager.getLicense();
        return license.isFeatureEnabled(featureName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void okToProvideService(LicenseObject licenseObject) {
        PingLicense lic = LicenseManager.getLicense();
        if (lic == null) throw new ProcessRuntimeException("There is no available license");
        if (lic.isExpiredPastGracePeriod() && lic.isStopService()) throw new ProcessRuntimeException("License has expired");
        if (!lic.hasConnectionLimitDetailsAttribute()) {
            if (!lic.exceedsConnectionLimit(LicenseManager.getUsedConnectionCount())) return;
            throw new ProcessRuntimeException("The connection limit has been exceeded");
        }
        licConnGroupManager.okToProvideService(licenseObject, lic);
    }

    public static void checkLicenseForConnection(LicenseObject licenseObject) {
        LicenseManager.okToProvideService(licenseObject);
    }

    public static boolean isConnectionGroupDefined() {
        String cnnLimitDetails = LicenseManager.getLicense().getFeature("ConnectionLimitDetails");
        return cnnLimitDetails != null;
    }

    public static boolean isConnectionGroupExpired(String grpName) {
        boolean retV = false;
        LicenseConnectionGroup group = LicenseManager.getLicense().getLicenseConnectionGroup(grpName);
        Date now = new Date();
        if (group != null) {
            retV = now.after(group.getExpirationDate());
        }
        return retV;
    }

    public static boolean isConnectionGroupInEffect(String grpName) {
        boolean retV = false;
        LicenseConnectionGroup group = LicenseManager.getLicense().getLicenseConnectionGroup(grpName);
        Date now = new Date();
        if (group != null) {
            retV = !now.before(group.getEffectiveDate());
        }
        return retV;
    }

    public static boolean isConnectionGroupDefinedInLicense(String grpName) {
        return LicenseManager.getLicense().getLicenseConnectionGroup(grpName) != null;
    }

    public static List<LicenseConnectionGroup> getAvailableLicenseGroups(LicenseObject licenseObject, int neededNumOfLicenseConnections) {
        return licConnGroupManager.getAvailableLicenseGroups(licenseObject, LicenseManager.getLicense(), neededNumOfLicenseConnections);
    }

    public static List<String> getAvailableLicenseGroupNames(LicenseObject licenseObject, int neededNumOfLicenseConnections) {
        LinkedList<String> availableGroups = new LinkedList<String>();
        List<LicenseConnectionGroup> groupsToConvert = LicenseManager.getAvailableLicenseGroups(licenseObject, neededNumOfLicenseConnections);
        for (LicenseConnectionGroup group : groupsToConvert) {
            availableGroups.add(group.getGroupName());
        }
        return availableGroups;
    }

    public static String getFormattedExpirationDate() {
        String expiration = null;
        if (LicenseManager.getLicense().hasExpirationDate()) {
            expiration = LicenseManager.getFormattedDate(LicenseManager.getLicense().getExpirationDate());
        }
        return expiration;
    }

    public static String getFormattedDate(Date date) {
        String formattedDate = null;
        if (date != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd yyyy");
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            formattedDate = formatter.format(localDate);
        }
        return formattedDate;
    }

    @Deprecated
    public static boolean isSaasProvisioningEnabled() {
        return LicenseManager.isFeatureEnabled(MODULE_SAAS_PROVISIONING);
    }

    protected static void loadLicense() {
        PingLicense tmpLicense = new PingLicense(LicenseManager.getLicenseKeyFile());
        if (!tmpLicense.licenseFileExists()) {
            tmpLicense.logWarn("No license found for this server (" + LicenseManager.getLicenseKeyFile() + ")");
        }
        DisplayableLicense displayableLicense = new DisplayableLicense(tmpLicense);
        log.info((Object)("License loaded:" + Util.LINE_BREAK + displayableLicense.getDetailInfo()));
        LicenseManager.setLicense(tmpLicense);
    }

    protected static void setLicense(PingLicense lic) {
        license = lic;
    }

    protected static void setLicenseMgrInfo(LicenseMgrInfo lmi) {
        licenseMgrInfo = lmi;
    }

    static {
        long enforceCheckPeriod;
        long watchPeriod;
        log = LogFactory.getLog(LicenseManager.class);
        sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        licenseMgrInfo = GlobalRegistry.getService(LicenseMgrInfo.class);
        licenseFileName = licenseMgrInfo.getLicenseFileName();
        FALLBACK_KEY_FILE_NAME = "." + licenseFileName;
        CONFIG_DIRECTORY = sysDirInfo.getConfigDirectory();
        timer = new Timer(LicenseManager.class.getName() + " timer", true);
        config = ConfigStoreFarm.getConfig(LicenseManager.class);
        licConnGroupManager = LicenseConnectionGroupManager.getInstance();
        LicenseManager.loadLicense();
        try {
            watchPeriod = config.getIntValue("LicenseWatchTimerPeriod");
        }
        catch (NoSuchValueException e) {
            watchPeriod = config.getIntValue("LicenseWatchTimerPeroid", 60000);
        }
        timer.schedule((TimerTask)new LicenseFileWatcher(), watchPeriod, watchPeriod);
        try {
            enforceCheckPeriod = config.getIntValue("CheckTimerPeriod");
        }
        catch (NoSuchValueException e) {
            enforceCheckPeriod = config.getIntValue("CheckTimerPeroid", 60000);
        }
        int min = 1000;
        int max = 14400000;
        enforceCheckPeriod = enforceCheckPeriod < (long)min ? (long)min : enforceCheckPeriod;
        enforceCheckPeriod = enforceCheckPeriod > (long)max ? (long)max : enforceCheckPeriod;
        statusWatcher = new Watcher();
        timer.schedule((TimerTask)statusWatcher, enforceCheckPeriod, enforceCheckPeriod);
        statusWatcher.doIt(LicenseManager.getLicense());
    }
}

