/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.license.LicenseMgrInfo;

public abstract class LicenseMgrInfoBase
implements LicenseMgrInfo {
    protected Log log = LogFactory.getLog(LicenseMgrInfoBase.class);
    private String versionString;

    public abstract String getGroupId();

    public abstract String getArtifactId();

    @Override
    public int getMajorVersion() {
        return this.getVersion()[0];
    }

    @Override
    public int getMinorVersion() {
        return this.getVersion()[1];
    }

    protected int[] getVersion() {
        String v = this.getVersionString();
        String[] strings = v.split("\\.");
        int major = this.parseInt(strings, 0);
        int minor = this.parseInt(strings, 1);
        return new int[]{major, minor};
    }

    private int parseInt(String[] strs, int idx) {
        try {
            return Integer.parseInt(strs[idx]);
        }
        catch (Exception e) {
            this.log.warn((Object)(Arrays.toString(strs) + e));
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String getVersionString() {
        if (this.versionString == null) {
            InputStream is = null;
            try {
                String name = "/META-INF/maven/" + this.getGroupId() + "/" + this.getArtifactId() + "/pom.properties";
                is = this.getClass().getResourceAsStream(name);
                Properties pomProps = new Properties();
                pomProps.load(is);
                this.versionString = pomProps.getProperty("version");
                this.log.debug((Object)this.versionString);
            }
            catch (IOException e) {
                String string;
                try {
                    this.log.error((Object)e, (Throwable)e);
                    string = "0.0-ERROR-" + e.getMessage();
                }
                catch (Throwable throwable) {
                    Closer.close(is);
                    throw throwable;
                }
                Closer.close((Closeable)is);
                return string;
            }
            Closer.close((Closeable)is);
        }
        return this.versionString;
    }
}

