/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import com.pingidentity.email.mgmt.NotificationDispatcherManager;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.sdk.notification.NotificationEventType;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.StringSubstituter;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.util.license.DisplayableLicense;
import org.sourceid.util.license.Logger;
import org.sourceid.util.license.PingLicense;
import org.sourceid.util.license.Status;
import org.sourceid.util.license.Synchronizer;

public class NotificationSupport {
    static final Log log = LogFactory.getLog(NotificationSupport.class);
    private Logger logger;
    static final String IP = "IP_ADDR";
    static final String EX_DATE = "EX_DATE";
    static final String DAYS_LEFT = "DAYS_LEFT";
    static final String GRP_EX_DATE = "GRP_EX_DATE";
    static final String GRP_DAYS_LEFT = "GRP_DAYS_LEFT";
    static final String DISP_LIC = "DISP_LIC";
    static final String LOG_END_TEMPLATE = Util.LINE_BREAK + "${DISP_LIC}";
    static final String WARN_LOG_TEMPLATE = "You are approaching the limit for your PingFederate license." + LOG_END_TEMPLATE;
    static final String GRACE_LOG_TEMPLATE = "You have reached the limit for your PingFederate license." + LOG_END_TEMPLATE;
    static final String VIOLATION_LOG_TEMPLATE = "You have exceeded the limit for your PingFederate license. The server has shutdown. No more transactions will be processed." + LOG_END_TEMPLATE;
    private static final NotificationDispatcherManager notificationDispatcher = MgmtFactory.getNotificationDispatcherManager();

    public NotificationSupport() {
        this(new Logger(){
            private final Log log = LogFactory.getLog(this.getClass());

            @Override
            public void log(Date date, String msg) {
                this.log.warn((Object)msg);
            }
        });
    }

    public NotificationSupport(Logger logger) {
        this.logger = logger;
    }

    void send(PingLicense license, Date now, Status status) {
        DisplayableLicense displayableLicense = new DisplayableLicense(license);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IP, Synchronizer.getSynchronizer().getIP());
        params.put(EX_DATE, displayableLicense.getExpirationDate());
        params.put(DAYS_LEFT, displayableLicense.getDaysLeft(now));
        params.put(GRP_EX_DATE, displayableLicense.getFirstGrpExpirationDate());
        params.put(GRP_DAYS_LEFT, displayableLicense.getFirstGrpDaysLeft(now));
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
        String notificationPublisher = notificationMgr.getNotificationSettings().getNotificationPublisherLicensing();
        if (notificationMgr.getNotificationSettings().isEnableEmailNotification() && (StringUtils.isNotBlank((String)notificationPublisher) || notificationSenderPluginInstance != null)) {
            NotificationEventType eventType = null;
            switch (status) {
                case WARN: {
                    eventType = NotificationEventType.SERVER_LICENSING_EVENT_WARNING;
                    break;
                }
                case GROUP_WARN: {
                    eventType = NotificationEventType.SERVER_LICENSING_EVENT_GROUP_WARNING;
                    break;
                }
                case GRACE: {
                    eventType = NotificationEventType.SERVER_LICENSING_EVENT_EXPIRED;
                    break;
                }
                case GROUP_GRACE: {
                    eventType = NotificationEventType.SERVER_LICENSING_EVENT_GROUP_EXPIRED;
                    break;
                }
                case VIOLATION: {
                    eventType = NotificationEventType.SERVER_LICENSING_EVENT_SHUTDOWN;
                    break;
                }
                case GROUP_VIOLATION: {
                    eventType = NotificationEventType.SERVER_LICENSING_EVENT_GROUP_SHUTDOWN;
                    break;
                }
            }
            NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
            notificationSupportHelper.publishNotification(notificationPublisher, status.getEmailTemplateFile(), notificationMgr.getNotificationSettings().getTo(), params, eventType != null ? eventType.toString() : "");
        }
    }

    void log(PingLicense license, Date now, Status status) {
        String logTemplate = status.getLogTemplate();
        HashMap<String, String> substitutionValuesMap = new HashMap<String, String>();
        substitutionValuesMap.put(DISP_LIC, new DisplayableLicense(license).getDetailInfo());
        String msg = StringSubstituter.substituteValuesTolarateUnkownKey((String)logTemplate, substitutionValuesMap);
        this.logger.log(now, msg);
    }
}

