/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.SimpleFileUtil;
import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;
import com.smardec.license4j.LicenseNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.Util;
import org.sourceid.util.license.DisplayableLicense;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseFeature;

public final class PingLicense {
    static final String ID = "ID";
    static final String NAME = "Name";
    static final String ORGANIZATION = "Organization";
    static final String PRODUCT = "Product";
    static final String VERSION = "Version";
    static final String ISSUEDATE = "IssueDate";
    static final String EXPIRATIONDATE = "ExpirationDate";
    static final String CONNECTIONLIMIT = "ConnectionLimit";
    static final String NODELIMIT = "NodeLimit";
    static final String TYPE = "Tier";
    static final String ENFORCEMENTTYPE = "EnforcementType";
    static final String CONNECTION_LIMIT_DETAILS = "ConnectionLimitDetails";
    static final String GRACE_PERIOD = "GracePeriod";
    static final String OAUTH = "OAuth";
    static final String FREE = "Free";
    static final String SUBSCRIPTION = "Subscription";
    static final String PERPETUAL = "Perpetual";
    static final String BRIDGE = "Bridge";
    private static int TWO = 2;
    static int SHUTDOWN = (int)Math.pow(TWO, 0.0);
    static int NOTIF = (int)Math.pow(TWO, 1.0);
    static int MINOR = (int)Math.pow(TWO, 2.0);
    private static Log log = LogFactory.getLog(PingLicense.class);
    private License license;
    private boolean valid;
    private long initTimestamp = 0L;
    private String licenseFileName;
    private String rawData;
    private Map<String, LicenseConnectionGroup> connectionLimitDetails = null;
    private Date expirationDate = null;
    private long gracePeriodInMilliseconds = 0L;
    private boolean logWarnings = true;
    public static final String SALES_TALK = "You do not have a valid license configured. To obtain a valid license, please contact your vendor's Customer Support.";
    public static final String NO_PROVISIONER_LIC = "You do not have a valid license for Outbound Provisioning. To obtain a valid license, please contact your vendor's Customer Support.";
    private static String PREFIX_ENCODED = "ENCODED";
    private static String DELIMITER = ":";
    private static String PUBLIC_KEY = "308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A03818400028180243EC413CAECA15C34A20B76BF851B3E49A280474B2F1CEB5B68655768FE4F1D7EC7801A2EA8F053577B7F9AE0C9A7D0EAB2A7678C7C53631DF60441D8978BA627E28CF3C42AE42AE9D3D60DBCAAC59145F304B502BA1F6108048828B26F22FF7EF08101AFAF68325EEC4CD41BA4DC70C66C6A819B65C10622D62B058E63B4DE";
    private static final Map<String, Boolean> STD_ATTRIBUTES = new HashMap<String, Boolean>();
    private static final Map<String, String> FEATURE_FRIENDLY_NAMES = new HashMap<String, String>();
    private static final List<String> KNOWN_FEATURES = new ArrayList<String>();

    PingLicense(String rawData, String charset) throws UnsupportedEncodingException, LicenseNotFoundException {
        this.rawData = rawData;
        ByteArrayInputStream is = new ByteArrayInputStream(rawData.getBytes(charset));
        this.license = LicenseManager.loadLicense((InputStream)is);
        this.readConnectionLimitDetails();
        this.expirationDate = this.getExpirationDate();
        this.gracePeriodInMilliseconds = this.getGracePeriodInMilliseconds();
        this.valid = false;
    }

    public PingLicense(String rawData, boolean importLicense) throws UnsupportedEncodingException, LicenseNotFoundException {
        this.rawData = rawData;
        ByteArrayInputStream is = new ByteArrayInputStream(rawData.getBytes("UTF-8"));
        this.loadValidateLicense(is);
    }

    private void loadValidateLicense(ByteArrayInputStream is) throws LicenseNotFoundException {
        this.license = LicenseManager.loadLicense((InputStream)is);
        LicenseManager.setPublicKey((String)PUBLIC_KEY);
        try {
            this.valid = LicenseManager.isValid((License)this.license);
            if (!this.valid) {
                throw new GeneralSecurityException("License File is invalid.");
            }
            DisplayableLicense displayableLicense = new DisplayableLicense(this);
            log.debug((Object)("License validated:" + Util.LINE_BREAK + displayableLicense.getDetailInfo()));
            this.readConnectionLimitDetails();
            this.expirationDate = this.getExpirationDate();
            this.gracePeriodInMilliseconds = this.getGracePeriodInMilliseconds();
        }
        catch (GeneralSecurityException e) {
            this.valid = false;
            this.logWarn(e.getMessage() + " (import)");
        }
    }

    public PingLicense(Path licenseFilePath, boolean logWarnings) {
        this.logWarnings = logWarnings;
        this.loadLicenseFromFilename(licenseFilePath.toString());
    }

    public PingLicense(String licenseFileName) {
        this.loadLicenseFromFilename(licenseFileName);
        if (this.valid) {
            log.debug((Object)("License validated:" + Util.LINE_BREAK + this.getLogLicenseLoadedMsg()));
        }
    }

    public String getLogLicenseLoadedMsg() {
        DisplayableLicense displayableLicense = new DisplayableLicense(this);
        return displayableLicense.getDetailInfo();
    }

    private void loadLicenseFromFilename(String licenseFileName) {
        this.licenseFileName = licenseFileName;
        LicenseManager.setPublicKey((String)PUBLIC_KEY);
        try {
            this.license = LicenseManager.loadLicense((String)licenseFileName);
            File licenseFile = new File(licenseFileName);
            this.initTimestamp = licenseFile.lastModified();
            this.valid = LicenseManager.isValid((License)this.license);
            if (!this.valid) {
                throw new GeneralSecurityException("License File is invalid.");
            }
            this.readConnectionLimitDetails();
            this.expirationDate = this.getExpirationDate();
            this.gracePeriodInMilliseconds = this.getGracePeriodInMilliseconds();
        }
        catch (GeneralSecurityException e) {
            this.valid = false;
            this.logWarn(e.getMessage() + " (" + licenseFileName + ")");
        }
        catch (LicenseNotFoundException e) {
            this.valid = false;
        }
    }

    private void readConnectionLimitDetails() {
        this.connectionLimitDetails = null;
        String detailsString = this.getFeature(CONNECTION_LIMIT_DETAILS);
        if (detailsString != null) {
            this.connectionLimitDetails = new HashMap<String, LicenseConnectionGroup>();
            StringTokenizer tokenizer = new StringTokenizer(detailsString, "|");
            while (tokenizer.hasMoreTokens()) {
                String group = tokenizer.nextToken();
                String[] elements = group.split(";");
                LicenseConnectionGroup cnnGroup = new LicenseConnectionGroup();
                String grpName = elements[0];
                cnnGroup.setGroupName(grpName);
                if (elements[1] == null || "".equals(elements[1])) continue;
                int nConnections = Integer.parseInt(elements[1]);
                cnnGroup.setConnectionLimit(nConnections);
                try {
                    Date effectiveDate = new Date();
                    if (elements.length >= 3 && elements[2] != null && !"".equals(elements[2])) {
                        effectiveDate = this.parseDate(elements[2]);
                    }
                    cnnGroup.setEffectiveDate(effectiveDate);
                    Calendar expirationDateCal = Calendar.getInstance();
                    if (elements.length < 4 || elements[3] == null || "".equals(elements[3])) {
                        expirationDateCal.add(1, 30);
                    } else {
                        expirationDateCal.setTime(this.parseDate(elements[3]));
                    }
                    expirationDateCal.set(11, 23);
                    expirationDateCal.set(12, 59);
                    expirationDateCal.set(13, 59);
                    expirationDateCal.set(14, 999);
                    cnnGroup.setExpirationDate(expirationDateCal.getTime());
                    Calendar stopDate = Calendar.getInstance();
                    stopDate.setTime(cnnGroup.getExpirationDate());
                    Long gracePeriod = this.getGracePeriod();
                    if (gracePeriod != null) {
                        stopDate.add(5, gracePeriod.intValue());
                    }
                    cnnGroup.setStopDate(stopDate.getTime());
                    this.connectionLimitDetails.put(grpName, cnnGroup);
                }
                catch (ParseException e) {
                    log.error((Object)e.getMessage());
                }
            }
            log.debug((Object)("connectionLimitDetails: " + this.connectionLimitDetails));
        } else if (this.getFeature(CONNECTIONLIMIT) != null) {
            Integer limit = this.getIntLimit(CONNECTIONLIMIT);
            log.debug((Object)("ConnectionLimit: " + limit));
            Date now = new Date();
            Date expirationDate = this.getExpirationDate();
            this.connectionLimitDetails = new HashMap<String, LicenseConnectionGroup>();
            LicenseConnectionGroup cnnGroup = new LicenseConnectionGroup();
            cnnGroup.setGroupName("all");
            cnnGroup.setConnectionLimit(limit);
            cnnGroup.setEffectiveDate(now);
            Calendar expirationDateCal = Calendar.getInstance();
            if (expirationDate == null) {
                expirationDateCal.add(1, 30);
            } else {
                expirationDateCal.setTime(expirationDate);
            }
            expirationDateCal.set(11, 23);
            expirationDateCal.set(12, 59);
            expirationDateCal.set(13, 59);
            expirationDateCal.set(14, 999);
            cnnGroup.setExpirationDate(expirationDateCal.getTime());
            this.connectionLimitDetails.put("all", cnnGroup);
        } else {
            log.debug((Object)"unlimited connections");
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isChanged() {
        File licenseFile = this.getFile();
        return licenseFile.lastModified() != this.initTimestamp;
    }

    File getFile() {
        return new File(this.licenseFileName);
    }

    public boolean isValidProduct(String productName) {
        String feature = this.getProduct();
        return productName.equals(feature);
    }

    public String getProduct() {
        return this.getFeature(PRODUCT);
    }

    public boolean isBridgeMode() {
        String edge = this.getFeature(BRIDGE);
        return edge != null && Boolean.parseBoolean(edge);
    }

    public boolean isValidVersion(int major, int minor) {
        return this.isValidMajorVersion(major) && this.isValidMinorVersion(minor);
    }

    public boolean isValidMajorVersion(int major) {
        String feature = this.getVersion();
        if (feature != null) {
            int licMajor;
            String[] strings = feature.split("\\.");
            try {
                licMajor = Integer.parseInt(strings[0]);
            }
            catch (Exception e) {
                log.warn((Object)(feature + e));
                licMajor = -1;
            }
            return major == licMajor;
        }
        return false;
    }

    public boolean isValidMinorVersion(int minor) {
        String feature = this.getVersion();
        if (feature != null) {
            int licMinor;
            String[] strings = feature.split("\\.");
            try {
                if (strings.length > 1) {
                    licMinor = Integer.parseInt(strings[1]);
                } else {
                    log.warn((Object)"A minor license version was not found.");
                    licMinor = -1;
                }
            }
            catch (Exception e) {
                log.warn((Object)(feature + e));
                licMinor = -1;
            }
            return !this.check(MINOR) || minor == licMinor;
        }
        return false;
    }

    public String getVersion() {
        return this.getFeature(VERSION);
    }

    public boolean isExpiredWithRespectTo(Date date) {
        boolean isExp = false;
        if (this.expirationDate != null && !PERPETUAL.equals(this.getType())) {
            isExp = date.after(this.expirationDate);
        }
        return isExp;
    }

    public boolean isExpired() {
        return this.isExpiredWithRespectTo(new Date());
    }

    public boolean isExpiredPastGracePeriod() {
        boolean expiredPastGracePeriod = false;
        if (this.expirationDate != null && !PERPETUAL.equals(this.getType())) {
            Date now = new Date();
            Date expirationDateWithGracePeriod = new Date(this.expirationDate.getTime() + this.gracePeriodInMilliseconds);
            expiredPastGracePeriod = now.after(expirationDateWithGracePeriod);
        }
        return expiredPastGracePeriod;
    }

    public boolean hasExpirationDate() {
        return this.getExpirationDate() != null;
    }

    public Date getExpirationDate() {
        Date exDate = null;
        String feature = this.getFeature(EXPIRATIONDATE);
        if (!StringUtils.isBlank((String)feature)) {
            try {
                exDate = this.parseDate(feature);
            }
            catch (ParseException e) {
                exDate = new Date(0L);
                log.warn((Object)("ExpirationDate/" + feature + e));
            }
        }
        return exDate;
    }

    public Integer getNodeLimit() {
        return this.getIntLimit(NODELIMIT);
    }

    public Integer getConnectionLimit() {
        Integer limit = 0;
        if (this.connectionLimitDetails != null) {
            Date now = new Date();
            for (LicenseConnectionGroup grp : this.connectionLimitDetails.values()) {
                if (now.before(grp.getEffectiveDate()) || now.after(grp.getExpirationDate())) continue;
                limit = limit + grp.getConnectionLimit();
            }
        } else {
            limit = this.getIntLimit(CONNECTIONLIMIT);
        }
        if (limit != null) {
            log.debug((Object)("Total number of licensed connections: " + limit));
        }
        return limit;
    }

    public boolean exceedsNodeLimit(int nodes) {
        return this.exceeds(nodes, NODELIMIT);
    }

    public boolean exceedsConnectionLimit(int connections) {
        return this.exceeds(connections, CONNECTIONLIMIT);
    }

    public Long getGracePeriod() {
        return this.getLongLimit(GRACE_PERIOD);
    }

    public long getGracePeriodInMilliseconds() {
        Long gracePeriod = this.getGracePeriod();
        return gracePeriod == null ? 0L : gracePeriod * 24L * 3600L * 1000L;
    }

    public boolean isSendNotifications() {
        return this.check(NOTIF);
    }

    public boolean isStopService() {
        return this.check(SHUTDOWN);
    }

    public String getID() {
        return this.getFeature(ID);
    }

    public String getName() {
        return this.getFeature(NAME);
    }

    public String getOrganization() {
        return this.getFeature(ORGANIZATION);
    }

    public Date getIssueDate() {
        Date issueDate = null;
        String feature = this.getFeature(ISSUEDATE);
        if (!StringUtils.isBlank((String)feature)) {
            try {
                issueDate = this.parseDate(feature);
            }
            catch (ParseException e) {
                issueDate = new Date(0L);
                log.warn((Object)("IssueDate/" + feature + e));
            }
        }
        return issueDate;
    }

    public String getType() {
        return this.getFeature(TYPE);
    }

    public String getEnforcementType() {
        return this.getFeature(ENFORCEMENTTYPE);
    }

    public boolean licenseFileExists() {
        return this.license != null;
    }

    public String getFileData() {
        if (this.rawData == null) {
            this.rawData = this.licenseFileExists() ? SimpleFileUtil.readFileToStringSilent(this.getFile()) : "";
        }
        return this.rawData;
    }

    public String toString() {
        return this.getFileData();
    }

    public String getFingerPrint() {
        return HashUtil.hashToHexString((String)this.getFileData(), (HashAlgorithm)HashAlgorithm.SHA256);
    }

    void logWarn(String subMsg) {
        if (this.logWarnings) {
            log.warn((Object)(Util.LINE_BREAK + "**********************************************************" + Util.LINE_BREAK + subMsg + Util.LINE_BREAK + SALES_TALK + Util.LINE_BREAK + "**********************************************************"));
        }
    }

    private boolean check(int field) {
        int i;
        String feature = this.getFeature(ENFORCEMENTTYPE);
        try {
            i = Integer.parseInt(feature);
        }
        catch (NumberFormatException e) {
            i = SHUTDOWN + NOTIF + MINOR;
        }
        return this.check(field, i);
    }

    private boolean exceeds(long num, String name) {
        boolean exceeds = false;
        Long limit = this.getLongLimit(name);
        if (limit != null) {
            exceeds = num > limit;
        }
        return exceeds;
    }

    private Integer getIntLimit(String featureName) {
        Long longLimit = this.getLongLimit(featureName);
        return longLimit != null ? Integer.valueOf(longLimit.intValue()) : null;
    }

    private Long getLongLimit(String featureName) {
        Long limit = null;
        String feature = this.getFeature(featureName);
        if (!StringUtils.isBlank((String)feature)) {
            try {
                limit = Long.parseLong(feature);
            }
            catch (NumberFormatException e) {
                log.warn((Object)(featureName + " / " + feature + e));
                limit = 0L;
            }
        }
        return limit;
    }

    private boolean check(int field, int num) {
        return (field & num) == field;
    }

    public String getFeature(String name) {
        return this.license != null ? this.decodeSpecialLicenseChars(this.license.getFeatureAsString(name)) : null;
    }

    public Map<String, LicenseConnectionGroup> getConnectionLimitDetails() {
        return this.connectionLimitDetails;
    }

    public void setConnectionLimitDetails(Map<String, LicenseConnectionGroup> connectionLimitDetails) {
        this.connectionLimitDetails = connectionLimitDetails;
    }

    public LicenseConnectionGroup getLicenseConnectionGroup(String grpName) {
        LicenseConnectionGroup retV = null;
        if (this.connectionLimitDetails != null) {
            retV = this.connectionLimitDetails.get(grpName);
        }
        return retV;
    }

    public boolean hasConnectionLimitDetailsAttribute() {
        boolean retV = false;
        String detailsString = this.getFeature(CONNECTION_LIMIT_DETAILS);
        retV = detailsString != null;
        return retV;
    }

    public List<LicenseFeature> getOtherFeatures() {
        ArrayList<LicenseFeature> otherFeatures = new ArrayList<LicenseFeature>();
        List list = this.license.getFeatureList();
        if (list != null) {
            for (Object featureObj : list) {
                String featureName = (String)featureObj;
                if (STD_ATTRIBUTES.containsKey(featureName) || this.getFeature(featureName) == null) continue;
                String value = this.getFeature(featureName);
                String friendlyName = FEATURE_FRIENDLY_NAMES.get(featureName);
                if (friendlyName == null) {
                    friendlyName = featureName;
                }
                otherFeatures.add(new LicenseFeature(friendlyName, value));
            }
        }
        return otherFeatures;
    }

    public List<LicenseFeature> getNonStandardFeatures() {
        ArrayList<LicenseFeature> nonStandardFeatures = new ArrayList<LicenseFeature>();
        List list = this.license.getFeatureList();
        if (list != null) {
            for (Object featureObject : list) {
                String featureName;
                if (!(featureObject instanceof String) || KNOWN_FEATURES.contains(featureName = (String)featureObject) || this.getFeature(featureName) == null) continue;
                nonStandardFeatures.add(new LicenseFeature(featureName, this.getFeature(featureName)));
            }
        }
        return nonStandardFeatures;
    }

    public boolean isConnectionLimitDefined() {
        if (this.connectionLimitDetails != null) {
            LicenseConnectionGroup group = this.connectionLimitDetails.get("all");
            return group != null && group.getConnectionLimit() > 0;
        }
        return false;
    }

    public boolean isFeatureEnabled(String featureName) {
        return "true".equalsIgnoreCase(this.getFeature(featureName));
    }

    public boolean isAnyGroupExpiredWithRespectTo(Date date) {
        boolean isExp = false;
        String detailsString = this.getFeature(CONNECTION_LIMIT_DETAILS);
        if (detailsString != null) {
            for (LicenseConnectionGroup grp : this.connectionLimitDetails.values()) {
                Date expirationDate = grp.getExpirationDate();
                if (expirationDate == null || !date.after(expirationDate)) continue;
                isExp = true;
            }
        }
        return isExp;
    }

    public boolean areAllConnectionGroupExpiredWithRespectTo(Date date) {
        String detailsString = this.getFeature(CONNECTION_LIMIT_DETAILS);
        if (detailsString != null && this.connectionLimitDetails != null) {
            return this.connectionLimitDetails.values().parallelStream().allMatch(licenseConnectionGroup -> {
                Date expirationDate = licenseConnectionGroup.getExpirationDate();
                if (expirationDate != null) {
                    return date.after(expirationDate);
                }
                return false;
            });
        }
        return false;
    }

    public Date getFirstGroupExpirationDate() {
        Date firstExpiration = null;
        String detailsString = this.getFeature(CONNECTION_LIMIT_DETAILS);
        if (detailsString != null && this.connectionLimitDetails != null) {
            for (LicenseConnectionGroup grp : this.connectionLimitDetails.values()) {
                Date expirationDate = grp.getExpirationDate();
                if (expirationDate == null || firstExpiration != null && !expirationDate.before(firstExpiration)) continue;
                firstExpiration = expirationDate;
            }
        }
        return firstExpiration;
    }

    public Date getModifiedTime() {
        Date modifiedDate = new Date(this.initTimestamp);
        return modifiedDate;
    }

    private String decodeSpecialLicenseChars(String encoded) {
        String[] tokens;
        String value = encoded;
        if (encoded != null && encoded.startsWith(PREFIX_ENCODED + DELIMITER) && (tokens = encoded.split(DELIMITER)).length == 3) {
            String recalculatedHash = HashUtil.hashToHexString((String)(tokens[0] + DELIMITER + tokens[1]), (HashAlgorithm)HashAlgorithm.SHA1);
            recalculatedHash = HashUtil.hashToHexString((String)tokens[1], (HashAlgorithm)HashAlgorithm.SHA1);
            if (recalculatedHash.equalsIgnoreCase(tokens[2])) {
                byte[] b64decoded = B64.decodeToBytes((String)tokens[1]);
                try {
                    value = new String(b64decoded, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"There was problem decoding the license.  Please try again with a different one.");
                }
            }
        }
        return value;
    }

    private Date parseDate(String dateStr) throws ParseException {
        Date retDate = null;
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateParserFormat2 = new SimpleDateFormat("MM/dd/yyyy");
        try {
            retDate = dateParser.parse(dateStr);
        }
        catch (ParseException e) {
            retDate = dateParserFormat2.parse(dateStr);
        }
        return retDate;
    }

    public boolean isOAuthEnabled() {
        return this.isFeatureEnabled(OAUTH);
    }

    static {
        FEATURE_FRIENDLY_NAMES.put("SaasProvisioning", "Outbound Provisioning");
        FEATURE_FRIENDLY_NAMES.put("WSTrustSTS", "WS-Trust STS");
        FEATURE_FRIENDLY_NAMES.put(OAUTH, OAUTH);
        STD_ATTRIBUTES.put(ID, Boolean.TRUE);
        STD_ATTRIBUTES.put(NAME, Boolean.TRUE);
        STD_ATTRIBUTES.put(ORGANIZATION, Boolean.TRUE);
        STD_ATTRIBUTES.put(PRODUCT, Boolean.TRUE);
        STD_ATTRIBUTES.put(VERSION, Boolean.TRUE);
        STD_ATTRIBUTES.put(ISSUEDATE, Boolean.TRUE);
        STD_ATTRIBUTES.put(EXPIRATIONDATE, Boolean.TRUE);
        STD_ATTRIBUTES.put(CONNECTIONLIMIT, Boolean.TRUE);
        STD_ATTRIBUTES.put(NODELIMIT, Boolean.TRUE);
        STD_ATTRIBUTES.put(TYPE, Boolean.TRUE);
        STD_ATTRIBUTES.put(ENFORCEMENTTYPE, Boolean.TRUE);
        STD_ATTRIBUTES.put(CONNECTION_LIMIT_DETAILS, Boolean.TRUE);
        KNOWN_FEATURES.addAll(STD_ATTRIBUTES.keySet());
        KNOWN_FEATURES.add("SaasProvisioning");
        KNOWN_FEATURES.add("WSTrustSTS");
        KNOWN_FEATURES.add(OAUTH);
        KNOWN_FEATURES.add(BRIDGE);
        KNOWN_FEATURES.add(GRACE_PERIOD);
    }
}

