/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.license;

import com.pingidentity.common.util.TimerTaskBase;
import java.util.Date;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.NotificationEvaluator;
import org.sourceid.util.license.PingLicense;
import org.sourceid.util.license.Status;
import org.sourceid.util.license.StatusEvaluator;

class Watcher
extends TimerTaskBase {
    private StatusEvaluator statusEvaluator = new StatusEvaluator();
    private NotificationEvaluator notificationEvaluator = new NotificationEvaluator();
    private Status status = Status.UNKNOWN;
    private Status lastStatus;

    Watcher() {
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void doTask() {
        PingLicense license = LicenseManager.getLicense();
        this.doIt(license);
    }

    public synchronized void doIt(PingLicense license) {
        Date now = new Date();
        this.status = this.statusEvaluator.getStatus(license, now);
        if (this.lastStatus != this.status) {
            this.log.info((Object)("Server licensing status is now: " + this.status));
            this.lastStatus = this.status;
        }
        this.notificationEvaluator.evalNotifs(this.status, license, now);
    }
}

