/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.util.log.internal.IdentityMasker;
import org.sourceid.util.log.internal.Masker;
import org.sourceid.util.log.internal.Saml1xMasker;
import org.sourceid.util.log.internal.Saml2Masker;
import org.sourceid.util.log.internal.WsFedTokenMasker;
import org.sourceid.util.log.internal.WsTrustMasker;
import org.sourceid.websso.wrapper.BaseMessageContext;

public abstract class AttrMaskingXmlObjFactory<T extends BaseMessageContext> {
    private static final Masker IDENTITY_MASKER = new IdentityMasker();
    private Map<String, Masker> maskers = new HashMap<String, Masker>();

    protected AttrMaskingXmlObjFactory() {
        this.maskers.put("urn:oasis:names:tc:SAML:2.0:protocol", new Saml2Masker());
        this.maskers.put("urn:oasis:names:tc:SAML:1.0:protocol", new Saml1xMasker());
        this.maskers.put("http://schemas.xmlsoap.org/ws/2005/02/trust", new WsFedTokenMasker());
        WsTrustMasker wsTrustMasker = new WsTrustMasker();
        this.maskers.put("http://schemas.xmlsoap.org/soap/envelope/", wsTrustMasker);
        this.maskers.put("http://www.w3.org/2003/05/soap-envelope", wsTrustMasker);
    }

    public XmlObject getMasked(T msgCtx) {
        XmlObject xmlObject = ((BaseMessageContext)msgCtx).getXmlObject();
        if (xmlObject == null) {
            return xmlObject;
        }
        Set<String> maskedNames = this.doGetMaskedNames(msgCtx);
        if (maskedNames.isEmpty()) {
            return xmlObject;
        }
        Masker masker = this.doGetMasker(xmlObject);
        return masker.mask(xmlObject, maskedNames);
    }

    private Set<String> doGetMaskedNames(T msgCtx) {
        Set<String> maskedNames = this.getMaskedNames(msgCtx);
        if (maskedNames == null) {
            maskedNames = Collections.emptySet();
        }
        return maskedNames;
    }

    Masker doGetMasker(XmlObject xmlObject) {
        String ns;
        Masker masker;
        SchemaType schemaType = xmlObject.schemaType();
        QName docName = schemaType.getDocumentElementName();
        if (docName == null) {
            XmlCursor cursor = xmlObject.newCursor();
            cursor.toNextToken();
            docName = cursor.getName();
        }
        if ((masker = this.maskers.get(ns = docName.getNamespaceURI())) == null) {
            masker = IDENTITY_MASKER;
        }
        return masker;
    }

    abstract Set<String> getMaskedNames(T var1);
}

