/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import com.pingidentity.common.util.LogGuard;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class HttpRequestLoggingUtil {
    static final String DELIMITER_WITH_SPACE = ", ";
    private static final InheritableThreadLocal<HttpServletRequest> httpRequest = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Map<String, String>> headerMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    private static final InheritableThreadLocal<Map<String, String>> paramMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };

    public static void init(HttpServletRequest request) {
        if (request != null) {
            httpRequest.set(request);
        }
    }

    public static void cleanup() {
        httpRequest.remove();
        headerMap.remove();
        paramMap.remove();
    }

    public static String getHttpHeaderValue(String headerName) {
        String headerValue = (String)((Map)headerMap.get()).get(StringUtils.lowerCase((String)headerName));
        if (headerValue != null) {
            return headerValue;
        }
        return HttpRequestLoggingUtil.cacheHttpHeaderValuesFromRequest((HttpServletRequest)httpRequest.get(), headerName);
    }

    public static String getHttpParameterValue(String parameter) {
        String headerValue = (String)((Map)paramMap.get()).get(parameter);
        if (headerValue != null) {
            return headerValue;
        }
        return HttpRequestLoggingUtil.cacheHttpParamValuesFromRequest((HttpServletRequest)httpRequest.get(), parameter);
    }

    private static String cacheHttpParamValuesFromRequest(HttpServletRequest request, String paramName) {
        Object[] paramValues;
        if (request != null && (paramValues = request.getParameterValues(paramName)) != null) {
            String paramValuesStr = LogGuard.encode(StringUtils.join((Object[])paramValues, (String)DELIMITER_WITH_SPACE));
            ((Map)paramMap.get()).put(paramName, paramValuesStr);
            return paramValuesStr;
        }
        return "";
    }

    private static String cacheHttpHeaderValuesFromRequest(HttpServletRequest request, String headerName) {
        Enumeration headerValueEnum;
        if (request != null && (headerValueEnum = request.getHeaders(headerName)) != null && headerValueEnum.hasMoreElements()) {
            String headerValueStr = LogGuard.encode(HttpRequestLoggingUtil.concatStrWithDelimiter(headerValueEnum));
            ((Map)headerMap.get()).put(StringUtils.lowerCase((String)headerName), headerValueStr);
            return headerValueStr;
        }
        return "";
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)httpRequest.get();
    }

    private static String concatStrWithDelimiter(Enumeration<String> headerValuesEnum) {
        StringBuilder valuesStrBuilder = new StringBuilder();
        while (headerValuesEnum.hasMoreElements()) {
            valuesStrBuilder.append(headerValuesEnum.nextElement());
            if (!headerValuesEnum.hasMoreElements()) continue;
            valuesStrBuilder.append(DELIMITER_WITH_SPACE);
        }
        return valuesStrBuilder.toString();
    }
}

