/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log.internal;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.log.internal.Constants;
import org.sourceid.util.log.internal.Masker;
import org.w3c.dom.Node;

public class Saml2Masker
implements Masker {
    private static final String XPATH = "declare namespace saml='urn:oasis:names:tc:SAML:2.0:assertion' .//saml:Attribute";
    private static final String XPATH_SUBJECT = "declare namespace saml='urn:oasis:names:tc:SAML:2.0:assertion' .//saml:NameID";
    private static final String ENCRYPTED_ID_NODE_NAME = "EncryptedID";

    @Override
    public XmlObject mask(XmlObject srcXmlObj, Set<String> maskedAttrNames) {
        XmlObject[] xmlObjects;
        if (maskedAttrNames == null) {
            maskedAttrNames = new HashSet<String>();
        }
        XmlObject maskedXmlObj = srcXmlObj.copy();
        if (maskedAttrNames.contains(AssertionMapKeys.getNameIdValueKey())) {
            for (XmlObject xmlObject : xmlObjects = maskedXmlObj.selectPath(XPATH_SUBJECT)) {
                NameIDType nameId = (NameIDType)xmlObject;
                nameId.setStringValue("*****");
            }
        }
        for (XmlObject xmlObject : xmlObjects = maskedXmlObj.selectPath(XPATH)) {
            XmlObject[] attributeValueArray;
            AttributeType attribute = (AttributeType)xmlObject;
            String name = attribute.getName();
            if (!maskedAttrNames.contains(name)) continue;
            for (XmlObject av : attributeValueArray = attribute.getAttributeValueArray()) {
                if (this.isEncryptedIdInAttribute(av)) continue;
                av.set((XmlObject)Constants.MASKED_XML_STRING);
            }
        }
        return maskedXmlObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEncryptedIdInAttribute(XmlObject attributeValue) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = attributeValue.newCursor();
            if (xmlCursor.toFirstChild()) {
                Node childNode = xmlCursor.getDomNode();
                boolean bl = childNode.getNodeType() == 1 && ENCRYPTED_ID_NODE_NAME.equals(childNode.getLocalName());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }
}

