/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso;

import com.pingidentity.localidentity.TrackedParamsAuditLogger;
import com.pingidentity.monitoring.metrics.MeterManager;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.logging.LoggingUtil;
import com.pingidentity.sdk.oauth20.AccessToken;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.mgmt.AuditLoggingManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.token.AccessTokenWrapper;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AuditLoggingSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SamlNameID;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.license.LicenseMgrInfo;
import org.sourceid.util.reporting.TransactionCounter;
import org.sourceid.websso.servlet.ExtendedSri;

public class AuditLogger {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSZ";
    static ConfigStore configStore = ConfigStoreFarm.getConfig("audit-log-config");
    static final String CONFIG_STORE_TIMEZONE = "timezone";
    static final String CONFIG_STORE_DATETIME_FORMAT = "datetimeformat";
    public static final String ROLE_IDP = "IdP";
    public static final String ROLE_SP = "SP";
    public static final String ROLE_AS = "AS";
    public static final String EVENT_SSO = "SSO";
    public static final String EVENT_SLO = "SLO";
    public static final String AUTHN_ATTEMPT = "AUTHN_ATTEMPT";
    public static final String AUTHN_REQUEST = "AUTHN_REQUEST";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String IN_PROGRESS = "inprogress";
    private static String hostname = null;

    public static void init() {
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                hostname = "unknown";
            }
        }
        ThreadContext.put((String)MDC_KEY.HOST.toString(), (String)hostname);
        ThreadContext.put((String)MDC_KEY.STATUS.toString(), (String)SUCCESS);
        LicenseMgrInfo licenseMgrInfo = GlobalRegistry.getService(LicenseMgrInfo.class);
        ThreadContext.put((String)MDC_KEY.PF_VERSION.toString(), (String)(licenseMgrInfo.getMajorVersion() + "." + licenseMgrInfo.getMinorVersion()));
    }

    public static void put(String key, String value) {
        if (value != null) {
            ThreadContext.put((String)key, (String)value);
        }
    }

    public static void cleanup() {
        for (MDC_KEY mdcKey : MDC_KEY.values()) {
            ThreadContext.remove((String)mdcKey.toString());
        }
        TrackedParamsAuditLogger.cleanup();
    }

    public static void setUserName(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            AuditLogger.put(MDC_KEY.SUBJECT.toString(), value);
        }
    }

    public static void setUserName(Map<String, AttributeValue> assertionAttributes) {
        AttributeValue nameIdAttribute = assertionAttributes.get(AssertionMapKeys.getNameIdValueKey());
        if (nameIdAttribute != null) {
            String nameId = nameIdAttribute.getValue(true);
            AuditLogger.put(MDC_KEY.SUBJECT.toString(), nameId);
        }
    }

    public static void setUserName(NameIDType nameId) {
        if (nameId != null) {
            AuditLogger.put(MDC_KEY.SUBJECT.toString(), nameId.getStringValue());
        }
    }

    public static void setUserName(SamlNameID nameId) {
        if (nameId != null) {
            AuditLogger.put(MDC_KEY.SUBJECT.toString(), nameId.getValue());
        }
    }

    public static void setUserName(AccessTokenWrapper accessTokenWrapper, AccessToken token) {
        if (accessTokenWrapper.getTokenManager() != null && StringUtils.isNotBlank((String)accessTokenWrapper.getTokenManager().findEffectiveDefaultSubjectAttribute())) {
            AttributeValue tokenSubjectAttrValue = (AttributeValue)token.getAttributes().get(accessTokenWrapper.getTokenManager().findEffectiveDefaultSubjectAttribute());
            if (tokenSubjectAttrValue != null) {
                AuditLogger.setUserName(tokenSubjectAttrValue.getValue());
            }
        } else {
            AccessGrant accessGrant = MgmtFactory.getAccessGrantManager().getByGuid(token.getAccessGrantGuid());
            if (accessGrant != null && StringUtils.isNotBlank((String)accessGrant.getUniqueUserIdentifer())) {
                AuditLogger.setUserName(accessGrant.getUniqueUserIdentifer());
            }
        }
    }

    public static void clearUserName() {
        ThreadContext.remove((String)MDC_KEY.SUBJECT.toString());
    }

    public static boolean isUserNameBlank() {
        return StringUtils.isBlank((String)ThreadContext.get((String)MDC_KEY.SUBJECT.toString()));
    }

    public static boolean isAttributesBlank() {
        return StringUtils.isBlank((String)ThreadContext.get((String)MDC_KEY.ATTRIBUTES.toString()));
    }

    public static boolean isDescriptionBlank() {
        return StringUtils.isBlank((String)ThreadContext.get((String)MDC_KEY.DESCRIPTION.toString()));
    }

    public static void setAppUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            int idx = url.indexOf("?");
            String app = url;
            if (idx > 0) {
                app = url.substring(0, idx);
            }
            ThreadContext.put((String)MDC_KEY.APP.toString(), (String)app);
            ThreadContext.put((String)MDC_KEY.FULL_APP_URL.toString(), (String)url);
        }
    }

    public static void setPartnerId(String partnerId) {
        if (partnerId == null) {
            return;
        }
        ThreadContext.put((String)MDC_KEY.PARTNER_ID.toString(), (String)partnerId);
        Client client = MgmtFactory.getClientManager().getCachedClient(partnerId);
        if (client != null) {
            ThreadContext.put((String)MDC_KEY.PARTNER_NAME.toString(), (String)client.getName());
        } else {
            ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
            Optional<ConnectionDbEntry> firstFound = Optional.ofNullable(connectionDb.getEntryByEntityId(Role.SP, partnerId));
            if (firstFound.isEmpty()) {
                firstFound = Optional.ofNullable(connectionDb.getEntryByEntityId(Role.IDP, partnerId));
            }
            firstFound.ifPresent(connectionDbEntry -> ThreadContext.put((String)MDC_KEY.PARTNER_NAME.toString(), (String)connectionDbEntry.getName()));
        }
    }

    public static void clearPartnerId() {
        ThreadContext.remove((String)MDC_KEY.PARTNER_NAME.toString());
        ThreadContext.remove((String)MDC_KEY.PARTNER_ID.toString());
    }

    public static void setVirtualServerId(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)MDC_KEY.VIRTUAL_SERVER_ID.toString(), (String)value);
        }
    }

    public static void clearVirtualServerId() {
        ThreadContext.remove((String)MDC_KEY.VIRTUAL_SERVER_ID.toString());
    }

    public static void setHost(String host) {
        ThreadContext.put((String)MDC_KEY.HOST.toString(), (String)host);
    }

    public static void setRemoteAddress(String remoteAddress) {
        ThreadContext.put((String)MDC_KEY.REMOTE_ADDRESS.toString(), (String)remoteAddress);
    }

    public static void setProtocol(String protocol) {
        ThreadContext.put((String)MDC_KEY.PROTOCOL.toString(), (String)protocol);
    }

    public static void setStatus(String value) {
        ThreadContext.put((String)MDC_KEY.STATUS.toString(), (String)value);
    }

    public static String getStatus() {
        return ThreadContext.get((String)MDC_KEY.STATUS.toString());
    }

    public static void clearStatus() {
        ThreadContext.remove((String)MDC_KEY.STATUS.toString());
    }

    public static void setRequestStartTime(Long startTime) {
        ThreadContext.put((String)MDC_KEY.REQUEST_START_TIME.toString(), (String)startTime.toString());
    }

    public static void setRequestStartTime(HttpServletRequest request) {
        Long startTime = (Long)request.getAttribute("com.pingidentity.appserver.REQUEST_TIMESTAMP");
        if (startTime != null) {
            AuditLogger.setRequestStartTime(startTime);
        }
    }

    public static void updateResponseTime() {
        String requestStartTimeStr = ThreadContext.get((String)MDC_KEY.REQUEST_START_TIME.toString());
        Long requestStartTime = null;
        try {
            requestStartTime = Long.valueOf(requestStartTimeStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (requestStartTime != null) {
            long responseTimeMillis = System.currentTimeMillis() - requestStartTime;
            ThreadContext.put((String)MDC_KEY.RESPONSE_TIME.toString(), (String)Long.toString(responseTimeMillis));
        } else {
            ThreadContext.put((String)MDC_KEY.RESPONSE_TIME.toString(), (String)"0");
        }
    }

    public static void setTlsVersion(String tlsVersion) {
        ThreadContext.put((String)MDC_KEY.TLS_VERSION.toString(), (String)tlsVersion);
    }

    public static void setPersistentSessionGroupId(String value) {
        ThreadContext.put((String)MDC_KEY.SESSION_GROUP_ID.toString(), (String)value);
    }

    public static void setExtendedSri(ExtendedSri extendedSri) {
        ThreadContext.put((String)MDC_KEY.SRI.toString(), (String)extendedSri.getExtendedSri());
        if (extendedSri.getPersistentSessionGroupId() != null) {
            AuditLogger.setPersistentSessionGroupId(extendedSri.getPersistentSessionGroupId());
        }
    }

    public static void clearExtendedSri() {
        ThreadContext.remove((String)MDC_KEY.SRI.toString());
    }

    public static void setUniqueUserKey(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)MDC_KEY.UNIQUE_USER_KEY.toString(), (String)value);
        }
    }

    public static void clearUniqueUserKey() {
        ThreadContext.remove((String)MDC_KEY.UNIQUE_USER_KEY.toString());
    }

    public static void setLocalUserId(String value) {
        ThreadContext.put((String)MDC_KEY.LOCAL_USER_ID.toString(), (String)value);
    }

    public static void setEvent(String value) {
        ThreadContext.put((String)MDC_KEY.EVENT.toString(), (String)value);
    }

    public static String getEvent() {
        return ThreadContext.get((String)MDC_KEY.EVENT.toString());
    }

    public static void setAttributes(String value) {
        if (value.contains("{") && value.contains("}")) {
            value = StringUtils.substringBefore((String)StringUtils.substringAfter((String)value, (String)"{"), (String)"}");
        }
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)MDC_KEY.ATTRIBUTES.toString(), (String)value);
        }
    }

    public static void setDescription(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)MDC_KEY.DESCRIPTION.toString(), (String)value);
        }
    }

    protected static void setAdapterInstanceId(String adapterId) {
        if (StringUtils.isNotBlank((String)adapterId)) {
            ThreadContext.put((String)MDC_KEY.ADAPTER_INSTANCE_ID.toString(), (String)adapterId);
        }
    }

    public static void setAuthnSourceId(AuthnSourceKey authnSourceKey) {
        if (authnSourceKey != null) {
            if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                AuditLogger.setAdapterInstanceId(authnSourceKey.getId());
            }
            if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
                IdpConnection idpConn = metadataDirectory.getIdpConnectionBySystemId(authnSourceKey.getId(), false);
                if (idpConn != null) {
                    AuditLogger.setAuthnSourceId(idpConn);
                }
            } else {
                ThreadContext.put((String)MDC_KEY.AUTHN_SOURCE_ID.toString(), (String)(AuditLogger.getAuthnSourceIdPrefix(authnSourceKey.getType()) + authnSourceKey.getId()));
            }
        }
    }

    public static void removeAuthnSourceId() {
        ThreadContext.remove((String)MDC_KEY.AUTHN_SOURCE_ID.toString());
        ThreadContext.remove((String)MDC_KEY.ADAPTER_INSTANCE_ID.toString());
    }

    public static void setAuthnSourceId(IdpConnection idpConn) {
        ThreadContext.put((String)MDC_KEY.AUTHN_SOURCE_ID.toString(), (String)(AuditLogger.getAuthnSourceIdPrefix(AuthnSourceKey.AuthnSourceType.IDP_CONN) + idpConn.getEntityId()));
        ThreadContext.remove((String)MDC_KEY.ADAPTER_INSTANCE_ID.toString());
    }

    public static void setAuthnSourceId(Collection<AuthnSourceKey> authnSourceKeys) {
        if (authnSourceKeys != null && !authnSourceKeys.isEmpty()) {
            if (authnSourceKeys.size() == 1) {
                AuditLogger.setAuthnSourceId(authnSourceKeys.iterator().next());
                return;
            }
            String arrayPrefix = "[";
            String arraySuffix = "]";
            StringBuilder strBuilder = new StringBuilder(64);
            StringBuilder adapterOnlyStrBuilder = new StringBuilder(64);
            strBuilder.append("[");
            adapterOnlyStrBuilder.append("[");
            boolean first = true;
            boolean firstAdapter = true;
            for (AuthnSourceKey authnSourceKey : authnSourceKeys) {
                if (first) {
                    first = false;
                } else {
                    strBuilder.append(", ");
                }
                String authnSourceIdPrefix = AuditLogger.getAuthnSourceIdPrefix(authnSourceKey.getType());
                if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                    MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
                    IdpConnection idpConn = metadataDirectory.getIdpConnectionBySystemId(authnSourceKey.getId(), false);
                    if (idpConn == null) continue;
                    strBuilder.append(authnSourceIdPrefix).append(idpConn.getEntityId());
                    continue;
                }
                if (firstAdapter) {
                    firstAdapter = false;
                } else {
                    adapterOnlyStrBuilder.append(", ");
                }
                strBuilder.append(authnSourceIdPrefix).append(authnSourceKey.getId());
                adapterOnlyStrBuilder.append(authnSourceKey.getId());
            }
            strBuilder.append("]");
            adapterOnlyStrBuilder.append("]");
            if (adapterOnlyStrBuilder.length() > "[".length() + "]".length()) {
                AuditLogger.setAdapterInstanceId(adapterOnlyStrBuilder.toString());
            } else {
                ThreadContext.remove((String)MDC_KEY.ADAPTER_INSTANCE_ID.toString());
            }
            ThreadContext.put((String)MDC_KEY.AUTHN_SOURCE_ID.toString(), (String)strBuilder.toString());
        }
    }

    public static void setPcvId(String pcvId) {
        if (StringUtils.isBlank((String)pcvId)) {
            return;
        }
        ThreadContext.put((String)MDC_KEY.VALIDATOR_ID.toString(), (String)pcvId);
    }

    public static void setRole(String role) {
        ThreadContext.put((String)MDC_KEY.ROLE.toString(), (String)role);
    }

    public static void cleanupAuthnAttempt() {
        ThreadContext.remove((String)MDC_KEY.VALIDATOR_ID.toString());
        ThreadContext.remove((String)MDC_KEY.SUBJECT.toString());
        ThreadContext.remove((String)MDC_KEY.DESCRIPTION.toString());
        ThreadContext.remove((String)MDC_KEY.ADAPTER_INSTANCE_ID.toString());
        ThreadContext.remove((String)MDC_KEY.AUTHN_SOURCE_ID.toString());
        ThreadContext.remove((String)MDC_KEY.STATUS.toString());
        ThreadContext.put((String)MDC_KEY.EVENT.toString(), (String)EVENT_SSO);
    }

    public static SimpleDateFormat getDateFormat() {
        SimpleDateFormat expiryDateFormat;
        String datetimeFormat = configStore.getStringValue(CONFIG_STORE_DATETIME_FORMAT, DEFAULT_DATE_PATTERN);
        try {
            expiryDateFormat = new SimpleDateFormat(datetimeFormat);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            expiryDateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        }
        TimeZone timeZone = TimeZone.getDefault();
        try {
            String timezoneId = configStore.getStringValue(CONFIG_STORE_TIMEZONE);
            if (StringUtils.isNotEmpty((String)timezoneId) && Arrays.asList(TimeZone.getAvailableIDs()).contains(timezoneId)) {
                timeZone = TimeZone.getTimeZone(timezoneId);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        expiryDateFormat.setTimeZone(timeZone);
        return expiryDateFormat;
    }

    private static String getAuthnSourceIdPrefix(AuthnSourceKey.AuthnSourceType authnSourceType) {
        switch (authnSourceType) {
            case ADAPTER: {
                return "adapter.";
            }
            case IDP_CONN: {
                return "idpConnection.";
            }
            case LOCAL_IDENTITY: {
                return "localIdentity.";
            }
        }
        return "";
    }

    public static void setInXmlMsg(String inXmlMessage) {
        if (StringUtils.isNotBlank((String)inXmlMessage)) {
            ThreadContext.put((String)MDC_KEY.IN_XML_MESSAGE.toString(), (String)inXmlMessage);
        }
    }

    public static void setOutXmlMsg(String outXmlMessage) {
        if (StringUtils.isNotBlank((String)outXmlMessage)) {
            ThreadContext.put((String)MDC_KEY.OUT_XML_MESSAGE.toString(), (String)outXmlMessage);
        }
    }

    public static void setRequestJti(String jti) {
        String existingValue = ThreadContext.get((String)MDC_KEY.REQUEST_JTI.toString());
        String valueToStore = existingValue == null ? jti : (Stream.of(existingValue.split(",")).noneMatch(current -> current.equals(jti)) ? existingValue + "," + jti : existingValue);
        ThreadContext.put((String)MDC_KEY.REQUEST_JTI.toString(), (String)valueToStore);
    }

    public static void clearRequestJti() {
        ThreadContext.remove((String)MDC_KEY.REQUEST_JTI.toString());
    }

    public static void setAccessTokenJti(String jti) {
        ThreadContext.put((String)MDC_KEY.AT_JTI.toString(), (String)jti);
    }

    public static void setIdTokenJti(String jti) {
        ThreadContext.put((String)MDC_KEY.ID_TOKEN_JTI.toString(), (String)jti);
    }

    public static void setInAuthorizationCodeHash(String authorizationCode) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)authorizationCode)).ifPresent(hash -> ThreadContext.put((String)MDC_KEY.IN_AC_HASH.toString(), (String)hash));
    }

    public static void setOutAuthorizationCodeHash(String authorizationCode) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)authorizationCode)).ifPresent(hash -> ThreadContext.put((String)MDC_KEY.OUT_AC_HASH.toString(), (String)hash));
    }

    public static void setInAccessTokenHash(String accessToken) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)accessToken)).ifPresent(hash -> ThreadContext.put((String)MDC_KEY.IN_AT_HASH.toString(), (String)hash));
    }

    public static void setOutAccessTokenHash(String accessToken) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)accessToken)).ifPresent(hash -> ThreadContext.put((String)MDC_KEY.OUT_AT_HASH.toString(), (String)hash));
    }

    public static void setInRefreshTokenHash(String refreshToken) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)refreshToken)).ifPresent(hash -> ThreadContext.put((String)MDC_KEY.IN_RT_HASH.toString(), (String)hash));
    }

    public static void setOutRefreshTokenHash(String refreshToken) {
        Optional.ofNullable(LoggingUtil.calculateHashForLogging((String)refreshToken)).ifPresent(hash -> ThreadContext.put((String)MDC_KEY.OUT_RT_HASH.toString(), (String)hash));
    }

    protected static void checkUpdateTransactionCounters() {
        String event = AuditLogger.getEvent();
        String status = AuditLogger.getStatus();
        if (EVENT_SSO.equals(event) || EVENT_SLO.equals(event) || "OAuth".equals(event) || "STS".equals(event)) {
            if (SUCCESS.equals(status)) {
                MeterManager.getInstance().getTransactionCounter().increment();
                TransactionCounter.TOTAL_TRANSACTIONS.increment();
            } else if (FAILURE.equals(status)) {
                MeterManager.getInstance().getTransactionCounter().increment();
                MeterManager.getInstance().getTransactionErrorsCounter().increment();
                TransactionCounter.TOTAL_TRANSACTIONS.increment();
                TransactionCounter.TOTAL_FAILED_TRANSACTIONS.increment();
            }
        }
    }

    public static void setPolicyName(String policyName) {
        if (StringUtils.isNotBlank((String)policyName)) {
            ThreadContext.put((String)MDC_KEY.POLICY_NAME.toString(), (String)policyName);
        }
    }

    public static void setFragmentName(String fragmentName) {
        if (StringUtils.isNotBlank((String)fragmentName)) {
            ThreadContext.put((String)MDC_KEY.FRAGMENT_NAME.toString(), (String)fragmentName);
        }
    }

    public static void clearPoliciesUsed() {
        ThreadContext.remove((String)MDC_KEY.POLICY_NAME.toString());
        ThreadContext.remove((String)MDC_KEY.FRAGMENT_NAME.toString());
    }

    public static String getPolicyName() {
        return ThreadContext.get((String)MDC_KEY.POLICY_NAME.toString());
    }

    public static String getFragmentName() {
        return ThreadContext.get((String)MDC_KEY.FRAGMENT_NAME.toString());
    }

    public static void removeFragmentName() {
        ThreadContext.remove((String)MDC_KEY.FRAGMENT_NAME.toString());
    }

    public static void log(Log log, String msg) {
        block2: {
            AuditLoggingManager manager = MgmtFactory.getAuditLoggingManager();
            try {
                log.info((Object)msg);
                manager.getAuditLoggingErrorMonitor().success();
            }
            catch (AppenderLoggingException e) {
                manager.getAuditLoggingErrorMonitor().failure();
                log.trace((Object)("Failed to log message: " + msg), (Throwable)e);
                if (!AuditLoggingSettings.AuditLoggingFailureMode.BLOCK.equals((Object)manager.getAuditLoggingSettings().getFailureMode())) break block2;
                throw e;
            }
        }
    }

    public static enum MDC_KEY {
        SUBJECT("subject"),
        REMOTE_ADDRESS("ip"),
        FULL_APP_URL("fullappurl"),
        APP("app"),
        PARTNER_ID("connectionid"),
        PARTNER_NAME("connectionname"),
        VIRTUAL_SERVER_ID("virtualserverid"),
        HOST("host"),
        PROTOCOL("protocol"),
        EVENT("event"),
        ROLE("role"),
        STATUS("status"),
        LOCAL_USER_ID("localuserid"),
        ATTRIBUTES("attributes"),
        PF_VERSION("pfversion"),
        ADAPTER_INSTANCE_ID("adapterid"),
        AUTHN_SOURCE_ID("authenticationsourceid"),
        VALIDATOR_ID("validatorid"),
        TARGET_SESSION_ID("targetsessionid"),
        DESCRIPTION("description"),
        REQUEST_START_TIME("requeststarttime"),
        RESPONSE_TIME("responsetime"),
        TLS_VERSION("tlsversion"),
        SESSION_GROUP_ID("sessiongroupid"),
        SRI("sri"),
        UNIQUE_USER_KEY("uniqueuserkey"),
        IN_MESSAGE_TYPE("inmessagetype"),
        INITIATOR("initiator"),
        ASSERTION_ID("assertionid"),
        REQUEST_ID("requestid"),
        RESPONSE_ID("responseid"),
        IN_RESPONSE_TO("inresponseto"),
        IN_XML_MESSAGE("inxmlmsg"),
        OUT_XML_MESSAGE("outxmlmsg"),
        OUT_URL("outurl"),
        AT_TRACKING_ID("attrackingid"),
        ACCESS_GRANT_GUID("accessgrantguid"),
        GRANT_TYPE("granttype"),
        REQUEST_JTI("requestjti"),
        AT_JTI("atjti"),
        IN_AC_HASH("inachash"),
        OUT_AC_HASH("outachash"),
        IN_AT_HASH("inathash"),
        OUT_AT_HASH("outathash"),
        IN_RT_HASH("inrthash"),
        OUT_RT_HASH("outrthash"),
        ID_TOKEN_JTI("idtjti"),
        STS_PLUGIN_ID("stspluginid"),
        AUTHN_SESS_EXPIRY("authnsessionexpiry"),
        PLUGIN_TYPE("plugin_type"),
        PLUGIN_VERSION("plugin_version"),
        PLUGIN_ID("plugin_id"),
        POLICY_NAME("policyname"),
        FRAGMENT_NAME("fragmentname");

        private final String name;

        private MDC_KEY(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

