/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.SessionAwareAuthenticationAdapter;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailsUtil;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.profiles.idp.AuthenticationPolicyTreePostProcessor;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.PolicyTreeState;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPluginKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessor;
import org.sourceid.websso.authn.AuthnProcessorResult;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.servlet.SessionIdUtil;

public abstract class AbstractAdapterAuthnProcessor<T extends AuthnSourceKey>
implements AuthnProcessor<T> {
    protected AdapterManager adapterManager = MgmtFactory.getAdapterManager();
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    protected Log log = LogFactory.getLog(this.getClass());
    private AuthenticationPolicyTreePostProcessor authenticationPolicyTreePostProcessor = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthnProcessorResult lookupAuthN(HttpServletRequest req, HttpServletResponse resp, T adapterKey, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, boolean adapterLogoutRequired) throws AuthnAdapterException, IOException {
        AuthnProcessorResult result;
        AuthnProcessorResult.AuthenticationAttemptAuditor auditor;
        String userId;
        AuthnAdapterResponse.AUTHN_STATUS authnStatus;
        String adapterInstanceId;
        Map authnIdentifiers;
        block51: {
            String entityId = (String)stateParams.get("PartnerEntityId");
            authnIdentifiers = null;
            adapterInstanceId = ((AuthnSourceKey)adapterKey).getId();
            IdpAuthenticationAdapter idpAuthNAdapter = this.getAuthnAdapter(adapterInstanceId, entityId);
            AuthnPluginKey pluginKey = this.getAuthnPluginKey(adapterInstanceId, entityId);
            AuthnPolicyUtil.getDefault().setCurrentAuthnPlugin(req, stateParams, pluginKey);
            authnStatus = null;
            userId = null;
            auditor = null;
            try {
                if (idpAuthNAdapter instanceof IdpAuthenticationAdapterV2) {
                    String policyAction;
                    PolicyTreeState policyTreeState;
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("com.pingidentity.adapter.input.parameter.instanceid", adapterInstanceId);
                    String baseUrl = this.localMetaData.getBaseUrl();
                    String currentBaseUrl = BaseUrlAccessor.getCurrentBaseUrl();
                    String trackingId = TrackingIdSupport.generateTrackingId(req, resp);
                    String requestId = TrackingIdSupport.getRequestId();
                    String transactionId = TransactionIdSupport.getTransactionId();
                    String oauthClientId = (String)stateParams.get(Parameters.CLIENT_ID);
                    String oauthClientName = (String)stateParams.get(AdapterDefaultTemplateParams.CLIENT_NAME.getParamName());
                    String applicationName = (String)stateParams.get("applicationName");
                    String applicationIcon = (String)stateParams.get("applicationIcon");
                    String scope = (String)stateParams.get(Parameters.SCOPE);
                    String authorizationDetails = (String)stateParams.get("authorization_details");
                    Map requestJwtClaims = (Map)stateParams.get("request");
                    userId = (String)stateParams.get("chainedUserId");
                    Map<String, Object> chainedAttrs = (Map<String, Object>)stateParams.get("chainedAttributes");
                    if (chainedAttrs == null && (policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams)) != null) {
                        chainedAttrs = policyTreeState.getChainedAttributes();
                    }
                    String spAdapterId = (String)stateParams.get("SpSessionAuthnAdapterId");
                    DeviceSharingType deviceSharingType = IdpSessionRegistrySupport.getDeviceSharingTypeFromStateParams(stateParams);
                    String action = (String)stateParams.get("adapterAction");
                    params.put("com.pingidentity.adapter.input.parameter.server.base.url", baseUrl);
                    params.put("com.pingidentity.adapter.input.parameter.current.server.base.url", currentBaseUrl);
                    params.put("com.pingidentity.adapter.input.parameter.partner.entityid", entityId);
                    params.put("com.pingidentity.adapter.input.parameter.authn.policy", authnPolicy);
                    params.put("com.pingidentity.adapter.input.parameter.resume.path", resumePath);
                    params.put("com.pingidentity.adapter.input.parameter.tracking.id", trackingId);
                    params.put("com.pingidentity.adapter.input.parameter.request.id", requestId);
                    params.put("com.pingidentity.adapter.input.parameter.transaction.id", transactionId);
                    params.put("com.pingidentity.adapter.input.parameter.oauth.client.id", oauthClientId);
                    params.put("com.pingidentity.adapter.input.parameter.oauth.client.name", oauthClientName);
                    params.put("com.pingidentity.adapter.input.parameter.application.name", applicationName);
                    params.put("com.pingidentity.adapter.input.parameter.application.icon.url", applicationIcon);
                    params.put("com.pingidentity.adapter.input.parameter.signed.request.claims", requestJwtClaims);
                    params.put("com.pingidentity.adapter.input.parameter.adapter.action", action);
                    params.put("com.pingidentity.adapter.input.parameter.sri", SessionIdUtil.getInstance().getExtendedSriV2(req, resp, stateParams));
                    String oidcUiLocalesStr = (String)stateParams.get("ui_locales");
                    if (StringUtils.isNotBlank((String)oidcUiLocalesStr)) {
                        params.put("com.pingidentity.adapter.input.parameter.oidc.ui.locales", oidcUiLocalesStr);
                    }
                    Locale locale = LocaleUtil.getUserLocale(req);
                    params.put("com.pingidentity.adapter.input.parameter.oauth.scope.default.description", ScopeUtil.getDefaultScopeDescription(locale));
                    params.put("com.pingidentity.adapter.input.parameter.oauth.scope", scope);
                    if (StringUtils.isNotBlank((String)scope)) {
                        Scope requestedScope = Scope.getScope((String)scope);
                        params.put("com.pingidentity.adapter.input.parameter.oauth.scope.descriptions", ScopeUtil.getDescriptionsForRequestedScope(MgmtFactory.getClientManager().getCachedClient(oauthClientId), requestedScope, locale));
                    }
                    params.put("com.pingidentity.adapter.input.parameter.oauth.authorization.details", authorizationDetails);
                    if (StringUtils.isNotBlank((String)authorizationDetails)) {
                        AuthorizationDetails requestedAuthorizationDetails = new AuthorizationDetails(authorizationDetails);
                        params.put("com.pingidentity.adapter.input.parameter.oauth.authorization.detail.descriptions", AuthorizationDetailsUtil.getDescriptions(requestedAuthorizationDetails, req, oauthClientId, Scope.getScope((String)scope)));
                    }
                    params.put("com.pingidentity.adapter.input.parameter.device.sharing.type", deviceSharingType.name());
                    Map trackedParams = stateParams.getOrDefault("pf.TrackedHttpParams", new HashMap());
                    params.put("com.pingidentity.adapter.tracked.http.request.params", trackedParams == null ? Collections.emptyMap() : Collections.unmodifiableMap(trackedParams));
                    this.populateUserId(stateParams, params);
                    if (chainedAttrs != null) {
                        params.put("com.pingidentity.adapter.input.parameter.chained.attributes", chainedAttrs);
                    }
                    if (StringUtils.isNotBlank((String)spAdapterId)) {
                        params.put("com.pingidentity.adapter.input.parameter.sp.adapter.id", spAdapterId);
                    }
                    if (StringUtils.isNotBlank((String)(policyAction = (String)stateParams.get("PolicyAction")))) {
                        params.put("policy.action", policyAction);
                    }
                    params.putAll(this.getAdditionalParams(req, resp, stateParams));
                    AuthnApiApplication apiApplication = AuthnApiPolicyUtil.getDefault().getAuthnApiApplication((ConfigurablePlugin)idpAuthNAdapter, stateParams);
                    if (apiApplication != null) {
                        AuthnApiPolicyUtil.getDefault().saveEffectiveAuthnApiApplication(stateParams, apiApplication);
                    }
                    if ((result = this.getResultFromSession(req, resp, stateParams, (Map<String, Object>)params, (AuthnSourceKey)adapterKey, idpAuthNAdapter, userId, authnPolicy, adapterLogoutRequired)) != null) break block51;
                    AuthnAdapterResponse adapterResponse = this.tryLookupAuthnNoInteraction((IdpAuthenticationAdapterV2)idpAuthNAdapter, req, resp, params, stateParams, adapterLogoutRequired);
                    boolean redirectRequiredAndTryLookupAuthn = false;
                    if (adapterResponse == null || adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.FAILURE) {
                        adapterResponse = null;
                        switch (AuthnApiPolicyUtil.getDefault().checkSendAuthnApiRedirect((ConfigurablePlugin)idpAuthNAdapter, pluginKey, req, resp, stateParams, resumePath)) {
                            case RESUME_SENT: {
                                result = this.makeInProgressResult();
                                break;
                            }
                            case REDIRECT_REQUIRED: {
                                if (Boolean.TRUE.equals(idpAuthNAdapter.getAdapterDescriptor().getMetadata().get("TryLookupAuthn"))) {
                                    redirectRequiredAndTryLookupAuthn = true;
                                    params.put("com.pingidentity.adapter.input.parameter.try.lookup.authn", true);
                                    break;
                                }
                                AuthnApiPolicyUtil.getDefault().redirectToEffectiveAuthnApiApplication(pluginKey, resp, stateParams, resumePath);
                                result = this.makeInProgressResult();
                                break;
                            }
                            case CONTINUE: {
                                break;
                            }
                            default: {
                                throw new ProcessRuntimeException("Unexpected result from checkSendAuthnApiRedirect()");
                            }
                        }
                        if (result == null) {
                            if (redirectRequiredAndTryLookupAuthn && this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Checking if the adapter can perform the authentication without redirecting to the Authentication API Application.");
                            }
                            if ((adapterResponse = this.doLookupAuthn((IdpAuthenticationAdapterV2)idpAuthNAdapter, adapterKey, req, resp, params, stateParams, adapterLogoutRequired)) == null) {
                                this.log.error((Object)("Invalid response from adapter " + adapterInstanceId + ". Non-null AuthnAdapterResponse is expected."));
                            }
                            if (redirectRequiredAndTryLookupAuthn) {
                                if (adapterResponse == null || adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS) {
                                    throw new ProcessRuntimeException("When IN_PARAMETER_TRY_LOOKUP_AUTHN is set to true, AUTHN_STATUS must be SUCCESS, FAILURE, or INTERACTION_REQUIRED.");
                                }
                                if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.INTERACTION_REQUIRED) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)"Adapter returned INTERACTION_REQUIRED so redirecting to the Authentication API Application");
                                    }
                                    AuthnApiPolicyUtil.getDefault().redirectToEffectiveAuthnApiApplication(pluginKey, resp, stateParams, resumePath);
                                    result = this.makeInProgressResult();
                                    adapterResponse = null;
                                }
                            }
                        }
                    }
                    if (adapterResponse == null) break block51;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("adapterResponse=" + adapterResponse.getAuthnStatus()));
                    }
                    authnStatus = adapterResponse.getAuthnStatus();
                    if (((AuthnSourceKey)adapterKey).getType() != AuthnSourceKey.AuthnSourceType.LOCAL_IDENTITY && (auditor = AuthnProcessorResult.buildAuthenticationAttemptAuditor(adapterKey, adapterResponse)).getAuthenticationStatus() != null && !auditor.getAuthenticationStatus().equals((Object)AuthnAdapterResponse.AUTHN_STATUS.SUCCESS)) {
                        auditor.auditAuthenticationAttempt();
                    }
                    if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.SUCCESS) {
                        authnIdentifiers = adapterResponse.getAttributeMap();
                        break block51;
                    }
                    if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.ACTION) {
                        if (!this.isPolicyTreeAuthn(stateParams)) {
                            String error = "The adapter responded with the " + AuthnAdapterResponse.AUTHN_STATUS.ACTION + " status, but this adapter was not invoked through the policy tree. ";
                            this.log.error((Object)(error + " The " + AuthnAdapterResponse.AUTHN_STATUS.ACTION + " status is only allowed for use in the policy tree."));
                            throw new AuthnAdapterException(error);
                        }
                        authnIdentifiers = adapterResponse.getAttributeMap();
                        Object requestedAction = authnIdentifiers.get("policy.action");
                        if (requestedAction == null) {
                            String error = "Adapter result is set to " + AuthnAdapterResponse.AUTHN_STATUS.ACTION + ", but no value was set for the adapter attribute policy.action";
                            this.log.error((Object)error);
                            throw new AuthnAdapterException(error);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Requested action is " + LogGuard.encode(String.valueOf(requestedAction))));
                        }
                        break block51;
                    }
                    if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.FAILURE) {
                        this.log.info((Object)("authentication failed for " + LogGuard.encode(adapterResponse.getUsername()) + " ErrorCode: " + adapterResponse.getErrorCode() + " ErrorMessage: " + adapterResponse.getErrorMessage()));
                        break block51;
                    } else if (adapterResponse.getAuthnStatus() == AuthnAdapterResponse.AUTHN_STATUS.INTERACTION_REQUIRED && !redirectRequiredAndTryLookupAuthn) {
                        throw new ProcessRuntimeException("INTERACTION_REQUIRED should only be returned if IN_PARAMETER_TRY_LOOKUP_AUTHN is added to the in-parameters and set to true.");
                    }
                    break block51;
                }
                result = this.getResultFromSession(req, resp, stateParams, Collections.emptyMap(), (AuthnSourceKey)adapterKey, idpAuthNAdapter, null, authnPolicy, adapterLogoutRequired);
                if (result != null) break block51;
                if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                    AuthnApiSupport.getDefault().writeResumeResponse(req, resp, resumePath);
                    return this.makeInProgressResult();
                }
                try (TimerScope ignored = Meters.getTimerScope("adapter.lookup.authn", "adapter.id", ((AuthnSourceKey)adapterKey).getId());){
                    authnIdentifiers = idpAuthNAdapter.lookupAuthN(req, resp, entityId, authnPolicy, resumePath);
                }
                catch (IOException | AuthnAdapterException e) {
                    Meters.getCounter("adapter.lookup.authn.errors", "adapter.id", ((AuthnSourceKey)adapterKey).getId()).increment();
                    throw e;
                }
                auditor = AuthnProcessorResult.buildAuthenticationAttemptAuditor(adapterKey, resp, authnIdentifiers);
                if (auditor.getAuthenticationStatus() != null && !auditor.getAuthenticationStatus().equals((Object)AuthnAdapterResponse.AUTHN_STATUS.SUCCESS)) {
                    auditor.auditAuthenticationAttempt();
                }
            }
            catch (RuntimeException e) {
                throw this.makeAdapterEx(idpAuthNAdapter, e);
            }
        }
        if (result == null) {
            if (!Util.isEmpty(authnIdentifiers)) {
                if (authnIdentifiers.containsKey("policy.action") && !AuthnAdapterResponse.AUTHN_STATUS.ACTION.equals(authnStatus)) {
                    String error = "This adapter set a value for the policy.action attribute, but the adapter status was not set to " + AuthnAdapterResponse.AUTHN_STATUS.ACTION + ".";
                    this.log.error((Object)(error + "The policy.action attribute can only be used for " + AuthnAdapterResponse.AUTHN_STATUS.ACTION + " statuses."));
                    throw new AuthnAdapterException(error);
                }
                String sessionId = StateMgmtFactory.getLocalSessionId(req, resp);
                IdpHashableAuthnBean bean = new IdpHashableAuthnBean(authnIdentifiers, sessionId, (AuthnSourceKey)adapterKey, userId);
                if (this.getAuthenticationPolicyTreePostProcessor() != null) {
                    this.getAuthenticationPolicyTreePostProcessor().addPostProcessingTask(adapterInstanceId, stateParams, bean);
                }
                result = new AuthnProcessorResult(authnStatus, bean);
            } else {
                result = new AuthnProcessorResult(authnStatus);
            }
        }
        if (auditor != null) {
            result.setAuthenticationAttemptAuditor(auditor);
        }
        return result;
    }

    private void populateUserId(Map<String, Object> stateParams, Map<String, Object> params) {
        String userId = (String)stateParams.get("chainedUserId");
        if (userId == null) {
            String suggestedUserId = (String)stateParams.get("suid");
            if (suggestedUserId != null) {
                params.put("com.pingidentity.adapter.input.parameter.userid", suggestedUserId);
                params.put("com.pingidentity.adapter.input.parameter.userid.authenticated", false);
            }
        } else {
            params.put("com.pingidentity.adapter.input.parameter.userid", userId);
            boolean isUserAuthenticated = stateParams.get("adapterUsernameAuthenticated") == null ? false : (Boolean)stateParams.get("adapterUsernameAuthenticated");
            params.put("com.pingidentity.adapter.input.parameter.userid.authenticated", isUserAuthenticated);
        }
    }

    protected AuthnAdapterResponse doLookupAuthn(IdpAuthenticationAdapterV2 adapter, T adapterKey, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, Map<String, Object> stateParams, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException {
        TimerScope ignored = Meters.getTimerScope("adapter.lookup.authn", "adapter.id", ((AuthnSourceKey)adapterKey).getId());
        try {
            this.saveDefaultTemplateParamsToRequest(req, params);
            AuthnAdapterResponse authnAdapterResponse = adapter.lookupAuthN(req, resp, params);
            if (ignored != null) {
                ignored.close();
            }
            return authnAdapterResponse;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException | AuthnAdapterException e) {
                Meters.getCounter("adapter.lookup.authn.errors", "adapter.id", ((AuthnSourceKey)adapterKey).getId()).increment();
                throw e;
            }
        }
    }

    protected AuthnAdapterResponse tryLookupAuthnNoInteraction(IdpAuthenticationAdapterV2 adapter, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params, Map<String, Object> stateParams, boolean adapterLogoutRequired) throws IOException, AuthnAdapterException {
        AuthnAdapterResponse response = new AuthnAdapterResponse();
        response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        return response;
    }

    private AuthnProcessorResult makeInProgressResult() {
        return new AuthnProcessorResult(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
    }

    private boolean isPolicyTreeAuthn(Map<String, Object> stateParams) {
        PolicyTreeState policyTreeState = AuthnSourceSupportBase.getCurrentPolicyTreeState(stateParams);
        return policyTreeState != null && (policyTreeState.getCurrentNode() != null || policyTreeState.getCurrentNodePosition() != null || policyTreeState.isFragmentPolicyState());
    }

    protected Map<String, Object> getAdditionalParams(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams) {
        return Collections.emptyMap();
    }

    protected IdpAuthenticationAdapter getAuthnAdapter(String adapterInstanceId, String entityId) {
        return this.adapterManager.getIdpAuthnAdapterWithConnectionOverride(adapterInstanceId, entityId);
    }

    protected IdpAuthnAdapterInstance getAuthnAdapterInstance(String adapterInstanceId, String entityId) {
        return this.adapterManager.getIdpAuthnAdapterInstanceWithConnectionOverride(adapterInstanceId, entityId);
    }

    protected AuthnPluginKey getAuthnPluginKey(String adapterInstanceId, String entityId) {
        IdpAuthnAdapterInstance adapterInstance = this.getAuthnAdapterInstance(adapterInstanceId, entityId);
        AuthnPluginKey pluginKey = adapterInstance != null ? new AuthnPluginKey(AuthnPluginKey.Type.IDP_ADAPTER, adapterInstance.getId()) : new AuthnPluginKey(AuthnPluginKey.Type.IDP_ADAPTER, adapterInstanceId);
        return pluginKey;
    }

    protected AuthnProcessorResult getResultFromSession(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, Map<String, Object> inParams, AuthnSourceKey adapterKey, IdpAuthenticationAdapter adapter, String requestedUserId, AuthnPolicy authnPolicy, boolean logoutRequired) {
        IdpHashableAuthnBean session = IdpSessionRegistrySupport.getRegisteredAuthnSession(req, resp, stateParams, adapterKey, requestedUserId, null, authnPolicy);
        if (session != null) {
            boolean useSession = true;
            if (adapter instanceof SessionAwareAuthenticationAdapter && !(useSession = ((SessionAwareAuthenticationAdapter)adapter).checkUseAuthenticationSession(req, resp, inParams, session.getAuthenticationSession())) && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adapter " + adapterKey + " chose to ignore existing authentication session"));
            }
            if (useSession) {
                IdpAuditLogger.logAuthnSession("Using existing authentication session", IdpAuditLogger.AuthnSessionEvent.EVENT_AUTHN_SESSION_USE_EXISTING, session);
                if (logoutRequired && !session.isDoLogout()) {
                    session.setDoLogout(true);
                    IdpSessionRegistrySupport.registerAuthnBeansForSlo(req, resp, stateParams, new IdpHashableAuthnBean[]{session});
                }
                AuthnProcessorResult result = new AuthnProcessorResult(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS, session);
                result.setFromSession(true);
                return result;
            }
        }
        return null;
    }

    protected AuthnAdapterException makeAdapterEx(IdpAuthenticationAdapter adapter, RuntimeException e) {
        String adapterName = adapter.getClass().getSimpleName();
        return new AuthnAdapterException("Unexpected exception thrown from adapter " + adapterName, (Throwable)e);
    }

    public AbstractAdapterAuthnProcessor<T> withAuthenticationPolicyTreePostProcessor(AuthenticationPolicyTreePostProcessor postProcessor) {
        this.authenticationPolicyTreePostProcessor = postProcessor;
        return this;
    }

    public AuthenticationPolicyTreePostProcessor getAuthenticationPolicyTreePostProcessor() {
        return this.authenticationPolicyTreePostProcessor;
    }

    protected void saveDefaultTemplateParamsToRequest(HttpServletRequest req, Map<String, Object> inParams) {
        Map<String, Object> defaultParams = TemplateParamUtil.populateDefaultTemplateParams(inParams);
        req.setAttribute("defaultTemplateParams", defaultParams);
    }
}

