/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.servlet.QuietException;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnPluginKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ExceptionLoggingSupport;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class ApiRedirectWrapper<ResultType extends Serializable> {
    private static final Log log = LogFactory.getLog(ApiRedirectWrapper.class);
    private static final String KEY_STAGE_TARGET = "ARW.StageTarget";
    private static final String KEY_STAGE_EXCEPTION = "ARW.StageException";
    private static final String KEY_STAGE_RESULT = "ARW.StageResult";
    private final InMessageContext inMsgCtx;
    private final OutMessageContext outMsgCtx;
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private final String resumePath;
    private final Map<String, Object> stateParams;
    private final ResumeRequestFromAuthnResponseHandler reqHandler;
    private final WrapperParams wrapperParams;

    public ApiRedirectWrapper(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, ResumeRequestFromAuthnResponseHandler reqHandler) {
        this(req, resp, resumePath, stateParams, inMsgCtx, outMsgCtx, reqHandler, WrapperParams.forLookupAuthns(reqHandler));
    }

    public ApiRedirectWrapper(HttpServletRequest req, HttpServletResponse resp, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, ResumeRequestFromAuthnResponseHandler reqHandler, WrapperParams wrapperParams) {
        this.req = req;
        this.resp = resp;
        this.resumePath = resumePath;
        this.stateParams = stateParams;
        this.inMsgCtx = inMsgCtx;
        this.outMsgCtx = outMsgCtx;
        this.reqHandler = reqHandler;
        this.wrapperParams = wrapperParams;
    }

    public ResultType wrap(StageExecutor<ResultType> treeExecutor) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException, AuthorizationRequestException {
        try {
            boolean stageComplete;
            this.stateParams.put("authnPolicyInitialResumeUrl", this.resumePath);
            this.stateParams.put("OriginalResumeHandlerClassName", this.reqHandler.getClass().getName());
            StageTarget stageTarget = this.getStageTarget(this.stateParams);
            boolean bl = stageComplete = stageTarget != null;
            if (stageComplete) {
                Exception e;
                if (stageTarget.getType() == StageTargetType.FRONT_CHANNEL && AuthnApiSupport.getDefault().isApiRequest(this.req)) {
                    this.sendApiResumeResponse(this.req, this.resp, this.resumePath);
                    return null;
                }
                if (stageTarget.getType() == StageTargetType.API && !AuthnApiSupport.getDefault().isApiRequest(this.req)) {
                    this.redirectAuthnApiApplication(this.resp, stageTarget);
                    return null;
                }
                AuthnPluginKey authnPlugin = AuthnPolicyUtil.getDefault().getCurrentAuthnPlugin(this.req, this.stateParams);
                if (authnPlugin != null) {
                    AuthnPolicyUtil.getDefault().setCurrentAuthnPlugin(this.req, this.stateParams, authnPlugin);
                }
                if ((e = this.getStageException(this.stateParams)) != null) {
                    this.rethrowException(e);
                }
                return this.getStageResult(this.stateParams);
            }
            ResultType result = treeExecutor.executeStage();
            if (!this.resp.isCommitted() && this.wrapperParams.isLastApiStage()) {
                StageTarget authnApiAppTarget;
                if (AuthnApiSupport.getDefault().isApiRequest(this.req) && !this.reqHandler.isAuthnApiHandlesResult(this.req, this.stateParams)) {
                    this.saveStageResult(this.stateParams, StageTarget.frontChannel(), result);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Stage complete, sending API RESUME response");
                    }
                    this.sendApiResumeResponse(this.req, this.resp, this.resumePath);
                    return null;
                }
                if (AuthnApiSupport.getDefault().isApiRequest(this.req) && this.reqHandler.isAuthnApiHandlesResult(this.req, this.stateParams)) {
                    AuthnApiApplication authnApiAppOverride = this.reqHandler.getAuthnApiAppOverride(this.req, this.stateParams);
                    AuthnApiApplication lastAuthnApiApplication = AuthnApiPolicyUtil.getDefault().getLastAuthnApiApplication(this.stateParams);
                    if (authnApiAppOverride != null && lastAuthnApiApplication != null && !authnApiAppOverride.getId().equals(lastAuthnApiApplication.getId())) {
                        this.saveStageResult(this.stateParams, StageTarget.authnApiApp(authnApiAppOverride.getId()), result);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Stage complete, sending API RESUME response in order to switch authn API application");
                        }
                        this.sendApiResumeResponse(this.req, this.resp, this.resumePath);
                        return null;
                    }
                } else if (!AuthnApiSupport.getDefault().isApiRequest(this.req) && this.reqHandler.isAuthnApiHandlesResult(this.req, this.stateParams) && (authnApiAppTarget = this.getAuthnApiAppTarget(this.req, this.stateParams, this.reqHandler)) != null) {
                    this.saveStageResult(this.stateParams, authnApiAppTarget, result);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Stage complete, redirecting to authn API application '" + authnApiAppTarget.getAuthnApiApplication() + "'"));
                    }
                    this.redirectAuthnApiApplication(this.resp, authnApiAppTarget);
                    return null;
                }
            }
            return result;
        }
        catch (IOException | RuntimeException | AuthorizationRequestException | AuthnAdapterException | AuthorizationException | AuthnProcessorException e) {
            StageTarget authnApiAppTarget;
            if (AuthnApiSupport.getDefault().isApiRequest(this.req) && !this.isAuthnApiHandlesException(this.reqHandler, this.req, this.stateParams, this.inMsgCtx, this.outMsgCtx)) {
                this.logExceptionAndSaveToStateParams((Exception)e, this.stateParams, StageTarget.frontChannel());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error occurred during API request, sending RESUME response to API client");
                }
                this.sendApiResumeResponse(this.req, this.resp, this.resumePath);
                return null;
            }
            if (AuthnApiSupport.getDefault().isApiRequest(this.req) && this.isAuthnApiHandlesException(this.reqHandler, this.req, this.stateParams, this.inMsgCtx, this.outMsgCtx)) {
                AuthnApiApplication authnApiAppOverride = this.reqHandler.getAuthnApiAppOverride(this.req, this.stateParams);
                AuthnApiApplication lastAuthnApiApplication = AuthnApiPolicyUtil.getDefault().getLastAuthnApiApplication(this.stateParams);
                if (authnApiAppOverride != null && lastAuthnApiApplication != null && !authnApiAppOverride.getId().equals(lastAuthnApiApplication.getId())) {
                    this.logExceptionAndSaveToStateParams((Exception)e, this.stateParams, StageTarget.authnApiApp(authnApiAppOverride.getId()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Error occurred during API request, sending RESUME response to API client in order to switch authn API application");
                    }
                    this.sendApiResumeResponse(this.req, this.resp, this.resumePath);
                    return null;
                }
            } else if (!AuthnApiSupport.getDefault().isApiRequest(this.req) && this.isAuthnApiHandlesException(this.reqHandler, this.req, this.stateParams, this.inMsgCtx, this.outMsgCtx) && (authnApiAppTarget = this.getAuthnApiAppTarget(this.req, this.stateParams, this.reqHandler)) != null) {
                this.logExceptionAndSaveToStateParams((Exception)e, this.stateParams, authnApiAppTarget);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error occurred, redirecting to authn API application '" + authnApiAppTarget.getAuthnApiApplication() + "'"));
                }
                this.redirectAuthnApiApplication(this.resp, authnApiAppTarget);
                return null;
            }
            throw e;
        }
    }

    private StageTarget getAuthnApiAppTarget(HttpServletRequest req, Map<String, Object> stateParams, ResumeRequestFromAuthnResponseHandler handler) {
        AuthnApiApplication authnApiApp = handler.getAuthnApiAppOverride(req, stateParams);
        if (authnApiApp == null && (authnApiApp = AuthnApiPolicyUtil.getDefault().getEffectiveAuthnApiApplication(stateParams)) == null) {
            return null;
        }
        return StageTarget.authnApiApp(authnApiApp.getId());
    }

    private boolean isAuthnApiHandlesException(ResumeRequestFromAuthnResponseHandler handler, HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        if (handler == null) {
            return true;
        }
        return handler.isAuthnApiHandlesException(req, stateParams, inMsgCtx, outMsgCtx);
    }

    private void redirectAuthnApiApplication(HttpServletResponse resp, StageTarget target) throws IOException {
        this.redirectAuthnApiApplication(resp, target.getAuthnApiApplication());
    }

    private void redirectAuthnApiApplication(HttpServletResponse resp, AuthnApiApplication authnApiApplication) throws IOException {
        StateSupport stateSupport = new StateSupport(MetaDataFactory.getLocalMetaData());
        AuthnApiPolicyUtil.getDefault().redirectAuthnApiApplication(resp, stateSupport.getContextId(this.resumePath), authnApiApplication);
    }

    private void logExceptionAndSaveToStateParams(Exception e, Map<String, Object> stateParams, StageTarget target) {
        if (!(e instanceof QuietException)) {
            ExceptionLoggingSupport.logException(e);
        }
        this.saveStageException(stateParams, target, e);
    }

    private void rethrowException(Exception e) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException, AuthorizationRequestException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rethrowing exception that occurred during previous request: " + ExceptionUtil.toStringWithCauses(e)));
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof AuthnAdapterException) {
            throw (AuthnAdapterException)((Object)e);
        }
        if (e instanceof AuthnProcessorException) {
            throw (AuthnProcessorException)e;
        }
        if (e instanceof AuthorizationException) {
            throw (AuthorizationException)e;
        }
        if (e instanceof AuthorizationRequestException) {
            throw (AuthorizationRequestException)e;
        }
        throw new ProcessRuntimeException("Unexpected exception type found in state params", e);
    }

    private void sendApiResumeResponse(HttpServletRequest req, HttpServletResponse resp, String resumePath) throws IOException {
        AuthnApiSupport.getDefault().writeResumeResponse(req, resp, resumePath);
    }

    private StageTarget getStageTarget(Map<String, Object> stateParams) {
        return (StageTarget)stateParams.get(this.makeStateKey(KEY_STAGE_TARGET));
    }

    private ResultType getStageResult(Map<String, Object> stateParams) {
        return (ResultType)((Serializable)stateParams.get(this.makeStateKey(KEY_STAGE_RESULT)));
    }

    private void saveStageResult(Map<String, Object> stateParams, StageTarget target, ResultType result) {
        stateParams.put(this.makeStateKey(KEY_STAGE_TARGET), target);
        stateParams.put(this.makeStateKey(KEY_STAGE_RESULT), result);
    }

    private Exception getStageException(Map<String, Object> stateParams) {
        return (Exception)stateParams.get(this.makeStateKey(KEY_STAGE_EXCEPTION));
    }

    private void saveStageException(Map<String, Object> stateParams, StageTarget target, Exception e) {
        e = (Exception)SerializationUtils.clone((Serializable)e);
        this.clearStackTraces(e);
        stateParams.put(this.makeStateKey(KEY_STAGE_TARGET), target);
        stateParams.put(this.makeStateKey(KEY_STAGE_EXCEPTION), e);
    }

    private String makeStateKey(String key) {
        return this.wrapperParams.getStatePrefix() + "." + key;
    }

    private void clearStackTraces(Throwable t) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            cause.setStackTrace(new StackTraceElement[0]);
        }
        for (Throwable suppressed : t.getSuppressed()) {
            this.clearStackTraces(suppressed);
        }
    }

    public static class WrapperParams {
        private final boolean lastApiStage;
        private final String statePrefix;

        public WrapperParams(boolean lastApiStage, String statePrefix) {
            this.lastApiStage = lastApiStage;
            this.statePrefix = statePrefix;
        }

        public static WrapperParams forLookupAuthns(ResumeRequestFromAuthnResponseHandler handler) {
            return new WrapperParams(!handler.hasAdditionalApiCapableStages(), "LookupAuthns");
        }

        public boolean isLastApiStage() {
            return this.lastApiStage;
        }

        public String getStatePrefix() {
            return this.statePrefix;
        }
    }

    @FunctionalInterface
    public static interface StageExecutor<ResultType extends Serializable> {
        public ResultType executeStage() throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException, AuthorizationRequestException;
    }

    private static class StageTarget
    implements Serializable {
        private final String authnApiAppId;
        private final StageTargetType type;

        public static StageTarget frontChannel() {
            return new StageTarget(StageTargetType.FRONT_CHANNEL);
        }

        public static StageTarget authnApiApp(String authnApiAppId) {
            return new StageTarget(StageTargetType.API, authnApiAppId);
        }

        public StageTarget(StageTargetType type) {
            this(type, null);
        }

        public StageTarget(StageTargetType type, String authnApiAppId) {
            this.type = type;
            this.authnApiAppId = authnApiAppId;
        }

        public AuthnApiApplication getAuthnApiApplication() {
            if (this.authnApiAppId == null) {
                return null;
            }
            AuthnApiApplication authnApiApp = MgmtFactory.getAuthnApiManager().getApiApplication(this.authnApiAppId);
            if (authnApiApp == null) {
                throw new ProcessRuntimeException("Authn API application with ID " + this.authnApiAppId + " not found");
            }
            return authnApiApp;
        }

        public StageTargetType getType() {
            return this.type;
        }
    }

    private static enum StageTargetType {
        FRONT_CHANNEL,
        API;

    }
}

