/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import java.io.Serializable;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class AuthnPluginKey
implements Serializable {
    public static final AuthnPluginKey PF_CORE = new AuthnPluginKey(Type.IDP_ADAPTER, "pf.core");
    public static final String PF_CORE_CLASSNAME = "org.sourceid.websso.servlet.EnforcerServletBase";
    private final Type type;
    private final String id;

    public AuthnPluginKey(Type type, String id) {
        this.type = type;
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String pluginType;
        switch (this.type) {
            case IDP_ADAPTER: {
                pluginType = "IdP adapter";
                break;
            }
            case SELECTOR: {
                pluginType = "selector";
                break;
            }
            default: {
                throw new ProcessRuntimeException("Unexpected plugin type " + this.type);
            }
        }
        return this.id + "(" + pluginType + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthnPluginKey that = (AuthnPluginKey)o;
        if (this.type != that.type) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public static enum Type {
        IDP_ADAPTER,
        SELECTOR;

    }
}

