/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.TrackedHttpParamsSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.authn.AuthnPluginKey;

public class AuthnPolicyUtil {
    public static final String KEY_CURRENT_AUTHN_PLUGIN = "APU.CurrentAuthnPlugin";
    public static final String KEY_CURRENT_AUTHN_PLUGIN_ID = "APU.CurrentAuthnPluginId";
    private static final AuthnPolicyUtil instance = new AuthnPolicyUtil();

    public static AuthnPolicyUtil getDefault() {
        return instance;
    }

    public void setCurrentAuthnPlugin(HttpServletRequest request, Map<String, Object> stateParams, AuthnPluginKey plugin) {
        request.setAttribute(KEY_CURRENT_AUTHN_PLUGIN, (Object)plugin);
        stateParams.put(KEY_CURRENT_AUTHN_PLUGIN, plugin);
        if (plugin != null) {
            stateParams.put(KEY_CURRENT_AUTHN_PLUGIN_ID, plugin.getId());
        }
    }

    public void clearCurrentAuthnPlugin(HttpServletRequest request, Map<String, Object> stateParams) {
        request.removeAttribute(KEY_CURRENT_AUTHN_PLUGIN);
        stateParams.remove(KEY_CURRENT_AUTHN_PLUGIN);
    }

    public AuthnPluginKey getCurrentAuthnPlugin(HttpServletRequest request, Map<String, Object> stateParams) {
        AuthnPluginKey plugin;
        if (request != null && (plugin = (AuthnPluginKey)request.getAttribute(KEY_CURRENT_AUTHN_PLUGIN)) != null) {
            return plugin;
        }
        if (stateParams == null) {
            return null;
        }
        return (AuthnPluginKey)stateParams.get(KEY_CURRENT_AUTHN_PLUGIN);
    }

    public String getCurrentAdapterId(HttpServletRequest request, Map<String, Object> stateParams) {
        AuthnPluginKey plugin = this.getCurrentAuthnPlugin(request, stateParams);
        if (plugin == null) {
            return null;
        }
        if (plugin.getType() != AuthnPluginKey.Type.IDP_ADAPTER) {
            return null;
        }
        return plugin.getId();
    }

    public String getNonConnBasedAdapterId(HttpServletRequest request, Map<String, Object> stateParams) {
        String currentAdapterId = this.getCurrentAdapterId(request, stateParams);
        if (currentAdapterId == null) {
            return null;
        }
        IdpAuthnAdapterInstance adapterInstance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(currentAdapterId);
        if (adapterInstance == null) {
            return currentAdapterId;
        }
        if (adapterInstance.isConnectionBasedPlugin()) {
            return adapterInstance.getParentId();
        }
        return adapterInstance.getId();
    }

    public String generateId() {
        return IDGenerator.rndAlphaNumeric(25);
    }

    public static void addTrackedParamsToAttributeMappingSource(Map<String, Collection<String>> trackedParams, HashMap<String, AttributeMap> sourceAttrs) {
        TrackedHttpParamsSettings trackedParamsSettings = MgmtFactory.getTrackedHttpParamManager().getTrackedParamSettings();
        if (trackedParamsSettings.isTrackingEnabled() && trackedParams != null && !trackedParams.isEmpty()) {
            AttributeMap map = new AttributeMap();
            trackedParams.forEach((key, value) -> {
                AttributeValue attrValue = new AttributeValue(value);
                attrValue.setMasked(MgmtFactory.getTrackedHttpParamManager().isMaskTrackedParams());
                map.put(key, attrValue);
            });
            map.setMaskOgnlValues(MgmtFactory.getTrackedHttpParamManager().isMaskTrackedParams());
            sourceAttrs.put("trackedparams", map);
        }
    }

    public static void addExtendedPropertiesToAttributeMappingSource(Map<String, Object> extendedProperties, Map<String, AttributeMap> sourceAttrs) {
        AttributeMap attrMap = new AttributeMap();
        for (Map.Entry<String, Object> entry : extendedProperties.entrySet()) {
            Object value = entry.getValue();
            AttributeValue attrValue = value instanceof AttributeValue ? new AttributeValue((AttributeValue)value) : (value instanceof String ? new AttributeValue((String)value) : new AttributeValue((Collection)value));
            attrMap.put("extproperties." + entry.getKey(), attrValue);
        }
        sourceAttrs.putIfAbsent(null, new AttributeMap());
        sourceAttrs.get(null).putAll((Map)attrMap);
    }
}

