/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.sdk.AuthnAdapterResponse;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AuthnProcessorResult {
    private IdpHashableAuthnBean authnBean;
    private OutMessageContext ssoReqMsgCtx;
    private AuthnAdapterResponse.AUTHN_STATUS authnStatus = null;
    private AuthenticationAttemptAuditor authenticationAttemptAuditor;
    private boolean fromSession = false;

    public AuthnProcessorResult() {
    }

    public AuthnProcessorResult(AuthnAdapterResponse.AUTHN_STATUS authnStatus) {
        this.authnStatus = authnStatus;
    }

    public AuthnProcessorResult(AuthnAdapterResponse.AUTHN_STATUS authnStatus, IdpHashableAuthnBean authnBean) {
        this.authnStatus = authnStatus;
        this.authnBean = authnBean;
    }

    public AuthnProcessorResult(IdpHashableAuthnBean authnBean, OutMessageContext ssoReqMsgCtx) {
        this.authnBean = authnBean;
        this.ssoReqMsgCtx = ssoReqMsgCtx;
    }

    public IdpHashableAuthnBean getAuthnBean() {
        return this.authnBean;
    }

    public void setAuthnBean(IdpHashableAuthnBean authnBean) {
        this.authnBean = authnBean;
    }

    public OutMessageContext getSsoReqMsgCtx() {
        return this.ssoReqMsgCtx;
    }

    public void setSsoReqMsgCtx(OutMessageContext ssoReqMsgCtx) {
        this.ssoReqMsgCtx = ssoReqMsgCtx;
    }

    public AuthnAdapterResponse.AUTHN_STATUS getAuthnStatus() {
        return this.authnStatus;
    }

    public boolean isFromSession() {
        return this.fromSession;
    }

    public void setFromSession(boolean fromSession) {
        this.fromSession = fromSession;
    }

    public AuthnAdapterResponse.AUTHN_STATUS getAuditorAuthenticationStatus() {
        return this.authenticationAttemptAuditor == null ? null : this.authenticationAttemptAuditor.getAuthenticationStatus();
    }

    public void setAuthenticationAttemptAuditor(AuthenticationAttemptAuditor authenticationAttemptAuditor) {
        this.authenticationAttemptAuditor = authenticationAttemptAuditor;
    }

    public void auditFailedAuthenticationAttempt(String errorMessage) {
        if (this.authenticationAttemptAuditor != null && this.authenticationAttemptAuditor.getAuthenticationStatus() != null) {
            this.authenticationAttemptAuditor.auditAuthenticationAttempt(errorMessage);
        }
    }

    public void auditAuthenticationAttempt() {
        if (this.authenticationAttemptAuditor != null && this.authenticationAttemptAuditor.getAuthenticationStatus() != null) {
            this.authenticationAttemptAuditor.auditAuthenticationAttempt();
        }
    }

    public static AuthenticationAttemptAuditor buildAuthenticationAttemptAuditor(AuthnSourceKey authnSourceKey, AuthnAdapterResponse adapterResponse) {
        AuthenticationAttemptAuditor auditor = new AuthenticationAttemptAuditor(authnSourceKey);
        auditor.collectAuditingInformation(adapterResponse);
        return auditor;
    }

    public static AuthenticationAttemptAuditor buildAuthenticationAttemptAuditor(AuthnSourceKey authnSourceKey, HttpServletResponse resp, Map<String, Object> authnIdentifiers) {
        AuthenticationAttemptAuditor auditor = new AuthenticationAttemptAuditor(authnSourceKey);
        auditor.collectAuditingInformation(resp, authnIdentifiers);
        return auditor;
    }

    public static class AuthenticationAttemptAuditor {
        private AuthnSourceKey authenticationSourceKey;
        private String authenticatedUserName = null;
        private String authenticationErrorMessage = null;
        private AuthnAdapterResponse.AUTHN_STATUS authenticationStatus = null;

        AuthenticationAttemptAuditor(AuthnSourceKey authenticationSourceKey) {
            this.authenticationSourceKey = authenticationSourceKey;
        }

        public AuthnAdapterResponse.AUTHN_STATUS getAuthenticationStatus() {
            return this.authenticationStatus;
        }

        void collectAuditingInformation(AuthnAdapterResponse adapterResponse) {
            this.authenticatedUserName = LogGuard.encode(StringUtils.isNotBlank((String)adapterResponse.getUsername()) ? adapterResponse.getUsername() : AuthenticationAttemptAuditor.buildUsernameFromUniqueKeyFields(this.authenticationSourceKey, adapterResponse.getAttributeMap()));
            this.authenticationStatus = adapterResponse.getAuthnStatus();
            if (this.authenticationStatus == AuthnAdapterResponse.AUTHN_STATUS.FAILURE || this.authenticationStatus == AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS) {
                this.authenticationErrorMessage = adapterResponse.getErrorMessage();
            }
        }

        void collectAuditingInformation(HttpServletResponse resp, Map<String, Object> authnIdentifiers) {
            if (!Util.isEmpty(authnIdentifiers)) {
                this.authenticatedUserName = AuthenticationAttemptAuditor.buildUsernameFromUniqueKeyFields(this.authenticationSourceKey, authnIdentifiers);
                this.authenticationStatus = AuthnAdapterResponse.AUTHN_STATUS.SUCCESS;
            } else {
                this.authenticationStatus = !resp.isCommitted() ? AuthnAdapterResponse.AUTHN_STATUS.FAILURE : AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS;
            }
        }

        void auditAuthenticationAttempt() {
            AuditLogger.setAuthnSourceId(this.authenticationSourceKey);
            if (this.authenticatedUserName != null) {
                IdpAuditLogger.setUserName(this.authenticatedUserName);
            }
            if (this.authenticationErrorMessage != null) {
                AuditLogger.put(AuditLogger.MDC_KEY.DESCRIPTION.toString(), this.authenticationErrorMessage);
            }
            IdpAuditLogger.logAuthnAttempt("Attempted authentication with adapter", this.authenticationStatus);
            IdpAuditLogger.cleanupAuthnAttempt();
        }

        void auditAuthenticationAttempt(String authenticationErrorMessage) {
            this.authenticationErrorMessage = authenticationErrorMessage;
            this.authenticationStatus = AuthnAdapterResponse.AUTHN_STATUS.FAILURE;
            this.auditAuthenticationAttempt();
        }

        protected static String buildUsernameFromUniqueKeyFields(AuthnSourceKey authnSourceKey, Map<String, Object> authenticationIdentifiers) {
            String userName = null;
            IdpAuthnAdapterInstance instance = MgmtFactory.getAdapterManager().getIdpAuthnAdapterInstance(authnSourceKey.getId());
            List<String> fields = instance.getUniqueKeyFields();
            if (authenticationIdentifiers != null && !authenticationIdentifiers.isEmpty()) {
                userName = fields.stream().filter(authenticationIdentifiers::containsKey).map(f -> String.valueOf(authenticationIdentifiers.get(f))).collect(Collectors.joining(","));
            }
            return userName;
        }
    }
}

