/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.authn;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;

public class CookieDeserializer
extends StdDeserializer<Cookie> {
    private static final String NAME_FIELD = "name";
    private static final String VALUE_FIELD = "value";
    private static final String COMMENT_FIELD = "comment";
    private static final String DOMAIN_FIELD = "domain";
    private static final String HTTP_ONLY_FIELD = "httpOnly";
    private static final String MAX_AGE_FIELD = "maxAge";
    private static final String PATH_FIELD = "path";
    private static final String SECURE_FIELD = "secure";
    private static final String VERSION_FIELD = "version";

    public CookieDeserializer() {
        this(null);
    }

    public CookieDeserializer(Class<Cookie> cls) {
        super(cls);
    }

    public Cookie deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Cookie cookie = new Cookie(node.get(NAME_FIELD).asText(), node.get(VALUE_FIELD).asText());
        cookie.setComment(node.get(COMMENT_FIELD).asText());
        cookie.setDomain(node.get(DOMAIN_FIELD).asText());
        cookie.setHttpOnly(node.get(HTTP_ONLY_FIELD).asBoolean());
        cookie.setMaxAge(node.get(MAX_AGE_FIELD).asInt());
        cookie.setPath(node.get(PATH_FIELD).asText());
        cookie.setSecure(node.get(SECURE_FIELD).asBoolean());
        cookie.setVersion(node.get(VERSION_FIELD).asInt());
        return cookie;
    }

    public static Map<String, Object> toCookieObjectMap(Cookie cookie) {
        HashMap<String, Object> cookieMap = new HashMap<String, Object>();
        cookieMap.put(NAME_FIELD, cookie.getName());
        cookieMap.put(VALUE_FIELD, cookie.getValue());
        cookieMap.put(COMMENT_FIELD, cookie.getComment());
        cookieMap.put(DOMAIN_FIELD, cookie.getDomain());
        cookieMap.put(MAX_AGE_FIELD, cookie.getMaxAge());
        cookieMap.put(PATH_FIELD, cookie.getPath());
        cookieMap.put(SECURE_FIELD, cookie.getSecure());
        cookieMap.put(HTTP_ONLY_FIELD, cookie.isHttpOnly());
        cookieMap.put(VERSION_FIELD, cookie.getVersion());
        return cookieMap;
    }
}

