/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.bindings;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.net.URL;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.auth.Authenticator;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.soap11.SoapClientException;
import org.sourceid.common.soap.soap11.SoapEndpointUtility;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.config.SoapAuthStore;
import org.sourceid.config.SoapAuthStoreFactory;
import org.sourceid.protocol.soap11.xml.Body;
import org.sourceid.protocol.soap11.xml.Envelope;
import org.sourceid.protocol.soap11.xml.EnvelopeDocument;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.SoapBindingWrappedException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class SoapBase
implements Binding {
    private static final ConfigStore config = ConfigStoreFarm.getConfig(SoapBase.class);
    private final SoapAuthStore soapAuthStore = SoapAuthStoreFactory.getSoapAuthStore();
    protected final Log log = LogFactory.getLog(this.getClass());
    private final SignatureEngine signatureSvc = GlobalRegistry.getService(SignatureEngine.class);

    protected abstract XmlObject sendRequest(String var1, URL var2, OutMessageContext var3, ConnectionBase var4) throws BindingException, IOException, SoapClientException, RedirectException;

    protected abstract String identifyPartner(HttpServletRequest var1, HttpServletResponse var2, XmlObject var3) throws LoginException, InvalidRequestException, XmlException;

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException {
        XmlObject response;
        URL endpoint = new URL(msgCtx.getEndpoint());
        String entityId = msgCtx.getEntityId();
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtx);
        String encodedIdForSoapStore = connection.getEncodedEntityId();
        SoapAuthInfo outgoing = this.soapAuthStore.getOutgoing(encodedIdForSoapStore);
        SignaturePolicy policy = msgCtx.getSignaturePolicy();
        if (policy == SignaturePolicy.SIGN || outgoing.isHasNoneEntry() && policy != SignaturePolicy.DO_NOT_SIGN) {
            this.signatureSvc.signXml(msgCtx);
        }
        try {
            response = this.sendRequest(encodedIdForSoapStore, endpoint, msgCtx, connection);
        }
        catch (SoapClientException e) {
            String message = e.getMessage();
            String msg = "Unable to complete SOAP request to entity " + entityId + " at " + endpoint + " (" + message + ")";
            throw new BindingException(msg, e);
        }
        InMessageContext msgCtxIn = new InMessageContext(msgCtx.getRoleType());
        msgCtxIn.setOriginalRequestCtx(msgCtx);
        msgCtxIn.setEntityId(entityId);
        msgCtxIn.setVirtualServerId(msgCtx.getVirtualServerId());
        msgCtxIn.setBinding(msgCtx.getBinding());
        try {
            XmlObject doc = XmlBeansUtil.wrapTypeInDocument(response);
            msgCtxIn.setXmlObject(doc);
            boolean signatureRequired = false;
            if (config.getBooleanValue("ExpectSignedResponseFromServerViaHTTP", true)) {
                boolean secure = "https".equals(endpoint.getProtocol());
                if (this.log.isDebugEnabled()) {
                    if (secure) {
                        StringBuffer msg = new StringBuffer("Secure SOAP request to ").append(entityId).append(" (");
                        msg.append(endpoint).append(") so the server was authenticated at the transport level.");
                        msg.append("  Therefore message level authentication is not required");
                        this.log.debug((Object)msg);
                    } else {
                        StringBuffer msg = new StringBuffer("SOAP request to ").append(entityId).append(" not over https (");
                        msg.append(endpoint).append(") so the server was not authenticated at the transport level.");
                        msg.append(" Therefore message level authentication is required");
                        this.log.debug((Object)msg);
                    }
                }
                signatureRequired = !secure;
            }
            this.signatureSvc.verifyXmlSignature(msgCtxIn, signatureRequired);
            return msgCtxIn;
        }
        catch (XmlException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException {
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtx);
        boolean signMsg = this.shouldSignResponse(connection, msgCtx, request);
        if (signMsg) {
            this.signatureSvc.signXml(msgCtx);
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType(this.getResponseContentType());
        EnvelopeDocument soapEnvelopeDoc = EnvelopeDocument.Factory.newInstance();
        Envelope envelope = soapEnvelopeDoc.addNewEnvelope();
        this.setResponseBody(envelope, msgCtx);
        this.setHeadersOnResponse(envelope, msgCtx);
        XmlBeansUtil.save((XmlObject)envelope, response.getWriter());
    }

    protected String getResponseContentType() {
        return "text/xml";
    }

    protected void setHeadersOnResponse(Envelope envelope, OutMessageContext msgCtx) {
    }

    void setResponseBody(Envelope envelope, OutMessageContext msgCtx) {
        Body body = envelope.addNewBody();
        XmlObject xmlObject = msgCtx.getXmlObject();
        body.set(xmlObject);
    }

    protected boolean shouldSignResponse(ConnectionBase connection, OutMessageContext msgCtx, HttpServletRequest request) {
        if (msgCtx.getSignaturePolicy() == SignaturePolicy.SIGN) {
            return true;
        }
        boolean signMsg = false;
        if (config.getBooleanValue("SignResponseAsServerViaHTTP", true) && !request.isSecure()) {
            if (!request.isSecure()) {
                this.log.debug((Object)"Request was _not_ made over a secure channel so the server has not authenticated itself to the client at the transport layer (HTTP was used rather than HTTPS).  Therefore the server will use message level authentication and (attempt to) sign the XML message to authenticate itself to the client.");
            }
            signMsg = true;
        }
        return signMsg;
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException {
        try {
            XmlObject xmlObjectType = SoapEndpointUtility.getProtocolMessage(request);
            XmlObject xmlObjectDoc = XmlBeansUtil.wrapTypeInDocument(xmlObjectType);
            InMessageContext msgCtxIn = new InMessageContext(partnerRole);
            msgCtxIn.setXmlObject(xmlObjectDoc);
            String entityId = this.identifyPartner(request, response, xmlObjectType);
            msgCtxIn.setEntityId(entityId);
            String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)msgCtxIn, request).getVirtualEntityId(DomainMode.RUNTIME);
            msgCtxIn.setVirtualServerId(virtualServerId);
            ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(msgCtxIn);
            boolean signatureRequired = this.doInboudSoapAuth(request, response, msgCtxIn, connection);
            this.signatureSvc.verifyXmlSignature(msgCtxIn, signatureRequired);
            return msgCtxIn;
        }
        catch (LoginException e) {
            throw new SoapBindingWrappedException(e);
        }
        catch (InvalidRequestException e) {
            throw new SoapBindingWrappedException(e, SoapEndpointUtility.CLIENT_FAULT_CODE);
        }
        catch (XmlException e) {
            throw new BindingException("Unable to handle SOAP request due to XML problem.", e);
        }
    }

    protected boolean doInboudSoapAuth(HttpServletRequest request, HttpServletResponse response, InMessageContext inMsgCtx, ConnectionBase connection) throws LoginException {
        Authenticator.AuthnInfo authnInfo = this.getAuthnInfo(request, response);
        return !this.checkAuthnInfo(authnInfo, connection.getEncodedEntityId(), request.isSecure(), inMsgCtx);
    }

    private Authenticator.AuthnInfo getAuthnInfo(HttpServletRequest request, HttpServletResponse response) throws LoginException {
        return Authenticator.authn(request, response);
    }

    protected boolean checkAuthnInfo(Authenticator.AuthnInfo authnInfo, String encodedId, boolean isRequestSecure, InMessageContext inMsgCtx) throws LoginException {
        return Authenticator.checkAuthnInfo(authnInfo, encodedId, isRequestSecure);
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        if (e instanceof SoapBindingWrappedException) {
            SoapBindingWrappedException wrappedEx = (SoapBindingWrappedException)e;
            Throwable cause = wrappedEx.getCause();
            if (cause instanceof LoginException) {
                resp.sendError(401, "\"" + cause.getMessage() + "\"");
            } else if (cause instanceof InvalidRequestException) {
                SoapEndpointUtility.writeSoapFault(resp, wrappedEx.getFaultCode(), "Invalid Request");
            } else {
                SoapEndpointUtility.writeSoapFault(resp, wrappedEx.getFaultCode(), cause.getMessage());
            }
        } else {
            SoapEndpointUtility.writeSoapFault(resp, SoapEndpointUtility.SERVER_FAULT_CODE, e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isBackChannel() {
        return true;
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }
}

