/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.commondomain;

import com.pingidentity.common.util.B64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;

public class CommonDomainCookie {
    private static final String SEPARATORS = " ";
    private static final String CD_COOKIE_NAME = "_saml_idp";
    private static final Log log = LogFactory.getLog(CommonDomainCookie.class);

    public static void setCommonDomainCookie(HttpServletRequest request, HttpServletResponse response, String b64IdpEntityId, String commonDomain, int cookieLifeDays) {
        String commonCookieValue = CommonDomainCookie.getCommonDomainCookie(request);
        if (commonCookieValue != null) {
            try {
                commonCookieValue = URLDecoder.decode(commonCookieValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        }
        List<String> idpList = CommonDomainCookie.decodeCommonDomainCookie(commonCookieValue);
        String idpEntityId = B64.decodeToString((String)b64IdpEntityId);
        CommonDomainCookie.putSelfLast(idpList, idpEntityId);
        String cdCookieValue = CommonDomainCookie.encodeCommonDomainCookie(idpList);
        Cookie cdCookie = null;
        try {
            cdCookie = new Cookie(CD_COOKIE_NAME, URLEncoder.encode(cdCookieValue, "UTF-8"));
            cdCookie.setDomain(commonDomain);
            cdCookie.setPath("/");
            int maxAge = cookieLifeDays * 24 * 3600;
            cdCookie.setMaxAge(maxAge);
            cdCookie.setHttpOnly(true);
            cdCookie.setSecure(true);
            response.addCookie(cdCookie);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
    }

    static void putSelfLast(List<String> idpList, String idpEntityId) {
        idpList.remove(idpEntityId);
        idpList.add(idpEntityId);
    }

    public static String getCommonDomainCookie(HttpServletRequest request) {
        String commonCookieValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!CD_COOKIE_NAME.equals(cookie.getName())) continue;
                commonCookieValue = cookie.getValue();
                break;
            }
        }
        return commonCookieValue;
    }

    public static List<String> decodeCommonDomainCookie(String urlEncodedCookieValue) {
        ArrayList<String> idpList = new ArrayList<String>();
        if (!StringUtils.isBlank((String)urlEncodedCookieValue)) {
            String cookieValue = urlEncodedCookieValue;
            int count = 0;
            while (cookieValue.contains("%") && count++ < 10) {
                cookieValue = Util.urlDecodeUTF8(cookieValue);
            }
            StringTokenizer tokenizer = new StringTokenizer(cookieValue, SEPARATORS);
            while (tokenizer.hasMoreTokens()) {
                String b64EncodedIdpID = tokenizer.nextToken();
                String idpID = B64.decodeToString((String)b64EncodedIdpID);
                idpList.add(idpID);
            }
        }
        return idpList;
    }

    static String encodeCommonDomainCookie(List<String> idpList) {
        Object cookieValue = "";
        boolean first = true;
        for (String idp : idpList) {
            String base64EncodedIdpId = B64.encode((String)idp);
            if (!first) {
                cookieValue = (String)cookieValue + SEPARATORS;
            }
            cookieValue = (String)cookieValue + base64EncodedIdpId;
            first = false;
        }
        return cookieValue;
    }

    public static String toString(String cookieValue) {
        Object retV = "Common Domain Cookie:\n";
        List<String> idpList = CommonDomainCookie.decodeCommonDomainCookie(cookieValue);
        for (String idp : idpList) {
            retV = (String)retV + "\t" + idp + "\n";
        }
        return retV;
    }
}

