/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.commondomain;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.crypto.HMAC;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.CommonDomainService;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.websso.commondomain.CommonDomainUtil;

public abstract class CommonDomainHandlerBase {
    private static final int COOKIE_LIFE_SESSION_COOKIE = -1;
    protected Log log = LogFactory.getLog(this.getClass());
    private MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();

    public abstract void process(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    private boolean validateMAC(HttpServletRequest request) {
        CommonDomainService commonDomainServiceSeetings = this.getCommonDomainService();
        boolean macRequired = commonDomainServiceSeetings != null && !StringUtils.isBlank((String)commonDomainServiceSeetings.getPassPhrase());
        boolean valid = false;
        String queryStr = request.getQueryString();
        String macValue = request.getParameter("MAC");
        if (!StringUtils.isBlank((String)queryStr)) {
            int macPos = queryStr.indexOf("MAC");
            if (macPos > 0) {
                String queryWithoutMAC = queryStr.substring(0, macPos - 1);
                if (macRequired) {
                    HMAC hmac = new HMAC(commonDomainServiceSeetings.getPassPhrase(), CommonDomainUtil.getHashIterationCount());
                    valid = hmac.verifyMac(queryWithoutMAC, macValue);
                    if (!valid) {
                        this.log.warn((Object)("Invalid MAC in request: " + LogGuard.encode(request.getRequestURL())));
                    }
                } else {
                    valid = false;
                    this.log.warn((Object)"IdP Discovery settings may have not been configured properly. Unable to validate the MAC.");
                }
            } else {
                valid = !macRequired;
                this.log.info((Object)"No MAC on query string.");
            }
        }
        return valid;
    }

    protected boolean validate(HttpServletRequest request) {
        boolean validMAC = this.validateMAC(request);
        String notOnOrAfterStr = request.getParameter("NOOA");
        XmlCalendar notOnOrAfter = new XmlCalendar(notOnOrAfterStr);
        Calendar now = Util.getUtcCalendar();
        boolean validNOOA = now.before(notOnOrAfter);
        if (!validNOOA) {
            this.log.warn((Object)"NOOA value expired.");
        }
        return validMAC && validNOOA;
    }

    public String getCommonDomain() {
        String commonDomain = null;
        CommonDomainService commonDomainServiceSeetings = this.getCommonDomainService();
        if (commonDomainServiceSeetings != null) {
            commonDomain = commonDomainServiceSeetings.getCommonDomain();
        }
        return commonDomain;
    }

    public int getCookieLife() {
        int cookieLife = -1;
        CommonDomainService commonDomainServiceSeetings = this.getCommonDomainService();
        if (commonDomainServiceSeetings != null && !StringUtils.isBlank((String)commonDomainServiceSeetings.getPassPhrase())) {
            cookieLife = commonDomainServiceSeetings.getCookieLifeDays();
        }
        return cookieLife;
    }

    protected String calculateMAC(String value) {
        String mac = null;
        CommonDomainService commonDomainServiceSeetings = this.getCommonDomainService();
        if (commonDomainServiceSeetings != null && !StringUtils.isBlank((String)commonDomainServiceSeetings.getPassPhrase())) {
            HMAC hmac = new HMAC(commonDomainServiceSeetings.getPassPhrase(), CommonDomainUtil.getHashIterationCount(), null);
            mac = hmac.calculateMac(value);
        }
        return mac;
    }

    protected String dumpRequestParams(HttpServletRequest request) {
        String msg = "QueryString: " + request.getQueryString() + "\nDecoded Request Parameters:\n";
        if (request.getParameter("EID") != null) {
            msg = msg + "\tEID=" + B64.decodeToString((String)request.getParameter("EID")) + "\n";
        }
        if (request.getParameter("NOOA") != null) {
            msg = msg + "\tNOOA=" + request.getParameter("NOOA") + "\n";
        }
        if (request.getParameter("RESUME") != null) {
            msg = msg + "\tRESUME=" + B64.decodeToString((String)request.getParameter("RESUME")) + "\n";
        }
        if (request.getParameter("MAC") != null) {
            msg = msg + "\tMAC=" + request.getParameter("MAC") + "\n";
        }
        if (request.getParameter("C") != null) {
            msg = msg + "\tC=" + request.getParameter("C") + "\n";
        }
        return msg;
    }

    private CommonDomainService getCommonDomainService() {
        CommonDomainService commonDomainServiceSeetings = null;
        IdpDiscovery idpDiscoveryParams = this.localMetaData.getIdpDiscovery();
        if (idpDiscoveryParams != null) {
            commonDomainServiceSeetings = idpDiscoveryParams.getCommonDomainService();
        }
        return commonDomainServiceSeetings;
    }
}

