/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.commondomain;

import com.pingidentity.common.util.B64;
import com.pingidentity.crypto.HMAC;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.CommonDomainClient;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;

public class CommonDomainUtil {
    public static final String PARAM_ENTITY_ID = "EID";
    public static final String PARAM_NOT_ON_OR_AFTER = "NOOA";
    public static final String PARAM_RESUME_URL = "RESUME";
    public static final String PARAM_MAC = "MAC";
    public static final String PARAM_COOKIE = "C";
    private static final String VALIDITY_MINUTES = "validity-minutes";
    private static final String HASH_ITERATION_COUNT = "hash-iteration-count";
    private static ConfigStore config = ConfigStoreFarm.getConfig(CommonDomainUtil.class);
    private static MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private static final int hashIterationCount = config.getIntValue("hash-iteration-count", 0);
    private static final int validityMinutes = config.getIntValue("validity-minutes", 5);

    public static String createIdpRegistrationUrl(HttpServletRequest req, String idpEntityId, String resumePath) {
        String requestURL = req.getRequestURL().toString();
        int endPos = requestURL.indexOf(47, 10);
        String requestBaseURL = requestURL.substring(0, endPos);
        String resumeUrl = requestBaseURL + resumePath;
        return CommonDomainUtil.createIdpRegistrationUrl(idpEntityId, resumeUrl);
    }

    public static String createIdpRegistrationUrl(String idpEntityId, String resumeUrl) {
        CommonDomainClient commonDomainClientSettings;
        String qStr = "EID=" + B64.encode((String)idpEntityId) + "&NOOA=" + CommonDomainUtil.createNOOA() + "&RESUME=" + B64.encode((String)resumeUrl);
        IdpDiscovery idpDiscoveryParams = localMetaData.getIdpDiscovery();
        if (idpDiscoveryParams != null && (commonDomainClientSettings = idpDiscoveryParams.getCommonDomainClient()) != null) {
            if (!StringUtils.isBlank((String)commonDomainClientSettings.getPassPhrase())) {
                HMAC hmac = new HMAC(commonDomainClientSettings.getPassPhrase(), hashIterationCount);
                String mac = hmac.calculateMac(qStr);
                qStr = qStr + "&MAC=" + mac;
            }
            if (!StringUtils.isBlank((String)commonDomainClientSettings.getCommonDomainServiceBaseUrl())) {
                String writeCookiePath = idpDiscoveryParams.getWriteCookiePath();
                return commonDomainClientSettings.getCommonDomainServiceBaseUrl() + writeCookiePath + "?" + qStr;
            }
        }
        return null;
    }

    public static String createGetIdpsUrl(HttpServletRequest req, String resumePath) {
        String url = null;
        String requestURL = req.getRequestURL().toString();
        int endPos = requestURL.indexOf(47, 10);
        String requestBaseURL = requestURL.substring(0, endPos);
        String resumeUrl = requestBaseURL + resumePath;
        String qStr = "NOOA=" + CommonDomainUtil.createNOOA() + "&RESUME=" + B64.encode((String)resumeUrl);
        IdpDiscovery idpDiscoveryParams = localMetaData.getIdpDiscovery();
        if (idpDiscoveryParams != null) {
            CommonDomainClient commonDomainClientSettings = idpDiscoveryParams.getCommonDomainClient();
            if (commonDomainClientSettings != null && !StringUtils.isBlank((String)commonDomainClientSettings.getPassPhrase())) {
                HMAC hmac = new HMAC(commonDomainClientSettings.getPassPhrase(), hashIterationCount);
                String mac = hmac.calculateMac(qStr);
                qStr = qStr + "&MAC=" + mac;
            }
            if (commonDomainClientSettings != null && !StringUtils.isBlank((String)commonDomainClientSettings.getCommonDomainServiceBaseUrl())) {
                String readCookiePath = idpDiscoveryParams.getReadCookiePath();
                url = commonDomainClientSettings.getCommonDomainServiceBaseUrl() + readCookiePath + "?" + qStr;
            }
        }
        return url;
    }

    public static String createNOOA() {
        Calendar notOnOrAfter = Util.getUtcCalendar();
        notOnOrAfter.add(12, validityMinutes);
        return notOnOrAfter.toString();
    }

    public static int getValidityMinutes() {
        return validityMinutes;
    }

    public static int getHashIterationCount() {
        return hashIterationCount;
    }
}

