/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.commondomain;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.EOLUtil;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.websso.commondomain.CommonDomainCookie;
import org.sourceid.websso.commondomain.CommonDomainHandlerBase;
import org.sourceid.websso.commondomain.CommonDomainUtil;

public class ReadCookieHandler
extends CommonDomainHandlerBase {
    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean validated;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.dumpRequestParams(request));
        }
        if (!(validated = this.validate(request))) {
            response.sendError(400, "NOOA value expired or invalid MAC detected");
            return;
        }
        Object redirectURL = B64.decodeToString((String)request.getParameter("RESUME"));
        String cookieValue = CommonDomainCookie.getCommonDomainCookie(request);
        cookieValue = EOLUtil.stripEOLs(cookieValue);
        this.log.debug((Object)cookieValue);
        if (cookieValue != null) {
            this.log.debug((Object)CommonDomainCookie.toString(URLDecoder.decode(cookieValue, "UTF-8")));
        }
        String qStr = "C=" + cookieValue + "&NOOA=" + CommonDomainUtil.createNOOA();
        redirectURL = (String)redirectURL + "?" + qStr;
        String mac = this.calculateMAC(qStr);
        if (mac != null) {
            redirectURL = (String)redirectURL + "&MAC=" + mac;
        }
        response.sendRedirect((String)redirectURL);
    }
}

