/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.domain.trans;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.sourceid.websso.Protocol;

public class DomainTranslator
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String ARTIFACT = "Artifact";
    public static final String REDIRECT = "Redirect";
    public static final String SOAP = "SOAP";
    public static final String PAOS = "PAOS";
    private static EnumMap<Protocol, DomainTranslator> instanceMap = new EnumMap(Protocol.class);
    private Map<String, String> uriToNameMap;
    private Map<String, String> nameToUriMap;

    private DomainTranslator(Map<String, String> uriToNameMap, Map<String, String> nameToUriMap) {
        this.uriToNameMap = uriToNameMap;
        this.nameToUriMap = nameToUriMap;
    }

    public static DomainTranslator getTranslator(Protocol protocol) {
        return instanceMap.get(protocol);
    }

    public String toBindingGuiName(String bindingUri) {
        String guiName = this.uriToNameMap.get(bindingUri);
        return guiName != null ? guiName : bindingUri;
    }

    public String toBindingUri(String bindingGuiName) {
        String uri = this.nameToUriMap.get(bindingGuiName);
        return uri != null ? uri : bindingGuiName;
    }

    static {
        HashMap<String, String> saml20UriToNameMap = new HashMap<String, String>();
        saml20UriToNameMap.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", POST);
        saml20UriToNameMap.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", ARTIFACT);
        saml20UriToNameMap.put("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", SOAP);
        saml20UriToNameMap.put("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", REDIRECT);
        saml20UriToNameMap.put("urn:oasis:names:tc:SAML:2.0:bindings:PAOS", PAOS);
        HashMap<String, String> saml20NameToUriMap = new HashMap<String, String>();
        saml20NameToUriMap.put(POST, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        saml20NameToUriMap.put(ARTIFACT, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
        saml20NameToUriMap.put(SOAP, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        saml20NameToUriMap.put(REDIRECT, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        saml20NameToUriMap.put(PAOS, "urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
        instanceMap.put(Protocol.SAML20, new DomainTranslator(saml20UriToNameMap, saml20NameToUriMap));
        HashMap<String, String> saml1xUriToNameMap = new HashMap<String, String>();
        saml1xUriToNameMap.put("urn:oasis:names:tc:SAML:1.0:profiles:browser-post", POST);
        saml1xUriToNameMap.put("urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", ARTIFACT);
        saml1xUriToNameMap.put("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", SOAP);
        HashMap<String, String> saml1xNameToUriMap = new HashMap<String, String>();
        saml1xNameToUriMap.put(POST, "urn:oasis:names:tc:SAML:1.0:profiles:browser-post");
        saml1xNameToUriMap.put(ARTIFACT, "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01");
        saml1xNameToUriMap.put(SOAP, "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        DomainTranslator domainTranslator1x = new DomainTranslator(saml1xUriToNameMap, saml1xNameToUriMap);
        instanceMap.put(Protocol.SAML10, domainTranslator1x);
        instanceMap.put(Protocol.SAML11, domainTranslator1x);
        HashMap<String, String> wsfedNameToUriMap = new HashMap<String, String>();
        wsfedNameToUriMap.put(POST, "wsfed:prp:http:post");
        wsfedNameToUriMap.put(GET, "wsfed:prp:http:get");
        DomainTranslator domainTranslatorwsfed = new DomainTranslator(wsfedNameToUriMap, wsfedNameToUriMap);
        instanceMap.put(Protocol.WSFED, domainTranslatorwsfed);
        instanceMap.put(Protocol.OIDC, new DomainTranslator((Map<String, String>)new HashedMap(), (Map<String, String>)new HashedMap()));
    }
}

