/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.common.util.xml.XmlObjectBuilder;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelComplexType;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelElement;
import org.oasisOpen.docs.wsfed.authorization.x200706.ClaimType;
import org.oasisOpen.docs.wsfed.authorization.x200706.DescriptionType;
import org.oasisOpen.docs.wsfed.authorization.x200706.DisplayNameType;
import org.oasisOpen.docs.wsfed.federation.x200706.ApplicationServiceType;
import org.oasisOpen.docs.wsfed.federation.x200706.ClaimTypesOfferedType;
import org.oasisOpen.docs.wsfed.federation.x200706.ClaimTypesRequestedType;
import org.oasisOpen.docs.wsfed.federation.x200706.EndpointType;
import org.oasisOpen.docs.wsfed.federation.x200706.SecurityTokenServiceType;
import org.oasisOpen.docs.wsfed.federation.x200706.TokenType;
import org.oasisOpen.docs.wsfed.federation.x200706.TokenTypesOfferedType;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.common.dsig.XmlSignatureUtil;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.SoapServerSupport;
import org.sourceid.common.soap.soap11.SoapEndpointUtility;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.NoSuchValueException;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.protocol.dsig10.xml.X509DataType;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.KeyDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.KeyTypes;
import org.sourceid.saml20.xmlbinding.metadata.RoleDescriptorType;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.RequestCreator;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.wstrust.crypto.IdBasedResolver;
import org.sourceid.wstrust.generator.saml.Saml11TokenGenerator;
import org.sourceid.wstrust.generator.saml.Saml20TokenGenerator;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;
import org.sourceid.wstrust.model.Saml20SecurityToken;
import org.sourceid.wstrust.model.SoapHeaders;
import org.sourceid.wstrust.model.mapper.WSTrustXmlMapper;
import org.sourceid.wstrust.model.mapper.XmlLocalName;
import org.sourceid.wstrust.plugin.generate.TokenGenerator;
import org.sourceid.wstrust.protocol.WSTrustVersion;
import org.w3.x2005.x08.addressing.AttributedURIType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3.x2005.x08.addressing.MetadataType;
import org.w3c.dom.Node;
import org.xmlsoap.schemas.ws.x2004.x09.mex.MetadataDocument;
import org.xmlsoap.schemas.ws.x2004.x09.mex.MetadataReferenceDocument;
import org.xmlsoap.schemas.ws.x2004.x09.mex.MetadataSectionDocument;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyReferenceDocument;
import org.xmlsoap.schemas.wsdl.DefinitionsDocument;
import org.xmlsoap.schemas.wsdl.TBinding;
import org.xmlsoap.schemas.wsdl.TDefinitions;
import org.xmlsoap.schemas.wsdl.TMessage;
import org.xmlsoap.schemas.wsdl.TPort;
import org.xmlsoap.schemas.wsdl.TPortType;
import org.xmlsoap.schemas.wsdl.TService;
import org.xmlsoap.schemas.wsdl.TTypes;

public class ConnectionMetadataRequestCreator
implements RequestCreator {
    private static final String DEFAULT_CLAIM_URI = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims";
    private static final String NAME_CLAIM_URI = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name";
    private static final String NAME_ID_CLAIM_URI = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/nameidentifier";
    private static final String NAME_ID = "NameID";
    private static final String MEX = "mex";
    private static final String TYPE = "type";
    private static final String FORCE_ISSUED_TOKEN_POLICY = "forceIssuedTokenPolicy";
    private static final String XSD = "xsd";
    private static final String WS_TRANSFER_GET = "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get";
    private static final String WS_TRANSFER_GET_RESPONSE = "http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse";
    private static final String NS_SAML1 = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String NS_SAML2 = "urn:oasis:names:tc:SAML:2.0:assertion";
    private static final String ISSUED_TOKEN_POLICY_ID = "issuedtoken";
    private static final String WINDOWS_TRANSPORT_POLICY_ID = "windowstransport";
    private static final String WINDOWS_TRANSPORT_BINDING_PORT_NAME = "CustomBinding_IWSTrust13Async";
    private static final String WINDOWS_TRANSPORT_BINDING_PORT_NAME_2005 = "CustomBinding_IWSTrustFeb2005Async";
    private static final String USERNAME_BINDING_PORT_NAME = "UserNameWSTrustBinding_IWSTrustFeb2005Async";
    private static final String WS_FEDERATION_NS = "http://docs.oasis-open.org/wsfed/federation/200706";
    private static final String USERNAME_TOKEN_BASE_TYPE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
    private final List<String> supportedProtocols;
    private final Log log = LogFactory.getLog(this.getClass());
    private final String wsdlDir;
    private final String policyDir;
    private final String xsdDir;
    private final MetadataLocal metadataLocal;
    private final Map<String, PolicyDocument> policyDocTemplates = new HashMap<String, PolicyDocument>();
    private final Map<String, String> xsdTemplates = new HashMap<String, String>();
    private WsTrustStsMetadataRequestCreatorConfig wsTrustStsMetadataRequestCreatorConfig;
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.websso.profiles.ConnectionMetadataRequestCreator");
    private static final String INCLUDE_CERT_IN_KEY_INFO = "IncludeCertInKeyInfo";

    public ConnectionMetadataRequestCreator() {
        this.supportedProtocols = new LinkedList<String>();
        this.supportedProtocols.add(WSTrustVersion.v2005.getDocumentNamespace().getUri());
        this.supportedProtocols.add(WSTrustVersion.v13.getDocumentNamespace().getUri());
        this.supportedProtocols.add(WS_FEDERATION_NS);
        SysDirInfo sysDirInfo = GlobalRegistry.getService(SysDirInfo.class);
        this.wsdlDir = sysDirInfo.getConfigDirectory() + File.separator + "template" + File.separator + "wsdl";
        this.policyDir = sysDirInfo.getConfigDirectory() + File.separator + "template" + File.separator + "ws-policy";
        this.xsdDir = sysDirInfo.getConfigDirectory() + File.separator + "template" + File.separator + XSD;
        this.metadataLocal = MetaDataFactory.getLocalMetaData();
        this.wsTrustStsMetadataRequestCreatorConfig = WsTrustStsMetadataRequestCreatorConfig.getInstance();
        this.initPolicyTemplate();
        this.initXsdTemplates();
    }

    private Set<String> getDefinitionsDocTemplates(String partnerSpId) {
        Set<String> wsdlFiles = this.getWSDLFiles(partnerSpId);
        LinkedHashSet<String> tempDefinitionsDocTemplates = new LinkedHashSet<String>();
        for (String wsdlFile : wsdlFiles) {
            try {
                String tempDefinitionsDocTemplate = this.formatFileToString(wsdlFile);
                tempDefinitionsDocTemplates.add(tempDefinitionsDocTemplate);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to parse '" + wsdlFile + "'. Will not be able to send proper MEX metadata."), (Throwable)e);
            }
        }
        return tempDefinitionsDocTemplates;
    }

    private void initPolicyTemplate() {
        File[] policyTemplateFiles;
        File policyTemplateDir = new File(this.policyDir);
        if (policyTemplateDir.exists() && (policyTemplateFiles = policyTemplateDir.listFiles()) != null) {
            for (File policyTemplateFile : policyTemplateFiles) {
                String policyFileName = policyTemplateFile.getName();
                String xmlExt = ".xml";
                if (!policyFileName.toLowerCase(Locale.ENGLISH).endsWith(xmlExt) || policyFileName.length() <= xmlExt.length()) continue;
                PolicyDocument policyTemplate = null;
                try (FileInputStream fileInputStream = new FileInputStream(policyTemplateFile);){
                    Node node = XmlBeansUtil.parseToNode(fileInputStream);
                    policyTemplate = PolicyDocument.Factory.parse((Node)node);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to parse '" + policyTemplateFile.getName() + "'. " + e.getMessage()), (Throwable)e);
                    continue;
                }
                String policyTemplateName = policyFileName.substring(0, policyFileName.length() - xmlExt.length());
                this.policyDocTemplates.put(policyTemplateName, policyTemplate);
            }
        }
    }

    private void initXsdTemplates() {
        File[] xsdTemplateFiles;
        File xsdTemplateDir = new File(this.xsdDir);
        if (xsdTemplateDir.exists() && (xsdTemplateFiles = xsdTemplateDir.listFiles()) != null) {
            for (File xsdTemplateFile : xsdTemplateFiles) {
                String xsdFileName = xsdTemplateFile.getName();
                String xsdExt = ".xsd";
                if (!xsdFileName.toLowerCase(Locale.ENGLISH).endsWith(xsdExt) || xsdFileName.length() <= xsdExt.length()) continue;
                String xsdTemplate = null;
                try {
                    xsdTemplate = this.formatFileToString(xsdTemplateFile.getAbsolutePath());
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to parse '" + xsdTemplateFile.getName() + "'. " + e.getMessage()), (Throwable)e);
                    continue;
                }
                this.xsdTemplates.put(xsdFileName, xsdTemplate);
            }
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    private void respondInText(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/xml");
        response.setContentLength(message.getBytes(StandardCharsets.UTF_8).length);
        response.setStatus(200);
        try (PrintWriter out = response.getWriter();){
            out.println(message);
            out.flush();
        }
    }

    private String doAdditionalTranslation(String xmlResponse, String policyId) {
        xmlResponse = xmlResponse.replaceAll("port name=\"UserNameWSTrustBinding_IWSTrustFeb2005Async_username\"", "port name=\"UserNameWSTrustBinding_IWSTrustFeb2005Async\"");
        xmlResponse = xmlResponse.replaceAll("wsu:Id=\"" + policyId + "\"", "wsu:Id=\"UserNameWSTrustBinding_IWSTrustFeb2005Async_policy\"");
        xmlResponse = xmlResponse.replaceAll("#" + policyId, "#UserNameWSTrustBinding_IWSTrustFeb2005Async_policy");
        return xmlResponse;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    private void respondInSoap(HttpServletResponse response, XmlObject soapObject, String partnerSpId) throws IOException {
        XmlCursor cursor = soapObject.newCursor();
        cursor.toNextToken();
        String uri = cursor.getName().getNamespaceURI();
        cursor.dispose();
        String contentType = null;
        contentType = uri.equals("http://www.w3.org/2003/05/soap-envelope") ? "application/soap+xml; charset=utf-8" : "text/xml; charset=utf-8";
        response.setContentType(contentType);
        response.setStatus(200);
        try (PrintWriter out = response.getWriter();){
            boolean customizeResponse;
            StringWriter stringWriter = new StringWriter();
            XmlBeansUtil.save(soapObject, stringWriter);
            String xmlResponse = stringWriter.toString();
            xmlResponse = xmlResponse.replaceAll("<mex:MetadataSection ", "<wsx:MetadataSection xmlns:wsx=\"http://schemas.xmlsoap.org/ws/2004/09/mex\" ");
            xmlResponse = xmlResponse.replaceAll("</mex:MetadataSection>", "</wsx:MetadataSection>");
            WsTrustStsPartnerResponseConfig wsTrustStsPartnerResponseConfig = this.wsTrustStsMetadataRequestCreatorConfig.getWsTrustStsPartnerResponseConfig(partnerSpId);
            if (wsTrustStsPartnerResponseConfig != null && (customizeResponse = wsTrustStsPartnerResponseConfig.isEnabled()) && partnerSpId.equals("urn:federation:MicrosoftOnline")) {
                String usernamePolicyTemplateFile = "username_o365.xml";
                String usernamePolicyId = usernamePolicyTemplateFile.substring(0, usernamePolicyTemplateFile.indexOf(".xml"));
                xmlResponse = this.doAdditionalTranslation(xmlResponse, usernamePolicyId);
            }
            out.write(xmlResponse);
            out.flush();
        }
    }

    @Override
    public OutMessageContext process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String partnerSpId = null;
        String partnerIdpId = null;
        try {
            partnerSpId = request.getParameter("PartnerSpId");
            partnerIdpId = request.getParameter("PartnerIdpId");
        }
        catch (InvalidRequestParameterException irpe) {
            response.sendError(400, "A valid 'PartnerSpId' or 'PartnerIdpId' request parameter must be specified.");
            return null;
        }
        boolean bIdp = true;
        String partnerId = null;
        if (!StringUtils.isBlank((String)partnerSpId) && StringUtils.isBlank((String)partnerIdpId)) {
            partnerId = partnerSpId;
            bIdp = true;
        } else if (StringUtils.isBlank((String)partnerSpId) && !StringUtils.isBlank((String)partnerIdpId)) {
            partnerId = partnerIdpId;
            bIdp = false;
        } else {
            response.sendError(400, "Either 'PartnerSpId' or 'PartnerIdpId' request parameter must be specified.");
            return null;
        }
        boolean forceIssuedTokenPolicy = request.getParameterMap().containsKey(FORCE_ISSUED_TOKEN_POLICY);
        if ("/pf/sts_mex.ping".equals(this.getServletPathWithoutPathParams(request))) {
            this.handleStsMexRequest(request, partnerId, bIdp, forceIssuedTokenPolicy, response);
        } else if ("/pf/federation_metadata.ping".equals(this.getServletPathWithoutPathParams(request))) {
            this.generateFederationMetadata(partnerId, bIdp, forceIssuedTokenPolicy, request, response);
        } else {
            String type = null;
            if (request.getParameterMap().containsKey(TYPE)) {
                type = request.getParameter(TYPE);
            }
            if (MEX.equals(type)) {
                this.handleStsMexRequest(request, partnerId, bIdp, forceIssuedTokenPolicy, response);
            } else {
                this.generateFederationMetadata(partnerId, bIdp, forceIssuedTokenPolicy, request, response);
            }
        }
        return null;
    }

    private Set<String> getWSDLFiles(String partnerSpId) {
        LinkedHashSet<String> wsdlFiles = new LinkedHashSet<String>();
        String wsdlFile = this.wsdlDir + File.separator + this.wsTrustStsMetadataRequestCreatorConfig.getDefaulStsWsdlTemplate();
        if (partnerSpId != null) {
            boolean isPartnerSpIdConfigured = this.wsTrustStsMetadataRequestCreatorConfig.isPartnerIdConfigured(partnerSpId);
            if (isPartnerSpIdConfigured) {
                WsTrustStsPartnerResponseConfig wsTrustStsPartnerResponseConfig = this.wsTrustStsMetadataRequestCreatorConfig.getWsTrustStsPartnerResponseConfig(partnerSpId);
                boolean useCustomTemplates = wsTrustStsPartnerResponseConfig.isEnabled();
                Set<String> configWsdls = wsTrustStsPartnerResponseConfig.getStsWsdlTemplates();
                if (useCustomTemplates && configWsdls != null && !configWsdls.isEmpty()) {
                    for (String configWsdl : configWsdls) {
                        wsdlFile = this.wsdlDir + File.separator + configWsdl;
                        wsdlFiles.add(wsdlFile);
                    }
                } else {
                    wsdlFiles.add(wsdlFile);
                }
            } else {
                wsdlFiles.add(wsdlFile);
            }
        } else {
            wsdlFiles.add(wsdlFile);
        }
        return wsdlFiles;
    }

    private List<DefinitionsDocument> generateWSDL(HttpServletRequest request, boolean bIdp) throws RequestProcessingException {
        String partnerSpId = request.getParameter("PartnerSpId");
        String stsEndPoint = BaseUrlUtil.getCurrentBaseUrl(this.metadataLocal.getBaseUrl()) + (bIdp ? this.metadataLocal.getIdpWsTrustStsEndpoint() : this.metadataLocal.getSpWsTrustStsEndpoint());
        DefinitionsDocument wsdlDoc = null;
        ArrayList<DefinitionsDocument> wslDocDefinitions = new ArrayList<DefinitionsDocument>();
        String wsdlTemplateFile = null;
        try {
            StringBuffer wsTrustXsdUrl = request.getRequestURL().append('?');
            String queryParams = request.getQueryString();
            if (queryParams != null) {
                wsTrustXsdUrl.append(queryParams);
                wsTrustXsdUrl.append('&');
            }
            Set<String> definitionsDocTemplates = this.getDefinitionsDocTemplates(partnerSpId);
            Iterator<String> iterator = definitionsDocTemplates.iterator();
            while (iterator.hasNext()) {
                String definitionsDocTemplate;
                wsdlTemplateFile = definitionsDocTemplate = iterator.next();
                String definitionsDocContent = MessageFormat.format(definitionsDocTemplate, StringEscapeUtils.escapeXml((String)stsEndPoint), StringEscapeUtils.escapeXml((String)wsTrustXsdUrl.toString()));
                Node node = XmlBeansUtil.parseToNode(definitionsDocContent);
                wsdlDoc = DefinitionsDocument.Factory.parse((Node)node);
                wslDocDefinitions.add(wsdlDoc);
            }
        }
        catch (Exception e) {
            throw new RequestProcessingException("Failed to parse '" + wsdlTemplateFile + "'.", e);
        }
        return wslDocDefinitions;
    }

    private List<PolicyDocument> generatePolicy(ConnectionBase connection, List<TokenProcessorMeta> tokenProcessorsMeta, boolean bIdp, boolean forceIssuedTokenPolicy, String virtualServerId, String partnerSpId) {
        if (bIdp) {
            WsTrustFederatedWscSettings wsTrustSettings = ((SpConnection)connection).getWsTrustSettings();
            Set<String> processorIds = wsTrustSettings.getIncomingTokenProcessors();
            TokenProcessorManager tokenProcessorManager = GlobalRegistry.getService(TokenProcessorManager.class);
            for (String string : processorIds) {
                TokenPluginAttributeMapping mapping = wsTrustSettings.getTokenToAssertionMappingByProcessorId(string);
                if (mapping.isRestrictVirtualServerIds() && virtualServerId != null && !mapping.getRestrictedVirtualServerIds().contains(virtualServerId)) continue;
                TokenPluginInstance tokenProcessorInstance = (TokenPluginInstance)tokenProcessorManager.getInstance(string);
                TokenProcessorMeta tokenProcessorMeta = new TokenProcessorMeta();
                tokenProcessorMeta.setTokenProcessorInstanceId(tokenProcessorInstance.getId());
                tokenProcessorMeta.setTokenProcessorType(tokenProcessorInstance.getTokenType());
                tokenProcessorsMeta.add(tokenProcessorMeta);
            }
        } else if (this.metadataLocal.getEnableSaml11Rp() || this.metadataLocal.getEnableSaml20Sp()) {
            TokenProcessorMeta tokenProcessorMeta = new TokenProcessorMeta();
            tokenProcessorMeta.setTokenProcessorType(Saml20SecurityToken.TYPE);
            tokenProcessorsMeta.add(tokenProcessorMeta);
        }
        ConfigStore tokenProcessorPolicyConfigStore = ConfigStoreFarm.getConfig("token-processor-policies");
        ArrayList<TokenProcessorMeta> additionalMeta = new ArrayList<TokenProcessorMeta>();
        HashSet<String> neededPolicyNames = new HashSet<String>();
        for (TokenProcessorMeta tokenProcessorMeta : tokenProcessorsMeta) {
            String policyNames;
            try {
                policyNames = tokenProcessorPolicyConfigStore.getStringValue(tokenProcessorMeta.getTokenProcessorType());
            }
            catch (NoSuchValueException e) {
                this.log.warn((Object)("Token type: " + tokenProcessorMeta.getTokenProcessorType() + " does not have a WS-Policy file defined"));
                continue;
            }
            String[] policyNameArray = policyNames.split(";");
            for (int i = 0; i < policyNameArray.length; ++i) {
                String policyName = policyNameArray[i];
                if (policyName.isEmpty()) continue;
                if (i > 0) {
                    TokenProcessorMeta additionalTpMeta = new TokenProcessorMeta();
                    additionalTpMeta.setTokenProcessorInstanceId(tokenProcessorMeta.getTokenProcessorInstanceId());
                    additionalTpMeta.setTokenProcessorType(tokenProcessorMeta.getTokenProcessorType());
                    additionalTpMeta.setTokenProcessorPolicyId(policyName);
                    additionalMeta.add(additionalTpMeta);
                } else {
                    tokenProcessorMeta.setTokenProcessorPolicyId(policyName);
                }
                boolean isUserNameTokenProcessor = tokenProcessorMeta.getTokenProcessorType().equals(USERNAME_TOKEN_BASE_TYPE_URI);
                if (isUserNameTokenProcessor) {
                    WsTrustStsPartnerResponseConfig config = this.wsTrustStsMetadataRequestCreatorConfig.getWsTrustStsPartnerResponseConfig(partnerSpId);
                    Set<Object> usernameTemplatesConfigured = new HashSet<String>();
                    if (config != null) {
                        boolean isEnabled = config.isEnabled();
                        if (isEnabled) {
                            usernameTemplatesConfigured = config.getUsernamePolicyTemplates();
                        } else {
                            usernameTemplatesConfigured.add(config.getDefaultUsernamePolicyTemplate());
                        }
                    } else {
                        String template = this.wsTrustStsMetadataRequestCreatorConfig.getDefaultUsernamePolicyTemplate();
                        usernameTemplatesConfigured.add(template);
                    }
                    if (neededPolicyNames.contains(policyName) || !usernameTemplatesConfigured.contains(policyName + ".xml")) continue;
                    neededPolicyNames.add(policyName);
                    continue;
                }
                if (neededPolicyNames.contains(policyName)) continue;
                neededPolicyNames.add(policyName);
            }
        }
        tokenProcessorsMeta.addAll(additionalMeta);
        ArrayList<PolicyDocument> policies = new ArrayList<PolicyDocument>();
        for (String policyName : neededPolicyNames) {
            PolicyDocument policyTemplate = this.policyDocTemplates.get(policyName);
            if (policyTemplate == null) {
                this.log.warn((Object)("Unable to find policy template for policy '" + policyName + "'. Skipping this policy."));
                continue;
            }
            policies.add((PolicyDocument)policyTemplate.copy());
        }
        if (forceIssuedTokenPolicy) {
            PolicyDocument policyDocument = this.policyDocTemplates.get(ISSUED_TOKEN_POLICY_ID);
            if (policyDocument == null) {
                this.log.warn((Object)"Unable to find policy template for policy 'issuedtoken'. Skipping this policy.");
            } else {
                policies.add((PolicyDocument)policyDocument.copy());
            }
        }
        return policies;
    }

    private void attachPolicy2WSDL(List<PolicyDocument> policies, List<TokenProcessorMeta> tokenProcessorsMeta, DefinitionsDocument wsdl, boolean bIdp, boolean forceIssuedTokenPolicy, String virtualServerId, String partnerSpId, boolean isLyncTemplate, WindowsTransportBindingCounters counters) throws RequestProcessingException {
        if (policies.isEmpty()) {
            return;
        }
        TDefinitions definitions = wsdl.getDefinitions();
        TBinding[] bindings = definitions.getBindingArray();
        if (bindings.length != 1) {
            throw new RequestProcessingException("Expected 1 binding in WSDL, but got " + bindings.length);
        }
        TBinding binding = bindings[0];
        TService[] services = definitions.getServiceArray();
        if (services.length != 1) {
            throw new RequestProcessingException("Expected 1 service in WSDL, but got " + services.length);
        }
        TService service = services[0];
        TPort[] ports = service.getPortArray();
        if (ports.length != 1) {
            throw new RequestProcessingException("Expected 1 port in WSDL, but got " + ports.length);
        }
        TPort port = ports[0];
        TDefinitions templateDefinitions = DefinitionsDocument.Factory.newInstance().addNewDefinitions();
        TBinding templateBinding = templateDefinitions.addNewBinding();
        templateBinding.set((XmlObject)binding);
        TPort templatePort = templateDefinitions.addNewService().addNewPort();
        templatePort.set((XmlObject)port);
        XmlCursor bindingCursor = binding.newCursor();
        bindingCursor.removeXml();
        bindingCursor.dispose();
        XmlCursor portCursor = port.newCursor();
        portCursor.removeXml();
        portCursor.dispose();
        XmlCursor serviceCursor = service.newCursor();
        XmlCursor serviceEndCursor = service.newCursor();
        serviceEndCursor.toEndToken();
        for (PolicyDocument policyDoc : policies) {
            PolicyDocument.Policy policy = policyDoc.getPolicy();
            XmlBeansUtil.prependChildren((XmlObject)definitions, new XmlObject[]{policy});
            PolicyReferenceDocument policyRefDoc = PolicyReferenceDocument.Factory.newInstance();
            PolicyReferenceDocument.PolicyReference policyRef = policyRefDoc.addNewPolicyReference();
            policyRef.setURI("#" + policy.getId());
            TDefinitions tmpDef = DefinitionsDocument.Factory.newInstance().addNewDefinitions();
            TBinding newBinding = tmpDef.addNewBinding();
            newBinding.set((XmlObject)templateBinding);
            XmlBeansUtil.prependChildren((XmlObject)newBinding, new XmlObject[]{policyRef});
            Object bindingName = null;
            boolean isWindowsTransportPolicy = false;
            if (WINDOWS_TRANSPORT_POLICY_ID.equals(policy.getId())) {
                String tempBindingName;
                isWindowsTransportPolicy = true;
                if (!isLyncTemplate) {
                    tempBindingName = WINDOWS_TRANSPORT_BINDING_PORT_NAME;
                    bindingName = counters.windowsTransportBindingBindingNum > 0 ? tempBindingName + String.valueOf(counters.windowsTransportBindingBindingNum) : tempBindingName;
                    ++counters.windowsTransportBindingBindingNum;
                } else {
                    tempBindingName = WINDOWS_TRANSPORT_BINDING_PORT_NAME_2005;
                    bindingName = counters.windowsTransportBinding2005BindingNum > 0 ? tempBindingName + String.valueOf(counters.windowsTransportBinding2005BindingNum) : tempBindingName;
                    ++counters.windowsTransportBinding2005BindingNum;
                }
            } else {
                boolean customizeMetadataResponseEnabled = false;
                WsTrustStsPartnerResponseConfig wsTrustStsPartnerResponseConfig = this.wsTrustStsMetadataRequestCreatorConfig.getWsTrustStsPartnerResponseConfig(partnerSpId);
                if (wsTrustStsPartnerResponseConfig != null) {
                    customizeMetadataResponseEnabled = wsTrustStsPartnerResponseConfig.isEnabled();
                }
                bindingName = customizeMetadataResponseEnabled && policy.getId().equals("username_o365") ? templateBinding.getName() : templateBinding.getName() + "_" + policy.getId();
            }
            newBinding.setName((String)bindingName);
            QName templateQName = templatePort.getBinding();
            QName bindingQName = new QName(templateQName.getNamespaceURI(), newBinding.getName(), templateQName.getPrefix());
            XmlCursor newBindingCursor = newBinding.newCursor();
            newBindingCursor.moveXml(serviceCursor);
            newBindingCursor.dispose();
            int trackUTPCount = 0;
            for (TokenProcessorMeta tokenProcessorMeta : tokenProcessorsMeta) {
                if (tokenProcessorMeta.getTokenProcessorPolicyId() == null || !tokenProcessorMeta.getTokenProcessorPolicyId().equals(policy.getId())) continue;
                String stsEndPoint = this.buildStsEndpointUrl(virtualServerId, bIdp);
                XmlCursor templatePortCursor = templatePort.newCursor();
                templatePortCursor.selectPath("declare namespace soap12='http://schemas.xmlsoap.org/wsdl/soap12/' .//soap12:address");
                templatePortCursor.toNextSelection();
                StringBuilder sb = new StringBuilder(stsEndPoint);
                if (bIdp) {
                    sb.append("?TokenProcessorId=");
                    sb.append(tokenProcessorMeta.getTokenProcessorInstanceId());
                }
                String location = sb.toString();
                templatePortCursor.setAttributeText(new QName("location"), location);
                templatePortCursor.dispose();
                templatePortCursor = templatePort.newCursor();
                templatePortCursor.selectPath("declare namespace wsa10='http://www.w3.org/2005/08/addressing' .//wsa10:Address");
                templatePortCursor.toNextSelection();
                templatePortCursor.setTextValue(location);
                templatePortCursor.dispose();
                TPort newPort = tmpDef.addNewService().addNewPort();
                newPort.set((XmlObject)templatePort);
                Object portName = null;
                if (isWindowsTransportPolicy) {
                    String tempBindingName;
                    if (!isLyncTemplate) {
                        tempBindingName = WINDOWS_TRANSPORT_BINDING_PORT_NAME;
                        portName = counters.windowsTransportBindingPortNum > 0 ? tempBindingName + String.valueOf(counters.windowsTransportBindingPortNum) : tempBindingName;
                        ++counters.windowsTransportBindingPortNum;
                    } else {
                        tempBindingName = WINDOWS_TRANSPORT_BINDING_PORT_NAME_2005;
                        portName = counters.windowsTransportBinding2005PortNum > 0 ? tempBindingName + String.valueOf(counters.windowsTransportBinding2005PortNum) : tempBindingName;
                        ++counters.windowsTransportBinding2005PortNum;
                    }
                } else {
                    boolean customizeMetadataResponseEnabled = false;
                    WsTrustStsPartnerResponseConfig wsTrustStsPartnerResponseConfig = this.wsTrustStsMetadataRequestCreatorConfig.getWsTrustStsPartnerResponseConfig(partnerSpId);
                    if (wsTrustStsPartnerResponseConfig != null) {
                        customizeMetadataResponseEnabled = wsTrustStsPartnerResponseConfig.isEnabled();
                    }
                    if (customizeMetadataResponseEnabled && policy.getId().equals("username_o365") && isLyncTemplate) {
                        portName = trackUTPCount == 0 ? "UserNameWSTrustBinding_IWSTrustFeb2005Async_username" : "UserNameWSTrustBinding_IWSTrustFeb2005Async_username" + String.valueOf(trackUTPCount);
                        ++trackUTPCount;
                    } else {
                        portName = templatePort.getName() + "_" + policy.getId() + (String)(bIdp ? "_" + tokenProcessorMeta.getTokenProcessorInstanceId() : "");
                    }
                }
                newPort.setName((String)portName);
                newPort.setBinding(bindingQName);
                XmlCursor newPortCursor = newPort.newCursor();
                newPortCursor.moveXml(serviceEndCursor);
                newPortCursor.dispose();
            }
            if (!forceIssuedTokenPolicy || !policy.getId().equals(ISSUED_TOKEN_POLICY_ID)) continue;
            TPort newPort = tmpDef.addNewService().addNewPort();
            newPort.set((XmlObject)templatePort);
            newPort.setName(templatePort.getName() + "_issuedtoken");
            newPort.setBinding(bindingQName);
            XmlCursor newPortCursor = newPort.newCursor();
            newPortCursor.moveXml(serviceEndCursor);
            newPortCursor.dispose();
        }
    }

    private void addWSDL2Mex(DefinitionsDocument wsdl, MetadataDocument metadataDoc) {
        MetadataDocument.Metadata metadata = metadataDoc.addNewMetadata();
        MetadataSectionDocument.MetadataSection wsdlSection = metadata.addNewMetadataSection();
        wsdlSection.setDialect("http://schemas.xmlsoap.org/wsdl/");
        TDefinitions definitions = wsdl.getDefinitions();
        wsdlSection.setIdentifier(definitions.getTargetNamespace());
        XmlBeansUtil.setChildren((XmlObject)wsdlSection, new XmlObject[]{definitions});
    }

    private XmlObject generateEnvelope(HttpServletRequest request, XmlObject body) throws RequestProcessingException {
        XmlObject envelopeOut = null;
        try {
            SoapServerSupport soapSupport = SoapServerSupport.getSupport(request);
            XmlObject envelopeIn = soapSupport.getEnvelope();
            SoapHeaders headersIn = WSTrustXmlMapper.mapSoapHeaders(envelopeIn, new IdBasedResolver());
            String soapNS = soapSupport.getXmlNamespaceURI();
            if (!WS_TRANSFER_GET.equals(headersIn.getAction())) {
                throw new RequestProcessingException("Unexpected action: " + headersIn.getAction());
            }
            envelopeOut = XmlObjectBuilder.element(new QName(soapNS, "Envelope"), XmlObjectBuilder.element(new QName(soapNS, "Header"), XmlObjectBuilder.element(new QName(headersIn.getActionNamespaceURI(), XmlLocalName.ACTION.getLocalName()), WS_TRANSFER_GET_RESPONSE), XmlObjectBuilder.element(new QName(headersIn.getMessageIdNamespaceURI(), XmlLocalName.RELATES_TO.getLocalName()), headersIn.getMessageId())), XmlObjectBuilder.element(new QName(soapNS, "Body"), body));
        }
        catch (InvalidRequestException e) {
            throw new RequestProcessingException("Invalid MEX request.", e);
        }
        return envelopeOut;
    }

    private SchemaDocument.Schema loadXSD(SchemaTypeLoader schemaTypeLoader, QName element) throws RequestProcessingException {
        SchemaType rstDocType = schemaTypeLoader.findDocumentType(element);
        if (rstDocType == null) {
            throw new RequestProcessingException("Failed to find RST element schema type.");
        }
        String path = rstDocType.getSourceName();
        SchemaDocument schemaDoc = null;
        try (InputStream is = schemaTypeLoader.getSourceAsStream(path);){
            Node node = XmlBeansUtil.parseToNode(is);
            schemaDoc = SchemaDocument.Factory.parse((Node)node);
        }
        catch (IOException | XmlException e) {
            throw new RequestProcessingException("Failed to load " + path);
        }
        return schemaDoc.getSchema();
    }

    private void addXSD2Mex(DefinitionsDocument wsdl, MetadataDocument metadataDoc) throws RequestProcessingException {
        XmlCursor cursor = wsdl.getDefinitions().newCursor();
        HashMap wsdlNSMap = new HashMap();
        cursor.getAllNamespaces(wsdlNSMap);
        cursor.dispose();
        String rstElementName = "RequestSecurityToken";
        SchemaTypeSystem schemaTypeLoader = wsdl.schemaType().getTypeSystem();
        for (String nsUri : this.supportedProtocols) {
            TopLevelElement[] elements;
            if (!wsdlNSMap.containsValue(nsUri)) continue;
            SchemaDocument.Schema longSchema = this.loadXSD((SchemaTypeLoader)schemaTypeLoader, new QName(nsUri, rstElementName));
            TopLevelComplexType[] complexTypes = longSchema.getComplexTypeArray();
            HashMap<String, TopLevelComplexType> name2type = new HashMap<String, TopLevelComplexType>();
            for (TopLevelComplexType topLevelComplexType : complexTypes) {
                name2type.put(topLevelComplexType.getName(), topLevelComplexType);
            }
            SchemaDocument shortDoc = SchemaDocument.Factory.newInstance();
            SchemaDocument.Schema shortSchema = shortDoc.addNewSchema();
            for (TopLevelElement element : elements = longSchema.getElementArray()) {
                if (!element.getName().startsWith(rstElementName)) continue;
                shortSchema.addNewElement().set((XmlObject)element);
                QName type = element.getType();
                TopLevelComplexType complexType3 = (TopLevelComplexType)name2type.get(type.getLocalPart());
                if (complexType3 == null) {
                    throw new RequestProcessingException("Failed to find type '" + type + "' for element '" + element.getName() + "'.");
                }
                complexType3.unsetAnnotation();
                shortSchema.addNewComplexType().set((XmlObject)complexType3);
            }
            shortSchema.setTargetNamespace(nsUri);
            MetadataDocument.Metadata metadata = metadataDoc.getMetadata();
            MetadataSectionDocument.MetadataSection xsdSection = metadata.addNewMetadataSection();
            xsdSection.setDialect("http://www.w3.org/2001/XMLSchema");
            xsdSection.setIdentifier(shortSchema.getTargetNamespace());
            XmlBeansUtil.setChildren((XmlObject)xsdSection, new XmlObject[]{shortSchema});
        }
    }

    private void handleStsMexRequest(HttpServletRequest request, String partnerId, boolean bIdp, boolean forceIssuedTokenPolicy, HttpServletResponse response) throws IOException {
        boolean wsTrustEnabled;
        boolean bl = wsTrustEnabled = bIdp ? this.metadataLocal.getEnableIdpWsTrustSts() : this.metadataLocal.getEnableSpWsTrustSts();
        if (!wsTrustEnabled) {
            String errorMsg = bIdp ? "WS-Trust IDP Role not active" : "WS-Trust SP Role not active";
            response.sendError(400, errorMsg);
            return;
        }
        if (request.getParameterMap().containsKey(XSD)) {
            String xsdUrl = this.getRequestUrlReadyForXsdQueryParam(request);
            this.generateXSD(request.getParameter(XSD), xsdUrl, response);
        } else {
            this.generateMexMetadata(request, partnerId, bIdp, forceIssuedTokenPolicy, response);
        }
    }

    private void generateXSD(String xsdFileName, String xsdUrl, HttpServletResponse response) throws IOException {
        if (StringUtils.isNotBlank((String)xsdFileName)) {
            String xsdTemplate = this.xsdTemplates.get(xsdFileName);
            if (xsdTemplate != null) {
                this.log.info((Object)("Getting XSD for " + xsdFileName));
                String xsdString = MessageFormat.format(xsdTemplate, StringEscapeUtils.escapeXml((String)xsdUrl));
                this.respondInText(response, xsdString);
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(404);
        }
    }

    private void generateMexMetadata(HttpServletRequest request, String partnerId, boolean bIdp, boolean forceIssuedTokenPolicy, HttpServletResponse response) throws IOException {
        DefinitionsDocument result = null;
        boolean bSoap = "POST".equalsIgnoreCase(request.getMethod());
        String partnerSpId = request.getParameter("PartnerSpId");
        try {
            ConnectionBase connection;
            MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
            ConnectionBase connectionBase = connection = bIdp ? metadataDirectory.getSpConnectionMetadata(partnerId) : metadataDirectory.getIdpConnectionMetadata(partnerId);
            if (!connection.isActive()) {
                throw new RequestProcessingException("Connection '" + partnerId + "' is inactive.");
            }
            if (!connection.doesWsTrustSettingsExist()) {
                throw new RequestProcessingException("STS metadata not available for Connection '" + connection.getName() + "', EntityID: '" + connection.getEntityId() + "'");
            }
            this.log.info((Object)"Start generation of STS metadata");
            String virtualServerId = VirtualIdentityUtil.resolve(connection, request).getVirtualEntityId(DomainMode.RUNTIME);
            ArrayList<TokenProcessorMeta> tokenProcessorsMeta = new ArrayList<TokenProcessorMeta>();
            List<PolicyDocument> policies = this.generatePolicy(connection, tokenProcessorsMeta, bIdp, forceIssuedTokenPolicy, virtualServerId, partnerSpId);
            List<DefinitionsDocument> wsdlSet = this.generateWSDL(request, bIdp);
            if (VirtualIdentityUtil.extractVsid(request) == null) {
                virtualServerId = null;
            }
            WindowsTransportBindingCounters counters = new WindowsTransportBindingCounters();
            for (DefinitionsDocument wsdl : wsdlSet) {
                TPortType portType = wsdl.getDefinitions().getPortTypeArray()[0];
                String portTypeName = portType.getName();
                boolean isIwsTrustFeb2005Async = portTypeName != null && portTypeName.equals("IWSTrustFeb2005Async");
                this.attachPolicy2WSDL(policies, tokenProcessorsMeta, wsdl, bIdp, forceIssuedTokenPolicy, virtualServerId, partnerSpId, isIwsTrustFeb2005Async, counters);
            }
            DefinitionsDocument wsdlFinal = null;
            if (wsdlSet.size() == 1) {
                wsdlFinal = wsdlSet.get(0);
            } else {
                wsdlFinal = wsdlSet.get(0);
                boolean skip = true;
                for (DefinitionsDocument wsdlElement : wsdlSet) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    TDefinitions tDefinition = wsdlElement.getDefinitions();
                    TTypes[] tTypesArray = tDefinition.getTypesArray();
                    TMessage[] tMessageArray = tDefinition.getMessageArray();
                    TPortType[] tPortTypeArray = tDefinition.getPortTypeArray();
                    TBinding[] tBindingArray = tDefinition.getBindingArray();
                    TService[] tServiceArray = tDefinition.getServiceArray();
                    int position = wsdlFinal.getDefinitions().getMessageArray().length - 1;
                    for (TMessage tMessage : tMessageArray) {
                        TMessage newMessage = wsdlFinal.getDefinitions().insertNewMessage(position);
                        newMessage.set((XmlObject)tMessage);
                        ++position;
                    }
                    position = wsdlFinal.getDefinitions().getPortTypeArray().length - 1;
                    for (TMessage tMessage : tPortTypeArray) {
                        TPortType newPortType = wsdlFinal.getDefinitions().insertNewPortType(position);
                        newPortType.set((XmlObject)tMessage);
                        ++position;
                    }
                    position = wsdlFinal.getDefinitions().getBindingArray().length - 1;
                    for (TMessage tMessage : tBindingArray) {
                        TBinding newBinding = wsdlFinal.getDefinitions().insertNewBinding(position);
                        newBinding.set((XmlObject)tMessage);
                        ++position;
                    }
                    TService tService = tServiceArray[0];
                    TPort[] tPortArray = tService.getPortArray();
                    TService wsdlFinalService = wsdlFinal.getDefinitions().getServiceArray()[0];
                    position = wsdlFinal.getDefinitions().getServiceArray()[0].getPortArray().length - 1;
                    for (TPort tPort : tPortArray) {
                        TPort newTPort = wsdlFinalService.insertNewPort(position);
                        newTPort.set((XmlObject)tPort);
                        ++position;
                    }
                }
            }
            if (bSoap) {
                MetadataDocument metadataDocument = MetadataDocument.Factory.newInstance();
                this.addWSDL2Mex(wsdlFinal, metadataDocument);
                this.addXSD2Mex(wsdlFinal, metadataDocument);
                result = this.generateEnvelope(request, (XmlObject)metadataDocument);
                this.respondInSoap(response, (XmlObject)result, partnerSpId);
            } else {
                result = wsdlFinal;
                this.respondInText(response, XmlBeansUtil.xmlText((XmlObject)result));
            }
            try {
                XmlBeansUtil.validate((XmlObject)result);
            }
            catch (InvalidXmlException e) {
                this.log.debug((Object)e);
            }
        }
        catch (IllegalArgumentException | RequestProcessingException e) {
            if (e.getCause() == null) {
                this.log.error((Object)e.getMessage());
            } else {
                this.log.error((Object)(e.getMessage() + " Cause: " + e.getCause()));
            }
            if (bSoap) {
                SoapEndpointUtility.writeSoapFault(response, SoapEndpointUtility.SERVER_FAULT_CODE, e.getMessage());
            } else {
                response.sendError(400);
            }
            return;
        }
        this.log.info((Object)"Finish generation of STS metadata");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSTSRole(EntityDescriptorType entityDescriptorType, ConnectionBase connection, String partnerId, boolean bIdp, boolean forceIssuedTokenPolicy, String virtualServerId) throws RequestProcessingException {
        AttributeContract attrContract;
        Object rotationManager;
        RoleDescriptorType roleDescriptorType = entityDescriptorType.addNewRoleDescriptor();
        SecurityTokenServiceType securityTokenServiceType = (SecurityTokenServiceType)roleDescriptorType.changeType(SecurityTokenServiceType.type);
        securityTokenServiceType.setProtocolSupportEnumeration(this.supportedProtocols);
        ArrayList<X509Certificate> signingCerts = new ArrayList<X509Certificate>();
        ArrayList<String> supportedTokenTypes = new ArrayList<String>();
        if (bIdp) {
            String pendingCertAlias;
            Object pendingCert;
            String signingAlias = connection.getSigningKeyAlias();
            if (signingAlias == null) {
                throw new RequestProcessingException("Failed to find signing certificate on SP connection " + connection.getName());
            }
            PkCertManager certManager = MgmtFactory.getDsigPkCertManager();
            rotationManager = MgmtFactory.getDSignRotationSettingsManager();
            PkCert cert = certManager.getPkCert(signingAlias);
            signingCerts.add(cert.getX509Certificate());
            DSignRotationSetting rotationSetting = rotationManager.getRotationSetting(signingAlias);
            if (rotationSetting != null && StringUtils.isNotBlank((String)rotationSetting.getPendingCertAlias()) && (pendingCert = certManager.getPkCert(pendingCertAlias = rotationSetting.getPendingCertAlias())) != null) {
                signingCerts.add(((Cert)pendingCert).getX509Certificate());
            }
            supportedTokenTypes.add(NS_SAML1);
            supportedTokenTypes.add(NS_SAML2);
        } else {
            TokenGeneratorManager tokenGeneratorManager = GlobalRegistry.getService(TokenGeneratorManager.class);
            Set<String> generatorIds = ((IdpConnection)connection).getWsTrustSettings().getIncomingTokenGenerators();
            rotationManager = generatorIds.iterator();
            while (rotationManager.hasNext()) {
                String generatorId = (String)rotationManager.next();
                TokenGenerator tokenGenerator = tokenGeneratorManager.getTokenGenerator(generatorId);
                if (tokenGenerator instanceof Saml11TokenGenerator) {
                    signingCerts.add(((Saml11TokenGenerator)tokenGenerator).getSigningCert());
                    supportedTokenTypes.add(NS_SAML1);
                }
                if (!(tokenGenerator instanceof Saml20TokenGenerator)) continue;
                signingCerts.add(((Saml20TokenGenerator)tokenGenerator).getSigningCert());
                supportedTokenTypes.add(NS_SAML2);
            }
        }
        if (!supportedTokenTypes.isEmpty()) {
            TokenTypesOfferedType tokenTypesOffered = securityTokenServiceType.addNewTokenTypesOffered();
            for (String tokenTypeUri : supportedTokenTypes) {
                TokenType tokenType = tokenTypesOffered.addNewTokenType();
                tokenType.setUri(tokenTypeUri);
            }
        }
        for (X509Certificate cert : signingCerts) {
            KeyDescriptorType keyDescriptorType = securityTokenServiceType.addNewKeyDescriptor();
            keyDescriptorType.setUse(KeyTypes.SIGNING);
            KeyInfoType keyInfoType = keyDescriptorType.addNewKeyInfo();
            X509DataType x509DataType = keyInfoType.addNewX509Data();
            try {
                x509DataType.addX509Certificate(cert.getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new RequestProcessingException("Exception in adding the X509 certificate to the dynamic IDP connection", ex);
            }
        }
        boolean hasStsMetadata = true;
        ClaimType claimType = null;
        DisplayNameType displayNameType = null;
        Object attributeUri = null;
        if (bIdp) {
            WsTrustFederatedWscSettings trustSettings = ((SpConnection)connection).getWsTrustSettings();
            if (trustSettings == null) {
                hasStsMetadata = false;
                if (connection.getProtocol() != Protocol.WSFED) throw new RequestProcessingException("Federation metadata not supported for non-federation/non-ws-trust connections");
                attrContract = connection.getAttributeContract();
            } else {
                attrContract = trustSettings.getAttributeContract();
            }
        } else {
            attrContract = ((IdpConnection)connection).getWsTrustSettings().getAttributeContract();
        }
        if (attrContract != null) {
            ClaimTypesOfferedType claimTypesOfferedType = securityTokenServiceType.addNewClaimTypesOffered();
            for (String attributeName : attrContract.getAllAttributeNames()) {
                if (AssertionMapKeys.getNameIdValueKey().equals(attributeName) || AssertionMapKeys.getGenericNameIdValueKey().equals(attributeName)) {
                    attributeUri = NAME_CLAIM_URI;
                } else {
                    String attributeNamespace = attrContract.getMutableAttributesInfo().get(attributeName);
                    if (StringUtils.isBlank((String)attributeNamespace)) {
                        attributeNamespace = DEFAULT_CLAIM_URI;
                    }
                    try {
                        URI uri = new URI(attributeNamespace);
                        attributeUri = uri.isOpaque() && !attributeNamespace.endsWith(":") ? attributeNamespace + ":" + attributeName : (!uri.isOpaque() && !attributeNamespace.endsWith("/") ? attributeNamespace + "/" + attributeName : attributeNamespace + attributeName);
                    }
                    catch (URISyntaxException e) {
                        this.log.warn((Object)("Unable to parse URI: " + attributeNamespace + ". Namespace will be removed from attribute"));
                        attributeUri = attributeName;
                    }
                }
                claimType = claimTypesOfferedType.addNewClaimType();
                claimType.setUri((String)attributeUri);
                displayNameType = claimType.addNewDisplayName();
                displayNameType.setStringValue(attributeName);
                claimType.setDisplayName(displayNameType);
            }
        }
        String stsEndpointUrl = this.buildStsEndpointUrl(virtualServerId, bIdp);
        EndpointType endpointType = securityTokenServiceType.addNewSecurityTokenServiceEndpoint();
        EndpointReferenceType endpointReferenceType = endpointType.addNewEndpointReference();
        AttributedURIType address = endpointReferenceType.addNewAddress();
        address.setStringValue(stsEndpointUrl);
        if (connection.getProtocol() == Protocol.WSFED) {
            String wsFedEndpointUrl = this.buildWsFedEndpointUrl(virtualServerId, bIdp);
            EndpointType passiveEndpoint = securityTokenServiceType.addNewPassiveRequestorEndpoint();
            EndpointReferenceType passiveEndpointRef = passiveEndpoint.addNewEndpointReference();
            AttributedURIType wsfedAddress = passiveEndpointRef.addNewAddress();
            wsfedAddress.setStringValue(wsFedEndpointUrl);
        }
        if (!hasStsMetadata) return;
        String stsMexEndpointBaseUrl = this.buildStsMexEndpointUrl(virtualServerId);
        MetadataType metadataType = endpointReferenceType.addNewMetadata();
        MetadataDocument metadataDocument = MetadataDocument.Factory.newInstance();
        MetadataDocument.Metadata metadata = metadataDocument.addNewMetadata();
        MetadataSectionDocument.MetadataSection metadataSection = metadata.addNewMetadataSection();
        metadataSection.setDialect("http://schemas.xmlsoap.org/ws/2004/09/mex");
        MetadataReferenceDocument.MetadataReference metadataReference = metadataSection.addNewMetadataReference();
        String partnerIdParam = bIdp ? "PartnerSpId" : "PartnerIdpId";
        StringBuilder stsMexEndpoint = new StringBuilder(stsMexEndpointBaseUrl);
        stsMexEndpoint.append("?");
        stsMexEndpoint.append(partnerIdParam);
        stsMexEndpoint.append("=");
        stsMexEndpoint.append(partnerId);
        if (forceIssuedTokenPolicy) {
            stsMexEndpoint.append("&");
            stsMexEndpoint.append(FORCE_ISSUED_TOKEN_POLICY);
        }
        metadataReference.set(XmlObjectBuilder.element(new QName("http://www.w3.org/2005/08/addressing", "Address"), stsMexEndpoint.toString()));
        metadataType.set((XmlObject)metadataDocument);
    }

    private void addRPRole(EntityDescriptorType entityDescriptorType, ConnectionBase connection, boolean bIdp, String virtualServerId) throws RequestProcessingException {
        EncryptionSettings encryptionSettings;
        Cert cert;
        RoleDescriptorType roleDescriptorType = entityDescriptorType.addNewRoleDescriptor();
        ApplicationServiceType applicationServiceType = (ApplicationServiceType)roleDescriptorType.changeType(ApplicationServiceType.type);
        applicationServiceType.setProtocolSupportEnumeration(this.supportedProtocols);
        if (!bIdp && (cert = (encryptionSettings = connection.getEncryptionSettings()).getEncryptionCert()) != null) {
            KeyDescriptorType keyDescriptorType = applicationServiceType.addNewKeyDescriptor();
            keyDescriptorType.setUse(KeyTypes.ENCRYPTION);
            KeyInfoType keyInfoType = keyDescriptorType.addNewKeyInfo();
            X509DataType x509DataType = keyInfoType.addNewX509Data();
            try {
                x509DataType.addX509Certificate(cert.getX509Certificate().getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new RequestProcessingException("Failed to add X509 encryption certificate", ex);
            }
        }
        String stsEndpointUrl = this.buildStsEndpointUrl(virtualServerId, bIdp);
        EndpointType endpointType = applicationServiceType.addNewApplicationServiceEndpoint();
        EndpointReferenceType endpointReferenceType = endpointType.addNewEndpointReference();
        AttributedURIType address = endpointReferenceType.addNewAddress();
        address.setStringValue(stsEndpointUrl);
        endpointType = applicationServiceType.addNewTargetScopes();
        endpointReferenceType = endpointType.addNewEndpointReference();
        address = endpointReferenceType.addNewAddress();
        address.setStringValue(stsEndpointUrl);
        ClaimTypesRequestedType claimTypesRequested = applicationServiceType.addNewClaimTypesRequested();
        ClaimType claimType = claimTypesRequested.addNewClaimType();
        claimType.setUri(NAME_ID_CLAIM_URI);
        claimType.setOptional(false);
        DisplayNameType displayName = claimType.addNewDisplayName();
        displayName.setStringValue(NAME_ID);
        DescriptionType description = claimType.addNewDescription();
        description.setStringValue("The SAML name identifier of the user");
    }

    private void signXML(MetadataLocal metadataLocal, EntityDescriptorDocument entityDescriptorDocument) throws RequestProcessingException {
        PkCert signingCert;
        String alias = metadataLocal.getMetadataSigningKeyAlias();
        if (alias != null && (signingCert = MgmtFactory.getDsigPkCertManager().getPkCert(alias)) != null) {
            try {
                boolean includeCert = this.configStore.getBooleanValue(INCLUDE_CERT_IN_KEY_INFO, true);
                XmlSignatureUtil.signXml((XmlObject)entityDescriptorDocument, metadataLocal.getMetadataSigningAlgorithm(), signingCert.getPrivateKey(), signingCert.getX509Certificate(), includeCert, false, includeCert);
            }
            catch (SigningException se) {
                throw new RequestProcessingException("Exception in signing the federation metadata", se);
            }
        }
    }

    private void generateFederationMetadata(String partnerId, boolean bIdp, boolean forceIssuedTokenPolicy, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log.debug((Object)"Start generation of connection metadata");
        try {
            boolean isSamlConnection;
            MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
            ConnectionBase connection = bIdp ? metadataDirectory.getSpConnectionMetadata(partnerId) : metadataDirectory.getIdpConnectionMetadata(partnerId);
            Protocol connectionProtocol = connection.getProtocol();
            EntityDescriptorDocument entityDescriptorDocument = null;
            boolean wsFedEnabled = bIdp ? this.metadataLocal.getEnableWsFedIdP() : this.metadataLocal.getEnableWsFedSp();
            boolean isValidSamlProtocol = this.isValidSamlProtocol(bIdp, this.metadataLocal, connectionProtocol);
            boolean bl = isSamlConnection = connection.isBrowserSsoProfileConfigured() && this.isSamlConnection(connectionProtocol);
            if (!connection.isActive()) {
                throw new RequestProcessingException("Connection '" + partnerId + "' is inactive.");
            }
            if (isSamlConnection && "/pf/federation_metadata.ping".equals(this.getServletPathWithoutPathParams(request))) {
                if (!isValidSamlProtocol) {
                    String msg = String.format("SAML metadata not available for Connection '%s', EntityID: '%s'", connection.getName(), connection.getEntityId());
                    throw new RequestProcessingException(msg);
                }
                MetaDataInfo mdi = new MetaDataInfo();
                ConnectionBase tempConnection = connection instanceof IdpConnection ? new IdpConnection((IdpConnection)connection) : new SpConnection((SpConnection)connection);
                PathUtil pathUtil = MetaDataFactory.getLocalMetaData().getPathUtil();
                String virtualServerId = this.getValidVsidFromRequest(request, connection);
                if (!StringUtils.isEmpty((String)virtualServerId)) {
                    List<VirtualIdentity> entityIds = tempConnection.getVirtualIdentities();
                    for (VirtualIdentity entityId : entityIds) {
                        String configVId = entityId.getVirtualEntityId(DomainMode.CONFIGTIME);
                        String runtimeVId = entityId.getVirtualEntityId(DomainMode.RUNTIME);
                        if (configVId == null || !configVId.equals(virtualServerId) || runtimeVId == null || !runtimeVId.equals(virtualServerId)) continue;
                        tempConnection.setDefaultVirtualIdentity(entityId);
                    }
                }
                MetadataImportExportUtil.populateMetaDataInfoWithConnection(mdi, tempConnection);
                mdi.setExportIDPRole(bIdp);
                entityDescriptorDocument = MetadataImportExportUtil.exportMetadataDoc(mdi, pathUtil, false);
            } else if (wsFedEnabled) {
                if (!connection.doesWsTrustSettingsExist() && connectionProtocol != Protocol.WSFED) {
                    throw new RequestProcessingException("WS-Federation metadata not available for Connection '" + connection.getName() + "', EntityID: '" + connection.getEntityId() + "'");
                }
                entityDescriptorDocument = EntityDescriptorDocument.Factory.newInstance();
                EntityDescriptorType entityDescriptorType = entityDescriptorDocument.addNewEntityDescriptor();
                entityDescriptorType.setID(XmlIDUtil.createID());
                entityDescriptorType.setCacheDuration(MetadataLocalHelper.getConnectionExpirationData(this.metadataLocal).getCacheGDuration());
                String entityId = VirtualIdentityUtil.resolve(connection, request).getVirtualEntityId(DomainMode.RUNTIME);
                entityDescriptorType.setEntityID(entityId);
                boolean bAddSTSRole = true;
                if (!bIdp) {
                    WsTrustFederatedWspSettings wsTrustSettings = ((IdpConnection)connection).getWsTrustSettings();
                    if (wsTrustSettings == null) {
                        bAddSTSRole = false;
                    } else {
                        Collection<TokenPluginAttributeMapping> mappings = wsTrustSettings.getAssertionToTokenMappingsMappings();
                        if (mappings == null || mappings.isEmpty()) {
                            bAddSTSRole = false;
                        }
                    }
                }
                String virtualServerId = this.getValidVsidFromRequest(request, connection);
                if (bAddSTSRole) {
                    this.addSTSRole(entityDescriptorType, connection, partnerId, bIdp, forceIssuedTokenPolicy, virtualServerId);
                }
                this.addRPRole(entityDescriptorType, connection, bIdp, virtualServerId);
            } else {
                String errorMsg = "Not a SAML or a WS-Federation connection";
                response.sendError(400, errorMsg);
                return;
            }
            this.signXML(this.metadataLocal, entityDescriptorDocument);
            try {
                XmlBeansUtil.validate((XmlObject)entityDescriptorDocument);
            }
            catch (InvalidXmlException e) {
                this.log.debug((Object)e);
            }
            this.respondInText(response, XmlBeansUtil.xmlText((XmlObject)entityDescriptorDocument));
        }
        catch (IllegalArgumentException | RequestProcessingException e) {
            if (e.getCause() == null) {
                this.log.error((Object)e.getMessage());
            } else {
                this.log.error((Object)(e.getMessage() + " Cause: " + e.getCause()));
            }
            response.sendError(400);
            return;
        }
        this.log.info((Object)"Finish generation of connection metadata");
    }

    private String getValidVsidFromRequest(HttpServletRequest request, ConnectionBase connection) {
        String virtualServerId = VirtualIdentityUtil.resolve(connection, request).getVirtualEntityId(DomainMode.RUNTIME);
        if (VirtualIdentityUtil.extractVsid(request) == null) {
            virtualServerId = null;
        }
        return virtualServerId;
    }

    private boolean isSamlConnection(Protocol connectionProtocol) {
        return connectionProtocol.equals(Protocol.SAML10) || connectionProtocol.equals(Protocol.SAML11) || connectionProtocol.equals(Protocol.SAML20);
    }

    private boolean isValidSamlProtocol(boolean bIdp, MetadataLocal metadataLocal, Protocol connectionProtocol) {
        boolean isSpEnabled;
        boolean validProtocol = false;
        boolean isValidIdp = bIdp && MetadataLocalHelper.isEnableIdp(metadataLocal);
        boolean bl = isSpEnabled = !bIdp && MetadataLocalHelper.isEnableSp(metadataLocal);
        if (!isValidIdp && !isSpEnabled) {
            return false;
        }
        switch (connectionProtocol) {
            case SAML10: {
                if (isValidIdp && metadataLocal.getEnableSaml10Ap()) {
                    validProtocol = true;
                    break;
                }
                if (!isSpEnabled || !metadataLocal.getEnableSaml10Rp()) break;
                validProtocol = true;
                break;
            }
            case SAML11: {
                if (isValidIdp && metadataLocal.getEnableSaml11Ap()) {
                    validProtocol = true;
                    break;
                }
                if (!isSpEnabled || !metadataLocal.getEnableSaml11Rp()) break;
                validProtocol = true;
                break;
            }
            case SAML20: {
                if (isValidIdp && metadataLocal.getEnableSaml20IdP()) {
                    validProtocol = true;
                    break;
                }
                if (!isSpEnabled || !metadataLocal.getEnableSaml20Sp()) break;
                validProtocol = true;
                break;
            }
        }
        return validProtocol;
    }

    private String formatFileToString(String filePath) throws IOException {
        try (FileInputStream stream = new FileInputStream(new File(filePath));){
            byte[] bytes;
            byte[] buf = new byte[4096];
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);){
                int i;
                while ((i = stream.read(buf)) > -1) {
                    bos.write(buf, 0, i);
                }
                bytes = bos.toByteArray();
            }
            ByteBuffer bb = bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65 ? ByteBuffer.wrap(bytes, 3, bytes.length - 3) : ByteBuffer.wrap(bytes, 0, bytes.length);
            String string = Charset.forName("UTF-8").decode(bb).toString();
            return string;
        }
    }

    private String getServletPathWithoutPathParams(HttpServletRequest req) {
        PathUtil pathUtil = this.metadataLocal.getPathUtil();
        return pathUtil.stripPathParams(req.getServletPath());
    }

    private String buildStsEndpointUrl(String virtualServerId, boolean bIdp) {
        String stsEndpoint = bIdp ? this.metadataLocal.getIdpWsTrustStsEndpoint() : this.metadataLocal.getSpWsTrustStsEndpoint();
        return this.buildProtocolEndpointUrl(stsEndpoint, virtualServerId);
    }

    private String buildWsFedEndpointUrl(String virtualServerId, boolean bIdp) {
        String wsFedEndpoint = bIdp ? this.metadataLocal.getIdpWsFedEndpoint() : this.metadataLocal.getSpWsFedEndpoint();
        return this.buildProtocolEndpointUrl(wsFedEndpoint, virtualServerId);
    }

    private String buildStsMexEndpointUrl(String virtualServerId) {
        return this.buildProtocolEndpointUrl("/pf/sts_mex.ping", virtualServerId);
    }

    private String buildProtocolEndpointUrl(String endpoint, String virtualServerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(BaseUrlUtil.getCurrentBaseUrl(this.metadataLocal.getBaseUrl()));
        if (StringUtils.isBlank((String)virtualServerId)) {
            sb.append(endpoint);
        } else {
            HashMap<String, Object> pathParams = new HashMap<String, Object>();
            pathParams.put("vsid", virtualServerId);
            sb.append(this.metadataLocal.getPathUtil().encodeParamMap(endpoint, pathParams));
        }
        return sb.toString();
    }

    String getRequestUrlReadyForXsdQueryParam(HttpServletRequest request) {
        StringBuffer xsdUrl = request.getRequestURL();
        String query = request.getQueryString();
        xsdUrl.append('?');
        if (StringUtils.isNotEmpty((String)query)) {
            int queryPart1End = -1;
            while ((queryPart1End = query.indexOf("xsd=", queryPart1End + 1)) > 0 && query.charAt(queryPart1End - 1) != '&') {
            }
            if (queryPart1End >= 0) {
                int queryPart2Start;
                if (queryPart1End > 0) {
                    xsdUrl.append(query.substring(0, queryPart1End));
                }
                if ((queryPart2Start = query.indexOf(38, queryPart1End)) >= 0) {
                    xsdUrl.append(query.substring(queryPart2Start + 1));
                    xsdUrl.append('&');
                }
            } else {
                xsdUrl.append(query);
                xsdUrl.append('&');
            }
        }
        return xsdUrl.toString();
    }

    private static class WindowsTransportBindingCounters {
        int windowsTransportBindingBindingNum = 0;
        int windowsTransportBindingPortNum = 0;
        int windowsTransportBinding2005BindingNum = 0;
        int windowsTransportBinding2005PortNum = 0;

        private WindowsTransportBindingCounters() {
        }
    }

    static class WsTrustStsMetadataRequestCreatorConfig {
        private final Log log = LogFactory.getLog(this.getClass());
        private String defaultStsWsdlTemplate = "sts.xml";
        private String defaultUsernamePolicyTemplate = "username.xml";
        Map<String, WsTrustStsPartnerResponseConfig> partnerIdMetadataResponseMap = new HashMap<String, WsTrustStsPartnerResponseConfig>();
        private static final String CUSTOMIZE_METADATA_RESPONSE_KEY = "Enabled";
        private static final String DEFAULT_WSDL_FILE_KEY = "DefaultStsWsdl";
        private static final String DEFAULT_USERNAME_POLICY_TEMPLATE_KEY = "DefaultUsernamePolicyTemplate";
        private static final String STS_WSDL_TEMPLATES = "StsWsdlTemplates";
        private static final String USERNAME_POLICY_TEMPLATES = "UsernamePolicyTemplates";
        public static WsTrustStsMetadataRequestCreatorConfig instance = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WsTrustStsMetadataRequestCreatorConfig getInstance() {
            Class<WsTrustStsMetadataRequestCreatorConfig> clazz = WsTrustStsMetadataRequestCreatorConfig.class;
            synchronized (WsTrustStsMetadataRequestCreatorConfig.class) {
                if (instance == null) {
                    instance = new WsTrustStsMetadataRequestCreatorConfig();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private WsTrustStsMetadataRequestCreatorConfig() {
            ConfigStore wsTrustConfigStore = ConfigStoreFarm.getConfig("org.sourceid.websso.profiles.WsTrustStsMetadataRequestCreator");
            Set<String> keysList = wsTrustConfigStore.getKeys();
            for (String key : keysList) {
                try {
                    if (key.equals(DEFAULT_USERNAME_POLICY_TEMPLATE_KEY)) {
                        this.defaultUsernamePolicyTemplate = wsTrustConfigStore.getStringValue(key);
                        continue;
                    }
                    if (key.equals(DEFAULT_WSDL_FILE_KEY)) {
                        this.defaultStsWsdlTemplate = wsTrustConfigStore.getStringValue(key);
                        continue;
                    }
                    Map spIDConfigMap = wsTrustConfigStore.getMapValue(key);
                    boolean customizeMetadataResponse = Boolean.valueOf((String)spIDConfigMap.get(CUSTOMIZE_METADATA_RESPONSE_KEY));
                    String usernamePolicyTemplates = (String)spIDConfigMap.get(USERNAME_POLICY_TEMPLATES);
                    HashSet<String> usernamePolicySet = new HashSet<String>();
                    if (usernamePolicyTemplates != null && !usernamePolicyTemplates.isEmpty()) {
                        String[] usernamePolicyTemplate = usernamePolicyTemplates.split(",");
                        Collections.addAll(usernamePolicySet, usernamePolicyTemplate);
                    }
                    if (StringUtils.isBlank((String)usernamePolicyTemplates)) {
                        this.log.warn((Object)("Using default username.xml policy template as org.sourceid.websso.profiles.WsTrustStsMetadataRequestCreator config file does not contain valid config for UsernamePolicyTemplates item for key: " + key));
                        usernamePolicySet.add(this.defaultUsernamePolicyTemplate);
                    }
                    String stsTemplates = (String)spIDConfigMap.get(STS_WSDL_TEMPLATES);
                    LinkedHashSet<String> stsTemplateSet = new LinkedHashSet<String>();
                    if (stsTemplates != null && !stsTemplates.isEmpty()) {
                        String[] stsTemplate = stsTemplates.split(",");
                        stsTemplateSet.addAll(Arrays.asList(stsTemplate));
                    }
                    if (StringUtils.isBlank((String)stsTemplates)) {
                        this.log.warn((Object)("Using default sts.xml sts template as org.sourceid.websso.profiles.WsTrustStsMetadataRequestCreator config file does not contain valid config for StsWsdlTemplates item for key: " + key));
                        stsTemplateSet.add(this.defaultStsWsdlTemplate);
                    }
                    WsTrustStsPartnerResponseConfig wsTrustStsPartnerResponseConfig = new WsTrustStsPartnerResponseConfig(this.defaultUsernamePolicyTemplate, customizeMetadataResponse, stsTemplateSet, usernamePolicySet);
                    this.partnerIdMetadataResponseMap.put(key, wsTrustStsPartnerResponseConfig);
                }
                catch (NoSuchValueException noSuchValueException) {}
            }
        }

        public boolean isPartnerIdConfigured(String partnerSpId) {
            return this.partnerIdMetadataResponseMap.containsKey(partnerSpId);
        }

        public WsTrustStsPartnerResponseConfig getWsTrustStsPartnerResponseConfig(String partnerSpId) {
            return this.partnerIdMetadataResponseMap.get(partnerSpId);
        }

        public String getDefaulStsWsdlTemplate() {
            return this.defaultStsWsdlTemplate;
        }

        public String getDefaultUsernamePolicyTemplate() {
            return this.defaultUsernamePolicyTemplate;
        }
    }

    static class WsTrustStsPartnerResponseConfig {
        private String defaultUsernamePolicyTemplate;
        private boolean enabled;
        private Set<String> stsWsdlTemplates;
        private Set<String> usernamePolicyTemplates;

        public WsTrustStsPartnerResponseConfig(String defaultUsernamePolicyTemplate, boolean enabled, Set<String> stsWsdlTemplates, Set<String> usernamePolicyTemplates) {
            this.defaultUsernamePolicyTemplate = defaultUsernamePolicyTemplate;
            this.enabled = enabled;
            this.stsWsdlTemplates = stsWsdlTemplates;
            this.usernamePolicyTemplates = usernamePolicyTemplates;
        }

        public String getDefaultUsernamePolicyTemplate() {
            return this.defaultUsernamePolicyTemplate;
        }

        public Set<String> getStsWsdlTemplates() {
            return this.stsWsdlTemplates;
        }

        public Set<String> getUsernamePolicyTemplates() {
            return this.usernamePolicyTemplates;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    static class TokenProcessorMeta {
        private String tokenProcessorInstanceId;
        private String tokenProcessorType;
        private String tokenProcessorPolicyId;

        TokenProcessorMeta() {
        }

        public String getTokenProcessorInstanceId() {
            return this.tokenProcessorInstanceId;
        }

        public void setTokenProcessorInstanceId(String tokenProcessorInstanceId) {
            this.tokenProcessorInstanceId = tokenProcessorInstanceId;
        }

        public String getTokenProcessorType() {
            return this.tokenProcessorType;
        }

        public void setTokenProcessorType(String tokenProcessorType) {
            this.tokenProcessorType = tokenProcessorType;
        }

        public String getTokenProcessorPolicyId() {
            return this.tokenProcessorPolicyId;
        }

        public void setTokenProcessorPolicyId(String tokenProcessorPolicyId) {
            this.tokenProcessorPolicyId = tokenProcessorPolicyId;
        }
    }
}

