/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import com.pingidentity.monitoring.elements.impl.PFMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.profiles.BasicHttpRequestHandler;

public abstract class HeartbeatBasicHttpRequestHandler
implements BasicHttpRequestHandler {
    private static final String CHECK_ACTIVE_QUERY_PARAM = "checkActive";
    private final boolean enableSystemMonitoringResults = Boolean.parseBoolean(System.getProperty("pf.heartbeat.system.monitoring", "false"));

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (MgmtFactory.getAdminNodeConfigManager().isEnabledAndPassiveNode()) {
            String checkActiveParam = request.getParameter(CHECK_ACTIVE_QUERY_PARAM);
            boolean isCheckActive = Boolean.TRUE.toString().equals(checkActiveParam);
            if (isCheckActive) {
                response.sendError(403);
                return;
            }
        }
        if (!Boolean.TRUE.toString().equals(System.getProperty("pf.jetty.started"))) {
            response.sendError(503);
            return;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (this.enableSystemMonitoringResults) {
            PFMonitor monitor = new PFMonitor(this.getMonitorResults());
            results.put("monitor", (Object)monitor);
            results.put("heartbeatSystemMonitoring", this.enableSystemMonitoringResults);
        }
        ResponseTemplateRenderer templateRenderer = ResponseTemplateRenderer.getInstance();
        if (this.enableSystemMonitoringResults) {
            templateRenderer.render(request, response, this.getHeartbeatTemplateFile(), results, "application/json", true);
        } else {
            templateRenderer.render(request, response, this.getHeartbeatTemplateFile(), results, "text/html", true);
        }
    }

    abstract String getHeartbeatTemplateFile();

    abstract Map<String, Object> getMonitorResults();
}

