/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.xmlbinding.protocol.StatusType;
import org.sourceid.websso.profiles.ReferenceableInvalidResponseException;

public class InvalidSsoResponseException
extends ReferenceableInvalidResponseException {
    private static final long serialVersionUID = 1L;
    private TopLevelStatusCode topLevelStatusCode;
    private List<String> secondLevelStatusCodes = new ArrayList<String>();
    private StatusType statusType;

    public InvalidSsoResponseException(String message) {
        super(message, "SSO_FAILED", "errorDetail.ssoFailed");
    }

    public InvalidSsoResponseException(String message, Throwable cause) {
        this(message);
        this.initCause(cause);
    }

    public InvalidSsoResponseException(TopLevelStatusCode topLevelStatusCode, List<String> secondLevelStatusCodes, StatusType statusType) {
        this(InvalidSsoResponseException.buildMessage(topLevelStatusCode, secondLevelStatusCodes, statusType));
        this.topLevelStatusCode = topLevelStatusCode;
        this.secondLevelStatusCodes = secondLevelStatusCodes;
        this.statusType = statusType;
    }

    public TopLevelStatusCode getTopLevelStatusCode() {
        return this.topLevelStatusCode;
    }

    public List<String> getSecondLevelStatusCodes() {
        return this.secondLevelStatusCodes;
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    private static String buildMessage(TopLevelStatusCode topLevelStatusCode, List<String> secondLevelStatusCodes, StatusType status) {
        StringBuilder msg = new StringBuilder("Nonsuccess Response status: ").append(topLevelStatusCode);
        for (String secondLevelStatusCode : secondLevelStatusCodes) {
            msg.append(" Subordinate status: ").append(secondLevelStatusCode);
        }
        if (status.isSetStatusMessage()) {
            msg.append(" Status Message: ").append(status.getStatusMessage());
        }
        return msg.toString();
    }
}

