/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles;

import com.pingidentity.common.util.TrackedParamsUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.profiles.ProfileProcessMgmtService;
import org.sourceid.saml20.state.ReqAttrSetCheckingStateSupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.profiles.NoSuchProcessException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ProtocolResponseObject;
import org.sourceid.websso.profiles.RequestCreatorBase;
import org.sourceid.websso.profiles.ResumableRequestCreator;
import org.sourceid.websso.profiles.ResumeRequestFromResponseHandler;
import org.sourceid.websso.profiles.StatefulHandler;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public abstract class ResumableRequestCreatorBase
extends RequestCreatorBase
implements ResumableRequestCreator,
StatefulHandler,
ResumeRequestFromResponseHandler {
    private final BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
    private final ProfileProcessMgmtService processMgmtSvc = GlobalRegistry.getService(ProfileProcessMgmtService.class);
    private final StateSupport stateSupport = new ReqAttrSetCheckingStateSupport();

    protected abstract String getResumePathQualifier(OutMessageContext var1);

    protected abstract OutMessageContext doResume(OutMessageContext var1, HttpServletRequest var2, HttpServletResponse var3, Map<String, Object> var4) throws IOException, GeneralAdapterException;

    protected OutMessageContext resume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        try {
            return this.doResume(reqMsgCtx, req, resp, params);
        }
        catch (GeneralAdapterException e) {
            throw new ProcessRuntimeException(e);
        }
    }

    protected void doResumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) {
    }

    @Override
    public OutMessageContext resume(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        String key = this.stateSupport.getStateKey(req, resp);
        State state = StateMgmtFactory.retrieveAndRemoveState(key, true, req, resp);
        OutMessageContext reqMsgCtx = state.getOutMsgCtx();
        Map<String, Object> params = state.getParameters();
        return this.resume(reqMsgCtx, req, resp, params);
    }

    @Override
    public void resumeFromResponse(ProtocolResponseObject responseObject, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) throws IOException {
        this.doResumeFromResponse(responseObject, respMsgCtx, reqMsgCtx, req, resp, originalState);
        OutMessageContext outMsgCtx = this.resume(originalState.getOutMsgCtx(), req, resp, originalState.getParameters());
        if (outMsgCtx != null) {
            try {
                InMessageContext inMsgCtx = this.bindingSvc.transportRequest(req, resp, outMsgCtx);
                if (inMsgCtx != null) {
                    this.processMgmtSvc.doHandleResponse(outMsgCtx, inMsgCtx, req, resp);
                }
            }
            catch (BindingException | NoSuchProcessException | HttpStatusCodeException | RedirectException | RenderPageException e) {
                throw new ProcessRuntimeException(e);
            }
        }
    }

    @Override
    public String saveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> params) {
        return this.stateSupport.saveState(req, resp, inMsgCtx, outMsgCtx, params, this.getResumePathQualifier(outMsgCtx));
    }

    protected String saveState(HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) {
        return this.saveState(req, resp, null, outMsgCtx, params);
    }

    public void addTrackedParams(HttpServletRequest req, Map<String, Object> stateParams) {
        TrackedParamsUtil trackedParamsUtil = new TrackedParamsUtil();
        trackedParamsUtil.addTrackedParamsToState(req, stateParams);
    }
}

