/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;

public class ClientRegistrationAuditLogger
extends AuditLogger {
    private static final Log log = LogFactory.getLog(ClientRegistrationAuditLogger.class);
    public static final String CLIENT_CREATED = "Client Created";
    public static final String CLIENT_DELETED = "Client Deleted";
    public static final String CLIENT_UPDATED = "Client Updated";
    public static final String CLIENT_RETRIEVED = "Client Retrieved";
    public static final String OAUTH = "OAuth";
    public static final String OAUTH20 = "OAuth20";
    public static final String CLIENT_REGISTER = "ClientRegister";

    public static void log(String msg) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ROLE.toString(), (String)"AS");
        if (ClientRegistrationAuditLogger.isDescriptionBlank()) {
            ClientRegistrationAuditLogger.setDescription(msg);
        }
        ClientRegistrationAuditLogger.setEvent(OAUTH);
        ClientRegistrationAuditLogger.setProtocol(OAUTH20);
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)CLIENT_REGISTER);
        ClientRegistrationAuditLogger.updateResponseTime();
        ClientRegistrationAuditLogger.log(log, "");
    }

    public static void setClientId(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.PARTNER_ID.toString(), (String)value);
        }
    }

    public static void setAccessTokenTrackingId(String at) {
        if (StringUtils.isNotBlank((String)at)) {
            String atTrackingId = TrackingIdSupport.generateAtTrackingIdForPA(at);
            ThreadContext.put((String)AuditLogger.MDC_KEY.AT_TRACKING_ID.toString(), (String)atTrackingId);
        }
    }

    public static void setInXmlMessage(String msg) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)msg);
    }

    public static void setOutXmlMessage(String msg) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)msg);
    }

    public static void setAttributes(Map<String, AttributeValue> attributes) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.ATTRIBUTES.toString(), (String)ClientRegistrationAuditLogger.getAttributesAsString(attributes));
    }

    public static String getAttributesAsString(Map<String, AttributeValue> attributeMap) {
        LinkedList<String> keyValue = new LinkedList<String>();
        if (attributeMap != null) {
            for (Map.Entry<String, AttributeValue> entry : attributeMap.entrySet()) {
                keyValue.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        return Util.listToDelimString(keyValue, ",");
    }
}

