/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.profiles.idp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.profiles.idp.BaseSloTemplateRenderer;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;

public class SloTemplateRenderer
extends BaseSloTemplateRenderer {
    private static final Log log = LogFactory.getLog(SloTemplateRenderer.class);

    public SloTemplateRenderer(HttpServletRequest req, HttpServletResponse resp, boolean includeSamlSps) {
        this.buildTemplateState(req, resp, includeSamlSps);
    }

    public SloTemplateRenderer(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public void renderTemplate(String targetResource, String errorResumeUrl, HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put("requestUrl", req.getRequestURL());
        objMap.put("wsfIdpList", this.getWsFedIdpSignoutUrlList());
        objMap.put("spList", this.getWsFedSpSignoutCleanupUrlList());
        objMap.put("idpHost", req.getServerName());
        objMap.put("idpLogoutSuccess", this.isIdpLogoutSuccess());
        Map saml2SpList = (Map)this.params.get("saml2splist");
        objMap.put("saml2SpList", saml2SpList);
        boolean hasSaml2Sp = false;
        if (saml2SpList != null && !saml2SpList.isEmpty()) {
            hasSaml2Sp = true;
        }
        objMap.put("hasSaml2Sp", hasSaml2Sp);
        objMap.put("oidcEndpointList", this.getOidcLogoutUrlList());
        objMap.put("oidcFCLogoutEndpointList", this.getOidcFCLogoutUrlList());
        if (!StringUtils.isBlank((String)targetResource)) {
            objMap.put("wreply", targetResource);
        }
        if (!StringUtils.isBlank((String)errorResumeUrl)) {
            objMap.put("errorWreply", errorResumeUrl);
        }
        try {
            this.logWsFedOidcLogoutUrls();
            this.setTemplateRendered(true);
            this.renderer.render(req, resp, "sourceid-wsfed-idp-signout-cleanup-template.html", objMap);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error rendering signout cleanup form.", ex);
        }
    }

    private void buildTemplateState(HttpServletRequest req, HttpServletResponse resp, boolean includeSamlSps) {
        List<WebSsoSession> issuedSaml2Sessions;
        BaseSloTemplateRenderer.SessionInfo sessionInfo = this.saveAndUnregisterWsFedAndOidcSessions(req, resp);
        SLOSupport sloSupport = new SLOSupport(this.localMetaData);
        if (includeSamlSps && (issuedSaml2Sessions = sloSupport.getProtocolSessions(sessionInfo.getIssuedSessions(), Protocol.SAML20)).size() > 0) {
            HashMap<String, String> saml2SpList = new HashMap<String, String>();
            for (WebSsoSession session : issuedSaml2Sessions) {
                String spEntityId = session.getEntityId();
                SpConnection spConnectionMetadata = this.metadataDirectory.getSpConnectionMetadata(spEntityId);
                Endpoint endpoint = spConnectionMetadata.getPreferredSingleLogoutService();
                saml2SpList.put(spEntityId, this.getHost(endpoint));
            }
            this.params.put("saml2splist", saml2SpList);
        }
        this.securityAuditLog(sessionInfo);
    }

    private String getHost(Endpoint endpoint) {
        String host = "";
        String urlStr = endpoint.getFullLocation();
        try {
            URL url = new URL(urlStr);
            host = url.getHost();
        }
        catch (MalformedURLException ex) {
            log.error((Object)("Invalid endpoint " + endpoint));
        }
        return host;
    }

    protected void securityAuditLog(BaseSloTemplateRenderer.SessionInfo sessionInfo) {
        this.logIdpWsFedSessions(sessionInfo);
        Session firstSession = null;
        String protocol = null;
        if (!Util.isEmpty(sessionInfo.getIssuedWsFedSpSessions())) {
            firstSession = sessionInfo.getIssuedWsFedSpSessions().get(0);
            protocol = Protocol.WSFED.toString();
        } else if (!Util.isEmpty(sessionInfo.getIssuedOidcSessions())) {
            firstSession = sessionInfo.getIssuedOidcSessions().get(0);
            protocol = Protocol.OIDC.toString();
        }
        if (firstSession != null) {
            AuditLogger.setProtocol(protocol);
            if (firstSession.getWebSsoSession() != null) {
                String virtualServerId = firstSession.getWebSsoSession().getVirtualServerId();
                AuditLogger.setVirtualServerId(virtualServerId);
            }
            AuditLogger.setUserName(firstSession.getUserNameForLog());
            AuditLogger.setPartnerId(firstSession.getPartnerId());
            AuditLogger.setEvent("SLO");
            String message = "logout";
            if (firstSession.isOidcSession()) {
                AsAuditLogger.log(message);
            } else {
                IdpAuditLogger.log(message);
            }
        }
    }
}

